/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.intelidata.contrato;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.domain.pojo.enuns.QuantidadeCampoExtra;
import br.intelidata.commons.domain.pojo.enuns.TipoAgendamentoContratoVenda;
import br.intelidata.commons.domain.pojo.vendas.ContratoVenda;
import br.intelidata.commons.modulo.contrato.regranegocio.ContratoVendaRN;
import br.intelidata.commons.modulo.intelidata.regranegocio.ContratoVendaAgendamentoRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.ConfiguracaoCampoExtra;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.thread.JobExecutorService;
import br.intelidata.uniplusweb.web.rest.app.crud.contrato.ContratoCrudController;
import br.intelidata.uniplusweb.web.rest.app.intelidata.contrato.ContratoIntelidataCrudController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@ConfiguracaoCampoExtra(TABELA="cad_contratovenda", QUANTIDADE=QuantidadeCampoExtra.CONTRATO_VENDA)
@RestController
@RequestMapping(value={"/api/contratos-intelidata"})
public class ContratoIntelidataCrudController
extends ContratoCrudController {
    private final TaskManager taskManager;

    public ContratoIntelidataCrudController(JobExecutorService jobExecutorService, TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @RequestMapping(value={"/cancelar-versao-paf"})
    @DBTransaction
    public void cancelarVersaoUnipafSefaz(@RequestParam Long idContrato) throws UnicoMensagemUsuarioException {
        ContratoVendaRN.getInstance().cancelarVersaoUnipafSefaz(SessaoUtil.getSessao(), idContrato);
    }

    protected String getCacheId() {
        return "contratos-intelidata_ID_FILIAL_" + SessaoUtil.getSessao().getIdFilial();
    }

    protected void permiteBloquearContrato(ContratoVenda contratoVenda) throws UnicoMensagemUsuarioException {
        ContratoVendaAgendamentoRN.getInstance().verificarSeExisteAgendamentoAtivoPorIdContrato(contratoVenda.getId());
    }

    protected void permiteEncerrarContrato(ContratoVenda contratoVenda) throws UnicoMensagemUsuarioException {
        ContratoVendaAgendamentoRN.getInstance().verificarSeExisteAgendamentoAtivoPorIdContrato(contratoVenda.getId());
    }

    protected void bloquearContrato(ContratoVenda contrato, Long idMotivo, String justificativa) throws UnicoMensagemUsuarioException {
        this.agendar(TipoAgendamentoContratoVenda.BLOQUEIO, contrato, idMotivo, justificativa);
    }

    protected void encerrarContrato(ContratoVenda contrato, Long idMotivo, String justificativa) throws UnicoMensagemUsuarioException {
        this.agendar(TipoAgendamentoContratoVenda.ENCERRAMENTO, contrato, idMotivo, justificativa);
    }

    private void agendar(TipoAgendamentoContratoVenda tipoAgendamentoContratoVenda, ContratoVenda contratoVenda, Long idMotivo, String observacao) throws UnicoMensagemUsuarioException {
        ContratoVendaAgendamentoRN.getInstance().gravarAgendamento(SessaoUtil.getSessao(), contratoVenda.getId(), tipoAgendamentoContratoVenda, SessaoUtil.getSessao().getIdUsuario(), DataHoraFactory.getData().plusDays(10L), idMotivo, observacao);
    }

    @DBTransaction
    public void reativarContrato(Long idContrato, int diasAberto, Long idMotivo, String observacao) throws UnicoMensagemUsuarioException {
        super.reativarContrato(idContrato, diasAberto, idMotivo, observacao);
        this.criaTaskReativarContrato(idContrato);
    }

    private void criaTaskReativarContrato(Long idContrato) throws UnicoMensagemUsuarioException {
        1 i = new /* Unavailable Anonymous Inner Class!! */;
        i.createTask((Object)idContrato);
    }

    static /* synthetic */ TaskManager access$000(ContratoIntelidataCrudController x0) {
        return x0.taskManager;
    }
}

