/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.intelidata.report.planilhacomercial;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.modulo.intelidata.relatorio.PlanilhaComercialRelatorio;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.intelidata.report.planilhacomercial.PlanilhaComercial;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipOutputStream;

public class PlanilhaComercialReportExecuter
extends AbstractReporteExecute<PlanilhaComercial> {
    public PlanilhaComercialReportExecuter(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        PlanilhaComercial planilhaComercial = (PlanilhaComercial)this.fromJson(parametrosObj, PlanilhaComercial.class);
        return this.executa(sessao, planilhaComercial);
    }

    public Remessa executa(Sessao sessao, PlanilhaComercial parametros) throws UnicoMensagemUsuarioException {
        File arquivoTemporario;
        Malote malote = new PlanilhaComercialRelatorio().gerarWeb(parametros.getExtensao());
        try {
            arquivoTemporario = File.createTempFile("Planilhas.zip", ".zip");
            arquivoTemporario.deleteOnExit();
            try (FileOutputStream fos = new FileOutputStream(arquivoTemporario);
                 ZipOutputStream zipOut = new ZipOutputStream(fos);){
                for (Map.Entry entry : malote.getMapArquivos().entrySet()) {
                    FileUtil.comprimirArquivoEmMemoria((ZipOutputStream)zipOut, (byte[])((byte[])entry.getValue()), (String)((String)entry.getKey()));
                }
                zipOut.closeEntry();
            }
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW301", e.getMessage());
        }
        Malote m = new Malote();
        m.incluiArquivo(parametros.getSaidaRelatorio().getFormato(), arquivoTemporario);
        return new Remessa(m);
    }
}

