/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.compras.sugestaocompra;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.enuns.UnidadeTempoSugestaoCompra;
import br.intelidata.commons.modulo.custo.regranegocio.CustoMedioDiarioRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.estoque.relatorio.SugestaoComprasRelatorio;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.report.compras.sugestaocompra.SugestaoCompra;
import java.util.Collections;
import java.util.List;

public class SugestaoCompraReportExecute
extends AbstractReporteExecute<SugestaoCompra> {
    public SugestaoCompraReportExecute(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        SugestaoCompra parametros = (SugestaoCompra)this.fromJson(parametrosObj, SugestaoCompra.class);
        return this.executa(sessao, parametros);
    }

    public Remessa executa(Sessao sessao, SugestaoCompra sugestaoCompra) throws UnicoMensagemUsuarioException {
        List<Filial> filial = Collections.singletonList(Contexto.getInstance().getSessao().getFilial());
        CustoMedioDiarioRN.getInstance().validarCustoMedio(sugestaoCompra.getTipoCalculoCusto(), sugestaoCompra.getPeriodoInicial(), sugestaoCompra.getPeriodoFinal(), filial);
        Entidade fornecedor = (Entidade)EntidadeRN.getInstance().buscarPorId(sugestaoCompra.getIdFornecedor());
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(sugestaoCompra.getIdProduto());
        return new SugestaoComprasRelatorio().getRelatorio(SessaoUtil.getSessao(), sugestaoCompra.getSaida(), sugestaoCompra.getPeriodo().intValue(), Boolean.valueOf(sugestaoCompra.isSugestaoMaiorZero()), Boolean.valueOf(sugestaoCompra.isApenasComVendas()), sugestaoCompra.getPeriodoInicial(), sugestaoCompra.getPeriodoFinal(), sugestaoCompra.getIdGrupo(), produto, fornecedor, sugestaoCompra.getIdFamilia(), sugestaoCompra.getOrdenacao(), sugestaoCompra.getTipoCalculoCusto(), Boolean.valueOf(sugestaoCompra.isSujestaoInsumo()), Boolean.valueOf(UnidadeTempoSugestaoCompra.MESES.equals((Object)sugestaoCompra.getTipoPeriodo())), Boolean.valueOf(sugestaoCompra.isConsiderarEstoqueAtual()), Boolean.valueOf(sugestaoCompra.isExibeVariacao()), Boolean.valueOf(sugestaoCompra.isSomenteFornecedoresAtivos()), sugestaoCompra.getIdFabricante(), sugestaoCompra.getIdMarca());
    }
}

