/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.financeiro.fechamentoecf;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.pafecf.FechamentoPdv;
import br.intelidata.commons.domain.regranegocio.FechamentoPdvCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.commons.modulo.financeiro.relatorio.FechamentoPdvAgupadoRelatorio;
import br.intelidata.commons.modulo.financeiro.relatorio.FechamentoPdvRelatorio;
import br.intelidata.commons.modulo.financeiro.relatorio.fechamento.novo.FechamentoPdvParam;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.report.financeiro.fechamentoecf.FechamentoECF;

public class FechamentoECFReportExecuter
extends AbstractReporteExecute<FechamentoECF> {
    public FechamentoECFReportExecuter(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        FechamentoECF fechamentoECF = (FechamentoECF)this.fromJson(parametrosObj, FechamentoECF.class);
        return this.executa(sessao, fechamentoECF);
    }

    public Remessa executa(Sessao sessao, FechamentoECF parametros) throws UnicoMensagemUsuarioException {
        FechamentoPdvParam param = new FechamentoPdvParam();
        if (parametros.getCodigoFechamento() > 0L) {
            FechamentoPdv fechamento = (FechamentoPdv)FechamentoPdvCommonRN.getInstance().buscarPorCodigo(String.valueOf(parametros.getCodigoFechamento()));
            if (fechamento == null) {
                throw new UnicoMensagemUsuarioException("WPDV1428", "Fechamento c\u00f3digo " + parametros.getCodigoFechamento() + " n\u00e3o encontrado");
            }
            param.setIdFechamento(fechamento.getId());
        } else {
            param.setFilial(sessao.getCodigoFilial());
            param.setPeriodoInicial(parametros.getPeriodoInicial());
            param.setPeriodoFinal(parametros.getPeriodoFinal());
            param.setPdv(parametros.getNumeroEcf().intValue());
            Usuario usuario = UsuarioRN.getInstance().buscarPorId(parametros.getIdUsuario());
            if (usuario != null) {
                param.setUsuario(usuario.getCodigo());
            }
        }
        param.setDetalharSangrias(parametros.isDetalharSangrias());
        param.setDetalharAdms(parametros.isDetalharAdms());
        param.setDetalharCarteirasDigitais(parametros.isDetalharCarteirasDigitais());
        param.setDetalharSuprimentos(parametros.isDetalharSuprimentos());
        param.setDetalharBandeiras(parametros.isDetalharBandeira());
        if (parametros.isAgruparPorUsuario()) {
            return new FechamentoPdvAgupadoRelatorio(param).imprimir(parametros.getSaida());
        }
        return new FechamentoPdvRelatorio(param).imprimir(parametros.getSaida());
    }
}

