/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.vendas.produtosemvenda;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.FamiliaProduto;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.contabil.MesFiscal;
import br.intelidata.commons.modulo.custo.regranegocio.CustoMedioDiarioRN;
import br.intelidata.commons.modulo.custo.regranegocio.CustoMedioMensalRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.produto.regranegocio.FamiliaProdutoRN;
import br.intelidata.commons.modulo.vendas.relatorio.ProdutosSemVendaRelatorio;
import br.intelidata.commons.sped.fiscal.TipoCalculoCusto;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.report.vendas.produtosemvenda.ProdutoSemVenda;
import java.time.LocalDate;

public class ProdutoSemVendaReportExecuter
extends AbstractReporteExecute<ProdutoSemVenda> {
    public ProdutoSemVendaReportExecuter(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        ProdutoSemVenda produtoSemVenda = (ProdutoSemVenda)this.fromJson(parametrosObj, ProdutoSemVenda.class);
        return this.executa(sessao, produtoSemVenda);
    }

    public Remessa executa(Sessao sessao, ProdutoSemVenda parametros) throws UnicoMensagemUsuarioException {
        FamiliaProduto familia;
        Entidade fornecedor = parametros.getIdFornecedor() != null ? (Entidade)EntidadeRN.getInstance().buscarPorId(parametros.getIdFornecedor()) : null;
        Long vendedor = parametros.getIdVendedor() != null ? parametros.getIdVendedor() : 0L;
        FamiliaProduto familiaProduto = familia = parametros.getIdFamilia() != null ? (FamiliaProduto)FamiliaProdutoRN.getInstance().buscarPorId(parametros.getIdFamilia()) : null;
        if (TipoCalculoCusto.CUSTO_MEDIO_ATUAL.equals((Object)parametros.getTipoCusto())) {
            LocalDate dataBaseFinal;
            if (parametros.getDataInicio() == null) {
                throw new UnicoMensagemUsuarioException("WVND62", "Por favor informe o per\u00edodo inicial.");
            }
            LocalDate dataBaseInicial = parametros.getDataInicio().withDayOfMonth(1);
            LocalDate localDate = dataBaseFinal = parametros.getDataFim() == null ? DataHoraFactory.getData().withDayOfMonth(1) : parametros.getDataFim().withDayOfMonth(1);
            while (dataBaseInicial.compareTo(dataBaseFinal) < 1) {
                String ano = String.valueOf(dataBaseInicial.getYear());
                MesFiscal mes = (MesFiscal)EnumUtils.getPorId(MesFiscal.class, (Object)dataBaseInicial.getMonthValue());
                if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CUSTO_MEDIO_MENSAL)) {
                    if (CustoMedioMensalRN.getInstance().isExisteRegistrosPendentesDeCalculo(Contexto.getInstance().getFilial().getIdEmpresa(), ano, mes)) {
                        throw new UnicoMensagemUsuarioException("WVND63", "Existe c\u00e1lculo de custo m\u00e9dio pendente no per\u00edodo especificado. Por favor verifique.");
                    }
                } else if (CustoMedioDiarioRN.getInstance().isExisteRegistrosPendentesDeCalculo(((Filial)parametros.getFiliais().get(0)).getId(), ano, mes)) {
                    throw new UnicoMensagemUsuarioException("WVND58", "Existe c\u00e1lculo de custo m\u00e9dio pendente no per\u00edodo especificado. Por favor verifique.");
                }
                dataBaseInicial = dataBaseInicial.plusMonths(1L);
            }
        }
        return new ProdutosSemVendaRelatorio().getRelatorio(parametros.getFiliais(), parametros.getDataInicio(), parametros.getDataFim(), parametros.getIdHierarquia(), fornecedor, vendedor, parametros.getIdFamilia(), familia != null ? familia.getNome() : null, parametros.getTipoCusto().getIdInt(), parametros.isImprimirProdutos(), parametros.getSaida(), null, parametros.getIdFabricante(), parametros.getIdMarca(), parametros.getCompraInicio(), parametros.getCompraFim());
    }
}

