/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.vendas.vendaspornotafiscal;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.JSONUtil;
import br.intelidata.commons.domain.pojo.ConfiguracaoCampos;
import br.intelidata.commons.modulo.cadastros.regranegocio.ConfiguracaoCamposRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.web.rest.app.client.report.Report;
import br.intelidata.uniplusweb.web.rest.app.report.vendas.vendaspornotafiscal.VendasPorNotaFiscal;
import br.intelidata.uniplusweb.web.rest.app.report.vendas.vendaspornotafiscal.VendasPorNotaFiscalReportExecuter;
import org.json.JSONObject;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/vendas-por-nota-fiscal"})
@SubMenuMapping(MENU="SubMenuFiscalRelatorio", NOME="Vendas por nota fiscal", ICONE="icon-imprimir", ROTA="/reports-vendas/vendas-por-nota-fiscal", PROGRAMA=120)
public class VendasPorNotaFiscalReportController
extends Report<VendasPorNotaFiscal> {
    protected String nomeTabelaRelatorio() {
        return "vendas-por-nota-fiscal";
    }

    @DBAutoCommit
    public VendasPorNotaFiscal get() throws UnicoMensagemUsuarioException {
        ConfiguracaoCampos configuracaoCampos = ConfiguracaoCamposRN.getInstance().buscarPorIdFilialTabela(SessaoUtil.getSessao().getIdFilial(), this.nomeTabelaRelatorio());
        VendasPorNotaFiscal vendasPorNotaFiscal = new VendasPorNotaFiscal();
        vendasPorNotaFiscal.setPeriodoInicial(DataHoraFactory.getLocalDateInicioMes());
        vendasPorNotaFiscal.setPeriodoFinal(DataHoraFactory.getLocalDateFimMes());
        if (configuracaoCampos != null) {
            VendasPorNotaFiscal venda = (VendasPorNotaFiscal)JSONUtil.getObject((JSONObject)configuracaoCampos.getCamposSerializados(), VendasPorNotaFiscal.class);
            vendasPorNotaFiscal.setCfop(venda.getCfop());
        }
        return vendasPorNotaFiscal;
    }

    public boolean isPersistir() {
        return true;
    }

    public Class<? extends AbstractJob> job() {
        return VendasPorNotaFiscalReportExecuter.class;
    }
}

