/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.service;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.ModuloManager;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.SGBDManager;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Controle;
import br.intelidata.commons.domain.regranegocio.ConfiguradorModuloCommonRN;
import br.intelidata.commons.domain.regranegocio.ControleRN;
import br.intelidata.uniplusweb.core.service.BackupService;
import br.intelidata.uniplusweb.core.service.CacheService;
import br.intelidata.uniplusweb.service.LicencaService;
import br.intelidata.uniplusweb.web.rest.app.wrapper.PreferenciasBackupWrapper;
import org.springframework.stereotype.Service;

@Service
public class AtualizacaoBaseDadosService {
    private final LicencaService licencaService;
    private final CacheService cacheService;
    private final BackupService backupService;

    public AtualizacaoBaseDadosService(LicencaService licencaService, CacheService cacheService, BackupService backupService) {
        this.licencaService = licencaService;
        this.cacheService = cacheService;
        this.backupService = backupService;
    }

    public void atualizacaoBaseDados(String tenant) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessaoSistema();
        SGBDManager.getInstance().atualizarBaseNovo(sessao, false);
        Controle controle = ControleRN.getInstance().buscar();
        PreferenciasBackupWrapper preferenciasBackupWrapper = this.backupService.carregarPreferencias(sessao);
        controle.setDiasBackup(preferenciasBackupWrapper.getDiasBackup());
        controle.setDataHora(preferenciasBackupWrapper.isDataHora());
        controle.setRazaoSocial(preferenciasBackupWrapper.isRazaoSocial());
        controle.setExclusaoAuditoria(preferenciasBackupWrapper.isExclusaoAuditoria());
        controle.setConsiderarTamanhoMenorErro(preferenciasBackupWrapper.isConsiderarTamanhoMenorErro());
        if (controle.getDiasBackup() <= 0) {
            controle.setDiasBackup(15);
        }
        ControleRN.getInstance().alterar((AbstractPojo)controle, sessao);
        this.licencaService.getSistema();
        ConfiguradorModuloCommonRN.getInstance().montarModulosWeb(sessao);
        ModuloManager.getInstance().recarregarPreferencias(sessao);
        this.cacheService.clear();
    }
}

