/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.security.oauth2;

import br.intelidata.uniplusweb.security.oauth2.CustomClientDetailsService;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class CustomClientDetailsService
implements ClientDetailsService {
    private static final String SELECT_CLIENTE_DETAIL_SQL = "select codigo,secret,inativo from tenant where codigo = ?";
    private static final String RESOURCE_ID = "uniplusweb";
    private static final int ACCESS_TOKEN = 86400;
    private static final int REFRESH_TOKEN = 2592000;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private PasswordEncoder passwordEncoder;

    public ClientDetails loadClientByClientId(String clientId) throws ClientRegistrationException {
        if ("logtracker".equals(clientId)) {
            BaseClientDetails details = new BaseClientDetails("logtracker", RESOURCE_ID, "jobs-admin", "client_credentials", "", "");
            details.setClientSecret(this.passwordEncoder.encode((CharSequence)"l4gtr1ck2radm3ncl3ents2rv2r"));
            details.setAccessTokenValiditySeconds(Integer.valueOf(86400));
            details.setRefreshTokenValiditySeconds(Integer.valueOf(2592000));
            return details;
        }
        if ("unipluswebclient".equals(clientId)) {
            BaseClientDetails details = new BaseClientDetails();
            details.setClientId(clientId);
            details.setClientSecret(this.passwordEncoder.encode((CharSequence)"fbac505d-6866-44b2-b976-9afed1e17f94"));
            details.setResourceIds((Collection)StringUtils.commaDelimitedListToSet((String)RESOURCE_ID));
            details.setAuthorizedGrantTypes((Collection)StringUtils.commaDelimitedListToSet((String)"password,refresh_token"));
            details.setScope((Collection)StringUtils.commaDelimitedListToSet((String)"web"));
            details.setAccessTokenValiditySeconds(Integer.valueOf(86400));
            details.setRefreshTokenValiditySeconds(Integer.valueOf(2592000));
            return details;
        }
        if ("uniplusmobile".equals(clientId)) {
            BaseClientDetails details = new BaseClientDetails();
            details.setClientId(clientId);
            details.setClientSecret(this.passwordEncoder.encode((CharSequence)"ace471a4-06d0-4dd6-b0fb-1d336b39fdf2"));
            details.setResourceIds((Collection)StringUtils.commaDelimitedListToSet((String)RESOURCE_ID));
            details.setAuthorizedGrantTypes((Collection)StringUtils.commaDelimitedListToSet((String)"password,refresh_token"));
            details.setScope((Collection)StringUtils.commaDelimitedListToSet((String)"public-api"));
            details.setAccessTokenValiditySeconds(Integer.valueOf(86400));
            details.setRefreshTokenValiditySeconds(Integer.valueOf(2592000));
            return details;
        }
        if ("uniplusshop".equals(clientId)) {
            BaseClientDetails details = new BaseClientDetails();
            details.setAuthorizedGrantTypes(Collections.singleton("client_credentials"));
            details.setClientId(clientId);
            details.setClientSecret(this.passwordEncoder.encode((CharSequence)"cbb57250-5f44-424c-abab-30ef40019448"));
            details.setResourceIds((Collection)StringUtils.commaDelimitedListToSet((String)RESOURCE_ID));
            details.setScope((Collection)StringUtils.commaDelimitedListToSet((String)"shop"));
            details.setAccessTokenValiditySeconds(Integer.valueOf(86400));
            details.setRefreshTokenValiditySeconds(Integer.valueOf(2592000));
            return details;
        }
        try {
            BaseClientDetails details = (BaseClientDetails)this.jdbcTemplate.queryForObject(SELECT_CLIENTE_DETAIL_SQL, (RowMapper)new ClientDetailsRowMapper(null), new Object[]{clientId});
            if (details != null) {
                details.setClientSecret(this.passwordEncoder.encode((CharSequence)details.getClientSecret()));
                details.setAccessTokenValiditySeconds(Integer.valueOf(86400));
                details.setRefreshTokenValiditySeconds(Integer.valueOf(2592000));
                return details;
            }
            throw new NoSuchClientException("Tenant n\u00e3o existe");
        }
        catch (EmptyResultDataAccessException ex) {
            throw new NoSuchClientException("Tenant n\u00e3o existe");
        }
    }
}

