/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service;

import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Email;
import javax.activation.DataSource;
import javax.inject.Inject;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class MailService {
    private final Logger log = LoggerFactory.getLogger(MailService.class);
    @Inject
    private JavaMailSenderImpl javaMailSender;

    @Async
    public void sendEmail(String para, String assunto, String conteudo, boolean multipart, boolean html) {
        this.log.debug("Envia email[multipart '{}' e html '{}'] para '{}' com assunto '{}' e conte\u00fado={}", new Object[]{multipart, html, para, assunto, conteudo});
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        try {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, multipart);
            message.setTo(para);
            message.setFrom("do-not-reply@uniplusweb.com");
            message.setSubject(assunto);
            message.setText(conteudo, html);
            this.javaMailSender.send(mimeMessage);
            this.log.debug("Email enviado para '{}'", (Object)para);
        }
        catch (Exception e) {
            this.log.error("Email n\u00e3o foi enviado para '{}', exce\u00e7\u00e3o: {}", (Object)para, (Object)e.getMessage());
        }
    }

    @Async
    public void sendEmailDefault(Sessao sessao, String para, String assunto, String mensagem, DataSource ... sources) {
        try {
            Email.enviar((Sessao)sessao, (String)para, null, (String)assunto, (String)mensagem, (DataSource[])sources, null, (boolean)false);
            this.log.debug("Email enviado para '{}'", (Object)para);
        }
        catch (Exception e) {
            this.log.warn("Email n\u00e3o foi enviado para '{}', exce\u00e7\u00e3o: {}", (Object)para, (Object)e.getMessage());
        }
    }
}

