/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.batch.dao;

import br.intelidata.commons.core.sql.Sql;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.batch.TaskStatus;
import br.intelidata.commons.domain.pojo.enuns.batch.TypeQueue;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.Periodo;
import br.intelidata.uniplusweb.web.rest.app.batch.dao.AbstractWebDAO;
import br.intelidata.uniplusweb.web.rest.app.batch.dao.SqlWeb;
import br.intelidata.uniplusweb.web.rest.app.batch.wrappers.FiltroAvancadoWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Repository;

@Repository
public class TaskRepository
extends AbstractWebDAO<Task> {
    public String getTabela() {
        return "task";
    }

    public void update(Task task) {
        SqlWeb sql = new SqlWeb(this.getUpdateSQL());
        int numeroCampos = this.setValoresSql(1, (Sql)sql, this.getAtributos(), (Object)task, null, false);
        sql.setLong(numeroCampos, task.getId());
        sql.executaQuery();
        sql.close();
    }

    public Task save(Task task) {
        task.setCurrentTimeMillis(Long.valueOf(System.currentTimeMillis()));
        SqlWeb sql = new SqlWeb(this.getInsertSQL());
        this.setValoresSql(1, (Sql)sql, this.getAtributos(), (Object)task, null, false);
        task.setId((Long)sql.executaValorQuery(s -> sql.getLong("id")));
        return task;
    }

    public List<Task> findByTaskStatus(String ami, TaskStatus ... taskStatus) {
        Integer[] status = (Integer[])Arrays.stream(taskStatus).map(TaskStatus::getId).toArray(Integer[]::new);
        ArrayList<Condicao> listCondiao = new ArrayList<Condicao>();
        listCondiao.add(new Condicao("taskstatus", Operador.CONTIDO_EM, status));
        if (!StringUtil.stringNullOrEmpty((String)ami)) {
            listCondiao.add(new Condicao("amiinstancia", Operador.IGUAL, ami));
        }
        return this.buscarLista(new Ordem("t0", true), listCondiao.toArray(new Condicao[0]));
    }

    public Task findByUuid(String uuid) {
        return (Task)this.buscarPor(new Condicao[]{new Condicao("uuid", Operador.IGUAL, uuid)});
    }

    public Task findById(Long idTask) {
        return (Task)this.buscarPor(new Condicao[]{new Condicao("id", Operador.IGUAL, idTask)});
    }

    public List<Task> findTasksToProcess(TaskStatus taskStatus, int limit, String ami) {
        ArrayList<Long> ids = new ArrayList<Long>();
        String condicaoAmi = "";
        if (ami != null) {
            condicaoAmi = "and amiinstancia = ? ";
        }
        String strSql = this.select() + " left join taskqueue q on (q.code=t.queue) where t.taskstatus = ? and q.paused=0 " + condicaoAmi + "order by q.priority,t.t0 limit ?";
        SqlWeb sql = new SqlWeb(strSql);
        sql.setInt(1, taskStatus.getId().intValue());
        if (ami != null) {
            sql.setString(2, ami);
            sql.setInt(3, limit);
        } else {
            sql.setInt(2, limit);
        }
        sql.executaQuery();
        while (sql.next()) {
            ids.add(sql.getLong("id"));
        }
        sql.close();
        if (!Util.listNullOrEmpty(ids)) {
            return this.buscarLista(new Condicao[]{new Condicao("id", Operador.CONTIDO_EM, ids.toArray(new Long[0]))});
        }
        return new ArrayList<Task>();
    }

    public List<Task> findRecurringTasks(String className) {
        return this.buscarLista(new Condicao[]{new Condicao("taskstatus", Operador.CONTIDO_EM, new Integer[]{TaskStatus.INACTIVE.getId(), TaskStatus.PAUSE_SCHEDULE.getId()}), new Condicao("classname", Operador.IGUAL, className)});
    }

    public Task findByTenantAndIdFilial(String tenant, String idFilial) {
        return (Task)this.buscarPor(new Condicao[]{new Condicao("tenant", Operador.IGUAL, tenant), new Condicao("metadata", Operador.CONTEM, "idFilial=" + idFilial)});
    }

    public boolean existeJobVersaoAgendado(String versao) {
        return this.buscarPor(new Condicao[]{new Condicao("tipojob", Operador.IGUAL, TipoJob.DOWNLOAD_VERSAO.getId().intValue()), new Condicao("taskstatus", Operador.CONTIDO_EM, new Integer[]{TaskStatus.ENQUEUED.getId(), TaskStatus.PROCESSING.getId()}), new Condicao("resumo", Operador.IGUAL, versao)}) != null;
    }

    public Task buscarUltimoTaskCargaBase(String metadata, String tenant) {
        ArrayList<Condicao> condicoes = new ArrayList<Condicao>();
        condicoes.add(new Condicao("tipojob", Operador.IGUAL, TipoJob.CARGA_BASE.getId().intValue()));
        condicoes.add(new Condicao("metadata", Operador.IGUAL, metadata));
        condicoes.add(new Condicao("tenant", Operador.IGUAL, tenant));
        return (Task)this.buscarPor(1, new Ordem("id", true), condicoes.toArray(new Condicao[0]));
    }

    public boolean existeProcessoPendente(TipoJob ... tipoJob) {
        Integer[] ids = (Integer[])Stream.of(tipoJob).map(TipoJob::getId).toArray(Integer[]::new);
        return this.buscarPor(new Condicao[]{new Condicao("tipojob", Operador.CONTIDO_EM, ids), new Condicao("taskstatus", Operador.CONTIDO_EM, new Integer[]{TaskStatus.ENQUEUED.getId(), TaskStatus.PROCESSING.getId()})}) != null;
    }

    public List<Task> getOldTasks() {
        ArrayList<Long> ids = new ArrayList<Long>();
        String select = "select id from task where taskstatus <> 5 and extract(days from localtimestamp-t0) > 30 and url <> ''";
        SqlWeb sql = new SqlWeb(select);
        sql.executaQuery();
        while (sql.next()) {
            ids.add(sql.getLong("id"));
        }
        sql.close();
        if (!Util.listNullOrEmpty(ids)) {
            return this.buscarLista(new Condicao[]{new Condicao("id", Operador.CONTIDO_EM, ids.toArray(new Long[0]))});
        }
        return new ArrayList<Task>();
    }

    public void deleteOldTasks(int days) {
        String delete = "delete from task where taskstatus <> 5 and extract(days from localtimestamp-t0) > " + days;
        SqlWeb sql = new SqlWeb(delete);
        sql.executaUpdate();
        sql.close();
    }

    public void changeTaskStatuses(TaskStatus from, TaskStatus to) {
        String strSql = "update task set taskstatus = ? where taskstatus = ?";
        SqlWeb sql = new SqlWeb(strSql);
        sql.setInt(1, to.getId().intValue());
        sql.setInt(2, from.getId().intValue());
        sql.executaUpdate();
        sql.close();
    }

    public boolean verificaSeExistePorTipoTenant(TipoJob tipo, String tenant, boolean considerarFila) {
        Task t;
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ids.add(TaskStatus.PROCESSING.getId());
        if (considerarFila) {
            ids.add(TaskStatus.ENQUEUED.getId());
        }
        return (t = (Task)this.buscarPor(new Condicao[]{new Condicao("taskstatus", Operador.CONTIDO_EM, ids.toArray(new Integer[0])), new Condicao("tipojob", Operador.IGUAL, tipo.getId().intValue()), new Condicao("tenant", Operador.IGUAL, tenant)})) != null;
    }

    private String select() {
        String campos = Arrays.stream(Task.class.getDeclaredFields()).filter(field -> !field.getName().equalsIgnoreCase("id") && !field.getName().equalsIgnoreCase("name") && !field.getName().equalsIgnoreCase("proxima") && !field.getName().equalsIgnoreCase("excecao")).map(field -> field.getName().toLowerCase()).collect(Collectors.joining(", "));
        return "select t.id, t.name, " + campos + " from task t";
    }

    public List<Task> filtrarGrid(FiltroAvancadoWrapper filtro) {
        ArrayList condicoes = new ArrayList();
        filtro.getFilterField().forEach(filterField -> {
            if (filterField.getField().equalsIgnoreCase("taskStatus")) {
                List<String> values = Arrays.asList(filterField.getValues());
                if (!StringUtil.stringNullOrEmpty((String)filterField.getValue1()) && !filterField.getValue1().equals("TODOS")) {
                    values = Collections.singletonList(filterField.getValue1());
                }
                if ("TODOS".equals(filterField.getValue1())) {
                    condicoes.add(new Condicao("taskStatus", Operador.NAO_CONTIDO_EM, new Integer[]{TaskStatus.SCHEDULED.getId(), TaskStatus.INACTIVE.getId(), TaskStatus.PAUSE_SCHEDULE.getId(), TaskStatus.INVISIBLE.getId()}));
                } else if (!ListMapUtil.listNullOrEmpty(values)) {
                    List<String> finalValues = values;
                    condicoes.add(new Condicao("taskStatus", Operador.CONTIDO_EM, (Integer[])Stream.of(TaskStatus.class.getEnumConstants()).filter(constant -> finalValues.contains(constant.name())).map(TaskStatus::getId).toArray(Integer[]::new)));
                }
            }
            if (filterField.getField().equalsIgnoreCase("metadata")) {
                condicoes.add(new Condicao("metadata", Operador.CONTEM, filterField.getValue1()));
            }
            if (filterField.getField().equalsIgnoreCase("tipoJob") && !filterField.getValue1().equals("UNDEFINED")) {
                Stream.of(TipoJob.class.getEnumConstants()).filter(constant -> filterField.getValue1().equalsIgnoreCase(constant.name())).findFirst().ifPresent(tipoJob -> condicoes.add(new Condicao("tipojob", Operador.IGUAL, tipoJob.getId().intValue())));
            }
            if (filterField.getField().equalsIgnoreCase("fila") && !filterField.getValue1().equals("UNDEFINED")) {
                Stream.of(TypeQueue.class.getEnumConstants()).filter(constant -> filterField.getValue1().equalsIgnoreCase(constant.name())).findFirst().ifPresent(queue -> condicoes.add(new Condicao("queue", Operador.IGUAL, queue.getId())));
            }
            if (filterField.getField().equalsIgnoreCase("tenant")) {
                condicoes.add(new Condicao("tenant", Operador.IGUAL, filterField.getValue1()));
            }
            if (filterField.getField().equalsIgnoreCase("periodo")) {
                Arrays.stream(Periodo.values()).filter(periodo -> !Objects.equals(periodo.getId(), Periodo.TODOS.getId()) && periodo.name().equalsIgnoreCase(filterField.getValue1())).findFirst().ifPresent(p -> condicoes.add(new Condicao("t0", Operador.MAIOR_IGUAL_QUE, p.getFiltro())));
            }
        });
        return this.buscarLista(new Ordem("t0", true), condicoes.toArray(new Condicao[0]));
    }
}

