/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.batch.serices;

import br.intelidata.api.batch.ITask;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.batch.TaskStatus;
import br.intelidata.uniplusweb.core.spring.aop.baseUniplusWeb.DBTransactionCore;
import br.intelidata.uniplusweb.core.spring.multitenant.Tenant;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import br.intelidata.uniplusweb.web.rest.app.batch.dao.TaskRepository;
import br.intelidata.uniplusweb.web.rest.app.batch.wrappers.FiltroAvancadoWrapper;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class TaskService
implements ITask {
    private final TenantService tenantService;
    private final TaskRepository taskRepository;

    public TaskService(TenantService tenantService, TaskRepository taskRepository) {
        this.tenantService = tenantService;
        this.taskRepository = taskRepository;
    }

    @DBTransactionCore
    public void update(Task task) {
        this.taskRepository.update(task);
    }

    @DBTransactionCore
    public Task saveTask(Task task) {
        return this.taskRepository.save(task);
    }

    @DBTransactionCore
    public void deleteOldTasks(int days) {
        this.taskRepository.deleteOldTasks(days);
    }

    @DBTransactionCore
    public List<Task> getOldTasks() {
        return this.taskRepository.getOldTasks();
    }

    @DBTransactionCore
    public void inactiveAllRecurringJobsBlocked() {
        this.taskRepository.changeTaskStatuses(TaskStatus.SCHEDULED, TaskStatus.INACTIVE);
        this.taskRepository.changeTaskStatuses(TaskStatus.PROCESSING, TaskStatus.DELETED);
    }

    @DBTransactionCore
    public List<Task> getRecurringTasksBlocked(String className) {
        return this.taskRepository.findRecurringTasks(className);
    }

    @DBTransactionCore
    public Task getTask(UUID uuid) {
        return this.taskRepository.findByUuid(uuid.toString());
    }

    @DBTransactionCore
    public Task findById(Long id) {
        return this.taskRepository.findById(id);
    }

    @DBTransactionCore
    public List<Task> getTasksToProcessBlocked(TaskStatus taskStatus, int limit, String ami) {
        return this.taskRepository.findTasksToProcess(taskStatus, limit, ami);
    }

    public Task findByTenantAndIdFilial(String tenant, String idFilial) {
        return this.taskRepository.findByTenantAndIdFilial(tenant, idFilial);
    }

    @DBTransactionCore
    public List<Task> getTasks(String ami, TaskStatus ... taskStatus) {
        return this.taskRepository.findByTaskStatus(ami, taskStatus);
    }

    @DBTransactionCore
    public List<Task> getTasks(FiltroAvancadoWrapper filtro) {
        return this.taskRepository.filtrarGrid(filtro);
    }

    public List<String> getTenants() {
        return this.tenantService.getTenants(true).stream().map(Tenant::getCodigo).collect(Collectors.toList());
    }

    @DBTransactionCore
    public boolean existeJobVersaoAgendado(String versao) {
        return this.taskRepository.existeJobVersaoAgendado(versao);
    }

    @DBTransactionCore
    public Task buscarUltimoTaskCargaBase(String metadata, String tenant) {
        return this.taskRepository.buscarUltimoTaskCargaBase(metadata, tenant);
    }

    @DBTransactionCore
    public boolean existeProcessoPendente(TipoJob ... tipoJob) {
        return this.taskRepository.existeProcessoPendente(tipoJob);
    }

    @DBTransactionCore
    public boolean verificaSeExistePorTipoTenant(TipoJob tipo, String tenant, boolean considerarFila) {
        return this.taskRepository.verificaSeExistePorTipoTenant(tipo, tenant, considerarFila);
    }
}

