/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.crud;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.annotations.FileWeb;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import java.io.IOException;
import java.lang.reflect.Field;
import org.springframework.web.multipart.MultipartFile;

public interface CrudFile<Entity extends AbstractPojo> {
    public TipoArquivoArmazenado getTipoArmazenamento();

    public StorageService getStorageService();

    public boolean isGravarArquivoTabela();

    default public void loadFile(MultipartFile[] files, Entity entity) throws UnicoMensagemUsuarioException {
        for (MultipartFile file : files) {
            Object[] split;
            String originalName = file.getOriginalFilename();
            if (StringUtil.stringNullOrEmpty((String)originalName) || ListMapUtil.arrayNullOrEmpty((Object[])(split = originalName.split("\\|")))) continue;
            try {
                Object fieldName = split[0];
                Field field = entity.getClass().getDeclaredField((String)fieldName);
                if (field == null) continue;
                FileWeb fileWeb = field.getAnnotation(FileWeb.class);
                if (fileWeb == null) {
                    throw new UnicoMensagemUsuarioException("WWW424", "Atributo n\u00e3o definido para o caminho da imagem [" + (String)fieldName + "]");
                }
                String url = fileWeb.IMAGEM() ? this.getStorageService().saveImagem(ContextoHolder.getTenant(), this.getTipoArmazenamento(), file) : this.getStorageService().saveFile(ContextoHolder.getTenant(), this.getTipoArmazenamento(), file, false);
                BeanUtil.set(entity, (String)fileWeb.ATRIBUTO(), (Object)url);
                if (!this.isGravarArquivoTabela()) continue;
                BeanUtil.set(entity, (String)fieldName, (Object)file.getBytes());
            }
            catch (IOException | NoSuchFieldException e) {
                throw new UnicoMensagemUsuarioException("WWW425", "N\u00e3o foi poss\u00edvel atribuir os arquivos: " + e.getMessage());
            }
        }
    }
}

