/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.report;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.PreferenciaUsuario;
import br.intelidata.commons.modulo.cadastros.regranegocio.PreferenciaUsuarioRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReport;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public abstract class ReportController<WrapperReport extends AbstractReport> {
    protected ResponseEntityService responseService;

    public ReportController(ResponseEntityService responseService) {
        this.responseService = responseService;
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public ResponseEntity<byte[]> gerarRelatorio(@RequestBody WrapperReport wrapperReport) throws UnicoMensagemUsuarioException {
        this.gravarPreferencias(wrapperReport);
        return this.getReport(wrapperReport);
    }

    protected abstract ResponseEntity<byte[]> getReport(WrapperReport var1) throws UnicoMensagemUsuarioException;

    private void gravarPreferencias(WrapperReport wrapper) throws UnicoMensagemUsuarioException {
        String saida = wrapper.getSaidaRelatorio().getDescricao();
        if (wrapper.getSaidaRelatorio() == SaidaRelatorio.ARQUIVO_TEXTO_DELIMITADO || wrapper.getSaidaRelatorio() == SaidaRelatorio.ARQUIVO_TEXTO_FORMATADO) {
            saida = "ARQUIVO_TEXTO";
        }
        PreferenciaUsuario preferenciaUsuario = SessaoUtil.getSessao().getUsuario().getPreferenciaUsuario();
        preferenciaUsuario.setTipoSaidaRelatorio(saida);
        preferenciaUsuario.setDelimitadorRelatorio(wrapper.getDelimitador());
        preferenciaUsuario.setOpcaoSaidaRelatorio(wrapper.getOpcaoSaidaRelatorio());
        preferenciaUsuario.setOrientacaoSaidaRelatorio(wrapper.isPaisagem() ? 1 : 0);
        PreferenciaUsuarioRN.getInstance().salvaPreferenciasUsuario(SessaoUtil.getSessao(), preferenciaUsuario);
    }
}

