/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.schedulers;

import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.batch.TypeQueue;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.enums.TipoArmazenamentoArquivo;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.batch.serices.TaskService;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.AbstractPrepareScheduler;
import java.util.List;

public class DeleteOldTasksPermanentlyScheduler
extends AbstractPrepareScheduler {
    private final TaskService taskService = (TaskService)BeanUtil.getBean((String)"taskService");
    private final StorageService storageService = (StorageService)BeanUtil.getBean((String)"storageService");
    private final UnipluswebProperties unipluswebProperties = (UnipluswebProperties)BeanUtil.getBean((String)"uniplusweb-br.intelidata.uniplusweb.config.UnipluswebProperties");

    public DeleteOldTasksPermanentlyScheduler() {
        super("Limpeza de tarefas antigas", Cron.daily((int)1), TypeQueue.RECURRING_QUEUE.getId(), TipoJob.JOB_CLEANUP);
    }

    public void execute() throws Exception {
        List tasks = this.taskService.getOldTasks();
        tasks.forEach(task -> {
            if (this.unipluswebProperties.getAmbiente().getTipoArmazenamentoArquivo() == TipoArmazenamentoArquivo.arquivo) {
                this.storageService.excluirArquivo(this.getTask().getTenant(), TipoArquivoArmazenado.JobExecutor, task.getUrl(), false);
            }
        });
        this.storageService.deleteShareFiles(30);
        this.taskService.deleteOldTasks(30);
    }

    public void onFailure(Exception ex) {
    }

    public boolean isAtivo() {
        return true;
    }
}

