/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.thread;

import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.JobExecutor;
import br.intelidata.commons.domain.pojo.JobExecutorFile;
import br.intelidata.commons.modulo.cadastros.regranegocio.JobExecutorFileRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.JobExecutorRN;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.enums.TipoArmazenamentoArquivo;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Job;
import java.util.List;

class JobCleanup
extends Job {
    private final StorageService storageService;
    private final UnipluswebProperties unipluswebProperties;
    private final int dias;

    public JobCleanup(StorageService storageService, UnipluswebProperties unipluswebProperties, String tenant, Long idUsuario, Long idFilial, int dias) {
        super("JobsCleanup", tenant, idUsuario, idFilial);
        this.storageService = storageService;
        this.unipluswebProperties = unipluswebProperties;
        this.dias = dias;
    }

    public void execute() throws Exception {
        Sessao sessao = this.getSessao();
        List jobs = JobExecutorRN.getInstance().getJobExecutorAntigos(this.dias);
        for (JobExecutor job : jobs) {
            List files = JobExecutorFileRN.getInstance().getArquivosPorIdJobExecutor(job.getId());
            for (JobExecutorFile file : files) {
                if (this.unipluswebProperties.getAmbiente().getTipoArmazenamentoArquivo() == TipoArmazenamentoArquivo.arquivo) {
                    this.storageService.excluirArquivo(this.getTenant(), TipoArquivoArmazenado.JobExecutor, file.getUrl(), false);
                }
                JobExecutorFileRN.getInstance().excluir((AbstractPojo)file, sessao);
            }
            JobExecutorRN.getInstance().excluir((AbstractPojo)job, sessao);
        }
    }
}

