/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.thread;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.JobExecutor;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReportParams;
import br.intelidata.uniplusweb.web.rest.app.client.thread.JobPersistent;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import java.io.File;
import java.lang.reflect.Method;

public class JobReport
extends JobPersistent {
    private static final String DESERIALIZE = "deserialize";
    private Remessa remessa;
    private String formato;

    public JobReport(String nome, String classe, String parametroSerializado, String detalhes, String tenant, Long idUsuario, Long idFilial, boolean recreate, boolean gzip) throws UnicoMensagemUsuarioException {
        super(nome, TipoJob.REPORT, classe, parametroSerializado, detalhes, tenant, idUsuario, idFilial, recreate, gzip, null);
    }

    public static JobReport recreate(JobExecutor jobExecutor, String tenant) throws UnicoMensagemUsuarioException {
        JobReport jobReport = new JobReport(jobExecutor.getNome(), jobExecutor.getClasse(), jobExecutor.getParametrosSerializado(), jobExecutor.getResumoFiltros(), tenant, jobExecutor.getIdUsuario(), jobExecutor.getIdFilial(), true, jobExecutor.isGzip());
        jobReport.setJobId(jobExecutor.getId());
        return jobReport;
    }

    public void execute() throws Exception {
        String parametro = super.getParametroSerializado();
        AbstractReportParams abstractReportParams = (AbstractReportParams)this.getObjetoDeserializado(AbstractReportParams.class);
        this.formato = abstractReportParams.getSaidaRelatorio().getFormato();
        Class<?> classe = Class.forName(super.getClasse());
        Method metodo = classe.getMethod(DESERIALIZE, Sessao.class, String.class);
        this.remessa = (Remessa)metodo.invoke(classe.newInstance(), super.getSessao(), parametro);
    }

    protected Notificacao getNotificacaoSucesso(JobExecutor jobExecutor) {
        return new Notificacao("Relat\u00f3rio \"" + jobExecutor.getNome() + "\" foi gerado com sucesso");
    }

    protected Notificacao getNotificacaoErro(JobExecutor jobExecutor) {
        return new Notificacao("N\u00e3o foi poss\u00edvel gerar o relat\u00f3rio \"" + jobExecutor.getResumoFiltros() + "\"");
    }

    protected File getFile() {
        return (File)this.remessa.getMalote().getMapArquivos().get(this.formato);
    }
}

