/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.ajusteestoque;

import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AjusteEstoque;
import br.intelidata.commons.domain.pojo.AjusteEstoqueItem;
import br.intelidata.commons.domain.pojo.MotivoAjusteEstoque;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.modulo.estoque.regranegocio.AjusteEstoqueItemRN;
import br.intelidata.commons.modulo.estoque.regranegocio.AjusteEstoqueRN;
import br.intelidata.commons.modulo.estoque.regranegocio.MotivoAjusteEstoqueRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.VariacaoRN;
import br.intelidata.uniplusweb.core.coreinterfaces.ValidationSaldoEstoqueInterface;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="ajustes-estoque-saldo")
public class AjusteEstoqueValidationSaldo
implements ValidationSaldoEstoqueInterface {
    public BigDecimal getQuantidadeVendida(Long id, Long idItemAtual, Long idProduto, List<Long> idsLotes, String valor, boolean kit, List<Long> idsItensIgnorados) {
        if (!NumberUtil.longNullOuZero((Long)id)) {
            AjusteEstoque ajusteEstoque = (AjusteEstoque)AjusteEstoqueRN.getInstance().buscarPorId(id);
            Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(idProduto);
            if (produto.isPossuiLote() && !ListMapUtil.listNullOrEmpty(idsLotes)) {
                return AjusteEstoqueItemRN.getInstance().getQuantidadeLoteUtilizadaWeb(id, idItemAtual, idProduto, idsLotes);
            }
            List itens = AjusteEstoqueItemRN.getInstance().buscarItensWebPor(id, idItemAtual, idProduto);
            if (produto.isNumeroSerie() && !StringUtil.stringNullOrEmpty((String)valor)) {
                int motivo = !Util.longNullOuZero((Long)ajusteEstoque.getIdMotivo()) ? ((MotivoAjusteEstoque)MotivoAjusteEstoqueRN.getInstance().buscarPorId(ajusteEstoque.getIdMotivo())).getCodigo() : 0;
                AjusteEstoqueItemRN.getInstance().carregaListaNumeroSerie(itens, motivo);
                boolean existe = itens.stream().anyMatch(ajusteEstoqueItem -> ajusteEstoqueItem.getListaNumeroSeries().stream().anyMatch(numeroSerie -> numeroSerie.equals(valor)));
                if (existe) {
                    return BigDecimal.ONE;
                }
            } else {
                if (produto.isPossuiVariacao() && !StringUtil.stringNullOrEmpty((String)valor)) {
                    return itens.stream().map(ajusteEstoqueItem -> {
                        Map map = VariacaoRN.getInstance().stringToMap(ajusteEstoqueItem.getVariacoes());
                        Integer qtd = (Integer)map.get(Integer.valueOf(valor));
                        if (qtd == null) {
                            return BigDecimal.ZERO;
                        }
                        return new BigDecimal(qtd);
                    }).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                return itens.stream().map(AjusteEstoqueItem::getQuantidade).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
        }
        return BigDecimal.ZERO;
    }
}

