/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.caixaemail;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.logtracker.LogTrackerSpring;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.Email;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.CaixaEmail;
import br.intelidata.commons.domain.pojo.ExternalToken;
import br.intelidata.commons.domain.pojo.ParametrosEmail;
import br.intelidata.commons.domain.pojo.enuns.TipoCaixaEmail;
import br.intelidata.commons.domain.pojo.enuns.TipoServicoCaixaEmail;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.CaixaEmailRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/caixas-email"})
@SubMenuMapping(MENU="SubMenuFerramentasAuxiliar", NOME="Caixas de e-mail", ICONE="icon-email", ROTA="/ferramentas/caixas-email", PROGRAMA=517)
public class CaixaEmailCrudController
extends CrudController<CaixaEmail, CaixaEmailRN> {
    protected LogTrackerSpring logTrackerSpring;
    protected final TaskManager taskManager;

    @Autowired
    public CaixaEmailCrudController(TaskManager taskManager) {
        super((AbstractRegraNegocio)CaixaEmailRN.getInstance(), CaixaEmail::new, true, true);
        this.taskManager = taskManager;
    }

    protected void beforeSave(CaixaEmail caixaEmail, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        caixaEmail.setIdFilial(SessaoUtil.getSessao().getFilial().getId());
    }

    protected String getCacheId() {
        return "caixas-email";
    }

    protected GridBuilder<CaixaEmailRN> getGridBuilder() {
        Sessao sessao = SessaoUtil.getSessao();
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("emailpadrao", "emailPadrao", "E-mail", 0, true, new String[0]));
        colunas.add(new ColunaSQL("tiposervico", "tipoServico", "Tipo", 0, true, new String[0]));
        GridBuilder grid = new GridBuilder(CaixaEmailRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idfilial"));
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, sessao.getFilial().getId()));
        grid.addReferenciaDefault(new Referencia("tipo"));
        grid.addCodicaoDefault(new Condicao("tipo", Operador.IGUAL, TipoCaixaEmail.SISTEMA.getId().intValue()));
        grid.setOrdemDefault(new Ordem("emailPadrao"));
        return grid;
    }

    @RequestMapping(value={"/buscar-link-login"})
    @DBAutoCommit
    public ExternalToken buscarLinkLogin(@RequestParam String email, @RequestParam TipoServicoCaixaEmail tipo) {
        ExternalToken externalTokenAtual = new ExternalToken();
        externalTokenAtual.setScope(UUID.randomUUID());
        externalTokenAtual.setTokenType(tipo.getTokenType());
        String loginUrl = this.getLogTrackerSpring().getLoginUrlOAuthExternalToken(externalTokenAtual.getScope(), tipo.getTokenType(), email);
        loginUrl = loginUrl.replace(" ", "%20");
        externalTokenAtual.setLinkLogin(loginUrl);
        return externalTokenAtual;
    }

    @PostMapping(value={"/consultar-autorizado"})
    @DBAutoCommit
    public Map<String, String> consultarAutorizado(@RequestBody ExternalToken externalToken) {
        return this.getLogTrackerSpring().getUrlParamsOAuth2AccessToken(externalToken.getScope());
    }

    @RequestMapping(value={"/combo"})
    @DBAutoCommit
    public List<CaixaEmail> combo() {
        return CaixaEmailRN.getInstance().getComboWeb(SessaoUtil.getSessao());
    }

    @PostMapping(value={"/testar"})
    @DBAutoCommit
    public void testarEmail(@RequestBody CaixaEmail caixaEmail, @RequestParam String emailDestino) throws UnicoMensagemUsuarioException {
        if (Util.stringNullOrEmpty((String)emailDestino)) {
            throw new UnicoMensagemUsuarioException("COM280144", "E-mail n\u00e3o informado.");
        }
        if (Util.stringNullOrEmpty((String)caixaEmail.getEmailPadrao())) {
            throw new UnicoMensagemUsuarioException("COM280119", "E-mail da configura\u00e7\u00e3o n\u00e3o informado.");
        }
        if (caixaEmail.getTipoServico().equals((Object)TipoServicoCaixaEmail.PERSONALIZADO)) {
            if (Util.stringNullOrEmpty((String)caixaEmail.getServidorSmtp())) {
                throw new UnicoMensagemUsuarioException("COM280120", "Servidor SMTP n\u00e3o informado.");
            }
            if (caixaEmail.getPortaSmtp() == 0) {
                throw new UnicoMensagemUsuarioException("COM280121", "Porta do servidor SMTP n\u00e3o informada.");
            }
            if (Util.stringNullOrEmpty((String)caixaEmail.getSenhaSmtp())) {
                throw new UnicoMensagemUsuarioException("COM280122", "Senha do servidor SMTP n\u00e3o informada.");
            }
        } else if (caixaEmail.getExternalToken() == null) {
            throw new UnicoMensagemUsuarioException("COM280123", "E-mail n\u00e3o est\u00e1 autorizado. Verifique.");
        }
        ParametrosEmail parametrosEmail = Email.getParametrosEmail((Sessao)SessaoUtil.getSessao(), (CaixaEmail)caixaEmail);
        ParametrosEmailWeb parametrosEmailWeb = new ParametrosEmailWeb(parametrosEmail);
        parametrosEmailWeb.setEmailDestino(emailDestino);
        parametrosEmailWeb.setAssunto("Teste de e-mail para o sistema Uniplus Web");
        parametrosEmailWeb.setMensagem("Teste de e-mail para o sistema Uniplus Web");
        CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmailWeb, "Teste de e-mail");
        taskEmail.createTask((Object)parametrosEmailWeb, parametrosEmailWeb.getAssunto());
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    @DBAutoCommit
    public CaixaEmail read(@PathVariable Long id, @PathVariable Optional<Long> parentId, @RequestParam(required=false, defaultValue="0") int modo, @RequestParam(required=false) MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        CaixaEmail entity = ((CaixaEmailRN)this.rn).buscarPorId(id);
        if (entity == null) {
            return null;
        }
        return (CaixaEmail)super.read(id, parentId, modo, parameters);
    }

    public LogTrackerSpring getLogTrackerSpring() {
        if (this.logTrackerSpring == null) {
            this.logTrackerSpring = new LogTrackerSpring();
        }
        return this.logTrackerSpring;
    }
}

