/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.condicaopagamento;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.CondicaoPagamento;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.enuns.ComportamentoClienteAtrasoVendas;
import br.intelidata.commons.domain.pojo.enuns.EscopoCondicaoPagamento;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.vendas.regranegocio.CondicaoPagamentoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/condicoes-pagamento"})
@SubMenuMapping(MENU="SubMenuVendasAuxiliarParametrosVenda", NOME="Condi\u00e7\u00f5es de pagamento", ROTA="/vendas/condicoes-pagamento", PROGRAMA=12)
public class CondicaoPagamentoCrudController
extends CrudController<CondicaoPagamento, CondicaoPagamentoRN> {
    @Autowired
    public CondicaoPagamentoCrudController() {
        super((AbstractRegraNegocio)CondicaoPagamentoRN.getInstance(), CondicaoPagamento::new);
    }

    @RequestMapping(value={"/validar"})
    @DBAutoCommit
    public String validarCondicaoPgmto(@RequestParam Long idCondicaoPgmto, @RequestParam Long idEntidade) throws UnicoMensagemUsuarioException {
        ComportamentoClienteAtrasoVendas comportamentoClienteAtrasoVendas = (ComportamentoClienteAtrasoVendas)PropriedadeRN.getInstance().getPropriedadeEnum(SessaoUtil.getSessao().getFilial(), 817);
        if (ComportamentoClienteAtrasoVendas.LIBERAR_A_VISTA.equals((Object)comportamentoClienteAtrasoVendas) && CondicaoPagamentoRN.getInstance().isCondicaoPagamentoAVista(idCondicaoPgmto)) {
            return null;
        }
        EntidadeRN.getInstance().permiteVender(SessaoUtil.getSessao(), (Entidade)EntidadeRN.getInstance().buscarPorId(idEntidade), true, true);
        CondicaoPagamento condicaoPagamento = (CondicaoPagamento)CondicaoPagamentoRN.getInstance().buscarPorId(idCondicaoPgmto);
        if (condicaoPagamento != null && condicaoPagamento.isInativo()) {
            throw new UnicoMensagemUsuarioException("WWW198", "A condi\u00e7\u00e3o de pagamento esta inativa.");
        }
        return null;
    }

    @RequestMapping(value={"/filtrar-por-escopo"})
    @DBAutoCommit
    public List<CondicaoPagamento> filtrarPorEscopo(@RequestParam String escopo, @RequestParam(required=false) String query, @RequestParam(defaultValue="6", required=false) int limit, @RequestParam(required=false) Long idCondPagDefault, @RequestParam(required=false) Long idTipoDocumento) throws UnicoMensagemUsuarioException {
        EscopoCondicaoPagamento escopoCondicao;
        try {
            escopoCondicao = Enum.valueOf(EscopoCondicaoPagamento.class, escopo);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new UnicoMensagemUsuarioException("WWW445", "Escopo inv\u00e1lido. Valores dispon\u00edveis {COMPRA_VENDA(0), VENDA(1), COMPRA(2)}");
        }
        return CondicaoPagamentoRN.getInstance().buscaCondicoesPagamentoPorEscopoWeb(SessaoUtil.getSessao(), escopoCondicao, query, limit, idCondPagDefault, idTipoDocumento);
    }

    protected GridBuilder<CondicaoPagamentoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 100, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 250, true));
        colunas.add(new ColunaSQL("prazos", "Prazos", 250, true));
        colunas.add(new ColunaSQL("tipo", "Tipo", 0, true));
        colunas.add(new ColunaSQL("percentual", "Percentual", 0, true));
        GridBuilder grid = new GridBuilder(CondicaoPagamentoRN.getInstance().getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("prazos"));
        grid.addReferenciaDefault(new Referencia("inativo", "condPagInativo"));
        return grid;
    }

    protected void beforeSave(CondicaoPagamento condicaoPagamento, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (condicaoPagamento.getPercentual() == null) {
            condicaoPagamento.setPercentual(BigDecimal.ZERO);
        }
        if (condicaoPagamento.getParcelas() > 0 && !StringUtil.stringNullOrEmpty((String)condicaoPagamento.getPrazos()) && !CondicaoPagamentoRN.getInstance().isPrazoValido(condicaoPagamento.getPrazos())) {
            throw new UnicoMensagemUsuarioException("WVND8", "Campo prazo inv\u00e1lido");
        }
    }

    protected String getCacheId() {
        return "condicoes-pagamento";
    }
}

