/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ConhecimentoEntradaNota;
import br.intelidata.commons.domain.pojo.EventoFinanceiro;
import br.intelidata.commons.domain.pojo.FinanceiroDado;
import br.intelidata.commons.domain.pojo.HierarquiaPlanoContas;
import br.intelidata.commons.domain.pojo.ModeloNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoNotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.CentroCustoRateioCommonRN;
import br.intelidata.commons.domain.regranegocio.RateioConhecimentoItemNotaAntigoRN;
import br.intelidata.commons.domain.regranegocio.notafiscal.CalculoImpostoConhecimentoTransporteEntrada;
import br.intelidata.commons.modulo.conhecimento.regranegocio.ConhecimentoEntradaNotaRN;
import br.intelidata.commons.modulo.financeiro.centrocusto.enuns.OrigemRateioCentroCusto;
import br.intelidata.commons.modulo.financeiro.centrocusto.regranegocio.CentroCustoRateioRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.EventoFinanceiroRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.HierarquiaPlanoContasRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.ImpostoCTWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/conhecimentos-transportes"})
@SubMenuMapping(MENU="SubMenuFiscalGeral", NOME="Conhecimentos de transporte", ICONE="icon-transportadora", ROTA="/notas-fiscais/conhecimentos-transportes", PROGRAMA=213)
public class ConhecimentoTransporteCrudController
extends CrudController<NotaFiscal, NotaFiscalRN> {
    public ConhecimentoTransporteCrudController() {
        super((AbstractRegraNegocio)NotaFiscalRN.getInstance(), NotaFiscal::new, true, true);
    }

    @RequestMapping(value={"/ct-calculo-imposto"}, method={RequestMethod.POST})
    @DBAutoCommit
    public NotaFiscal calcularImpostoCT(@RequestBody ImpostoCTWrapper impostoCTWrapper) {
        new CalculoImpostoConhecimentoTransporteEntrada(SessaoUtil.getSessao().getFilial(), impostoCTWrapper.getConhecimento(), impostoCTWrapper.getTipoCalculo());
        return impostoCTWrapper.getConhecimento();
    }

    @RequestMapping(value={"/existe-conhecimento-transporte"})
    @DBAutoCommit
    public boolean existeConhecimentoTransporte(@RequestParam Long idTransportadora, @RequestParam String numeroConhecimento, @RequestParam ModeloNotaFiscal modeloNotaFiscal, @RequestParam String serie, @RequestParam Long idConhecimento) {
        int qtdConhecimentoPorTransportadora = NotaFiscalRN.getInstance().getNumeroOcorrenciasNumeroConhecimentoPorFornecedor(idTransportadora, numeroConhecimento, modeloNotaFiscal.getId(), serie, idConhecimento);
        return qtdConhecimentoPorTransportadora > 0;
    }

    @RequestMapping(value={"/importar-xml-conhecimento-transporte"}, method={RequestMethod.POST})
    @DBTransaction
    public NotaFiscal importarXml(@RequestPart(value="file") MultipartFile file) throws UnicoMensagemUsuarioException {
        try {
            if (file == null) {
                throw new UnicoMensagemUsuarioException("WWW252", "Arquivo n\u00e3o encontrado");
            }
            HashMap dados = NotaFiscalRN.getInstance().importarXmlConhecimentoTransporte(SessaoUtil.getSessao(), file.getBytes());
            NotaFiscal conhecimento = (NotaFiscal)dados.get("conhecimento");
            conhecimento.setTipoDocumento(TipoNotaFiscal.CONHECIMENTO_TRANSPORTE);
            List notas = (List)dados.get("notas");
            if (!Util.listNullOrEmpty((List)notas)) {
                notas.forEach(nota -> conhecimento.addConhecimentoEntradaNotas(this.getConhecimentoEntrada(nota)));
            }
            return conhecimento;
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("CNT113", e.getMessage());
        }
    }

    public String getDescricaoTabela() {
        return "Conhecimentos de transporte";
    }

    private ConhecimentoEntradaNota getConhecimentoEntrada(NotaFiscal notaFiscal) {
        ConhecimentoEntradaNota conhecimentoEntradaNota = new ConhecimentoEntradaNota();
        conhecimentoEntradaNota.setIdNotaFiscal(notaFiscal.getId());
        conhecimentoEntradaNota.setIdClienteFornecedor(notaFiscal.getIdEntidade());
        conhecimentoEntradaNota.setNomeClienteFornecedor(notaFiscal.getRazaoSocial());
        conhecimentoEntradaNota.setNumeroNotaFiscal(notaFiscal.getNumeroNotaFiscal());
        conhecimentoEntradaNota.setModelo(notaFiscal.getSerie());
        conhecimentoEntradaNota.setSerie(notaFiscal.getModelo());
        conhecimentoEntradaNota.setEmissaoEntrada(notaFiscal.getEmissao());
        conhecimentoEntradaNota.setValor(notaFiscal.getValorTotalNota());
        return conhecimentoEntradaNota;
    }

    private void gravarNotas(NotaFiscal conhecimento) throws UnicoMensagemUsuarioException {
        List listNotas = conhecimento.getConhecimentoEntradaNotas();
        ConhecimentoEntradaNotaRN.getInstance().gravarLista(SessaoUtil.getSessao(), conhecimento.getId(), listNotas);
    }

    private void estornarEventoFinanceiro(Long idConhecimentoOriginal) throws UnicoMensagemUsuarioException {
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.FINANCEIRO_CONHECIMENTO_ENTRADA)) {
            EventoFinanceiroRN.getInstance().estornaFinanceiroConhecimentoEntrada(idConhecimentoOriginal, SessaoUtil.getSessao());
        }
    }

    private void gerarEvento(NotaFiscal conhecimento) throws UnicoMensagemUsuarioException {
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.FINANCEIRO_CONHECIMENTO_ENTRADA) && conhecimento.getVencimento() != null) {
            EventoFinanceiroRN.getInstance().gravarFinanceiroConhecimentoEntrada(SessaoUtil.getSessao(), conhecimento, conhecimento.getVencimento());
        }
    }

    private void validarEmissaoComNotaEntrada(NotaFiscal conhecimento) throws UnicoMensagemUsuarioException {
        for (ConhecimentoEntradaNota ct : conhecimento.getConhecimentoEntradaNotas()) {
            NotaFiscal nota = NotaFiscalRN.getInstance().buscarNotaFiscalPorIdWeb(ct.getIdNotaFiscal());
            if (nota == null) {
                throw new UnicoMensagemUsuarioException("WWW226", "Nota fiscal n\u00ba " + ct.getNumeroNotaFiscal() + ", n\u00e3o encontrada no servidor! Verifique.");
            }
            if (!nota.getTipoDocumento().equals((Object)TipoNotaFiscal.ENTRADA) || conhecimento.getEmissao().equals(ct.getEmissaoEntrada())) continue;
            throw new UnicoMensagemUsuarioException("WWW227", "Existem notas fiscais com a data de entrada diferente da data de entrada do conhecimento de transporte.");
        }
    }

    protected String getCacheId() {
        return "conhecimentos-transportes";
    }

    protected GridBuilder<NotaFiscalRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("serie", "modelo", 0, false));
        colunas.add(new ColunaSQL("numeroNotaFiscal", "N\u00famero", 100, true));
        colunas.add(new ColunaSQL("modelo", "S\u00e9rie", 100, true));
        colunas.add(new ColunaSQL("cfopConhecimentoTransporte", "cfopCT", "CFOP", 100, true, new String[0]));
        colunas.add(new ColunaSQL("entradaSaida", "Data emiss\u00e3o", 150, true));
        colunas.add(new ColunaSQL("emissao", "Data entrada", 150, true));
        colunas.add(new ColunaSQL("razaoSocial", "Transportadora", 0, true));
        colunas.add(new ColunaSQL("valorTotalNota", "Valor documento", 150, true));
        GridBuilder grid = new GridBuilder(NotaFiscalRN.getInstance().getTabela(), colunas, "conhecimentotranspentrada");
        grid.addReferenciaDefault(new Referencia("tipodocumento", "tipodocumento"));
        grid.addCodicaoDefault(new Condicao("tipodocumento", Operador.IGUAL, "CT"));
        grid.addReferenciaDefault(new Referencia("idfilial", "idfilial"));
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getIdFilial()));
        return grid;
    }

    protected void beforeRead(NotaFiscal conhecimento, int modo, Optional<Long> parentId) {
        EventoFinanceiro evento;
        conhecimento.setTipoDocumento(TipoNotaFiscal.CONHECIMENTO_TRANSPORTE);
        conhecimento.setConhecimentoEntradaNotas(ConhecimentoEntradaNotaRN.getInstance().buscarListaPorIdConhecimento(conhecimento.getId()));
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.FINANCEIRO_CONHECIMENTO_ENTRADA) && (evento = EventoFinanceiroRN.getInstance().buscarPorIdOrigem(conhecimento.getId(), -8)) != null && !ListMapUtil.listNullOrEmpty((List)evento.getListaDestinos())) {
            conhecimento.setVencimento(((FinanceiroDado)evento.getListaDestinos().get(0)).getVencimento());
        }
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CENTRO_CUSTO) && FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PLANO_DE_CONTAS)) {
            conhecimento.setRateiosCentroCusto(CentroCustoRateioRN.getInstance().buscaRateios(OrigemRateioCentroCusto.CONHECIMENTO_TRANSPORTE, conhecimento.getId()));
        }
    }

    protected void beforeSave(NotaFiscal notaFiscal, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        HierarquiaPlanoContas planoContas;
        notaFiscal.setTipoDocumento(TipoNotaFiscal.CONHECIMENTO_TRANSPORTE);
        this.validarEmissaoComNotaEntrada(notaFiscal);
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PLANO_DE_CONTAS) && FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CENTRO_CUSTO) && (planoContas = (HierarquiaPlanoContas)HierarquiaPlanoContasRN.getInstance().buscarPorId(notaFiscal.getIdPlanoContas())) != null && planoContas.isCentroCustoObrigatorio()) {
            CentroCustoRateioRN.getInstance().validarRateio(notaFiscal.getTotalServicos(), notaFiscal.getRateiosCentroCusto());
        }
    }

    protected void afterUpdate(NotaFiscal notaFiscal, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.estornarEventoFinanceiro(notaFiscal.getId());
    }

    protected void afterSave(NotaFiscal notaFiscal, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.gravarNotas(notaFiscal);
        this.gerarEvento(notaFiscal);
        RateioConhecimentoItemNotaAntigoRN.getInstance().ratearConhecimento(SessaoUtil.getSessao(), notaFiscal, notaFiscal.getConhecimentoEntradaNotas(), null);
        CentroCustoRateioCommonRN.getInstance().gravarRateios(SessaoUtil.getSessao(), notaFiscal.getRateiosCentroCusto(), OrigemRateioCentroCusto.CONHECIMENTO_TRANSPORTE, notaFiscal.getId());
    }

    protected void beforeDelete(NotaFiscal notaFiscal) throws UnicoMensagemUsuarioException {
        this.estornarEventoFinanceiro(notaFiscal.getId());
    }
}

