/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.conhecimentotransportesaida.inutilizacao;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.InputStreamDataSource;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.conhecimento.InutilizacaoCte;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.cte.regranegocio.InutilizacaoCteRN;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CompartilhamentoController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.temporal.Temporal;
import java.util.Collections;
import java.util.List;
import javax.activation.DataSource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/inutilizacoes-cte"})
public class InutilizacaoCteJobController
extends CompartilhamentoController<NotificacaoCompartilhamento> {
    public InutilizacaoCteJobController(TaskManager taskManager) {
        super(taskManager);
    }

    protected List<Notificacao> getNotificacoes(Sessao sessao, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        InutilizacaoCte inutilizacao = (InutilizacaoCte)InutilizacaoCteRN.getInstance().buscarPorId((Long)compartilhamento.getIdsDocumentos().get(0));
        if (inutilizacao == null) {
            throw new UnicoMensagemUsuarioException("CTE167", "Inutiliza\u00e7\u00e3o n\u00e3o encontrada.");
        }
        Notificacao notificacao = new Notificacao();
        notificacao.setFone(compartilhamento.getCelular());
        notificacao.setEmail(compartilhamento.getEmail());
        notificacao.setEmailCopia(compartilhamento.getCopiaPara());
        notificacao.setAssunto(compartilhamento.getAssunto());
        notificacao.setMsg(compartilhamento.getMensagem());
        DataSource[] sources = null;
        Malote malote = new Malote();
        if (inutilizacao.getArquivoXml() != null) {
            String nomeArquivo = Util.formataDataHora((Temporal)inutilizacao.getAno(), (String)"yy") + Util.apenasNumeros((String)inutilizacao.getCnpj()) + inutilizacao.getModelo().getModeloSpedFiscal() + inutilizacao.getSerie() + inutilizacao.getNumeroInicial() + inutilizacao.getNumeroFinal();
            InputStreamDataSource dataSourceXml = new InputStreamDataSource(nomeArquivo + "-inu.xml", "text/xml", (InputStream)new ByteArrayInputStream(inutilizacao.getArquivoXml()));
            malote.inclui(nomeArquivo + "-inu.xml", inutilizacao.getArquivoXml());
            sources = new DataSource[]{dataSourceXml};
        }
        notificacao.setDataSources(sources);
        notificacao.setMalote(malote);
        return Collections.singletonList(notificacao);
    }

    protected void createJobEmail(Sessao sessao, ParametrosEmailWeb parametrosEmail, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        String assunto = "Inutiliza\u00e7\u00e3o de numera\u00e7\u00e3o de CT-e da empresa " + sessao.getFilial().getRazaoSocialCompleta();
        CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmail, "Inutiliza\u00e7\u00e3o de numera\u00e7\u00e3o de CT-e");
        taskEmail.createTask((Object)parametrosEmail, assunto);
    }
}

