/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.consultapedido;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Modulo;
import br.intelidata.commons.core.licenca.ModuloManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.TipoDocumentoDAV;
import br.intelidata.commons.domain.pojo.enuns.TipoVenda;
import br.intelidata.commons.domain.regranegocio.b2c.CarrinhoComprasItemRN;
import br.intelidata.commons.modulo.compras.regranegocio.PedidoCompraRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.crud.consultapedido.ConsultaPedidoWrapper;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/consulta-pedidos"})
public class ConsultaPedidoSimpleController
extends SimpleController {
    @RequestMapping(value={"/buscar-compras"})
    @DBAutoCommit
    public ConsultaPedidoWrapper buscarCompras(@RequestParam Long idProduto) {
        return new ConsultaPedidoWrapper(PedidoCompraRN.getInstance().buscaPedidosEmAberto(SessaoUtil.getSessao().getIdFilial(), idProduto));
    }

    @RequestMapping(value={"/buscar-vendas"})
    @DBAutoCommit
    public ConsultaPedidoWrapper buscarVendas(@RequestParam Long idProduto, @RequestParam(required=false, defaultValue="false") boolean apenasPedidoFaturamento) throws UnicoMensagemUsuarioException {
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(idProduto);
        if (produto == null) {
            throw new UnicoMensagemUsuarioException("WWW391", "N\u00e3o foi poss\u00edvel localizar o produto. Verifique!");
        }
        Sessao sessao = SessaoUtil.getSessao();
        List pedidos = ProdutoRN.getInstance().buscaPedidosVendaEmAberto(sessao.getIdFilial(), sessao.getUsuario().getIdLocalEstoqueTrabalho(), idProduto, apenasPedidoFaturamento);
        BigDecimal qtdPedido = BigDecimal.ZERO;
        BigDecimal qtdPedidoFaturamento = BigDecimal.ZERO;
        BigDecimal qtdPreVenda = BigDecimal.ZERO;
        BigDecimal qtdEntregaFutura = BigDecimal.ZERO;
        BigDecimal qtdDavOs = BigDecimal.ZERO;
        BigDecimal qtdMesa = BigDecimal.ZERO;
        if (!ListMapUtil.listNullOrEmpty((List)pedidos)) {
            for (HashMap mapPedido : pedidos) {
                for (Map.Entry entry : mapPedido.entrySet()) {
                    if (!((String)entry.getKey()).equalsIgnoreCase("tipo")) continue;
                    Integer tipoDocumento = (Integer)entry.getValue();
                    BigDecimal quantidade = (BigDecimal)mapPedido.get("quantidade");
                    if (tipoDocumento != null) {
                        TipoDocumentoDAV documento = (TipoDocumentoDAV)EnumUtils.getPorId(TipoDocumentoDAV.class, (Object)tipoDocumento);
                        if (TipoDocumentoDAV.PEDIDO.equals((Object)documento)) {
                            qtdPedido = qtdPedido.add(quantidade);
                            continue;
                        }
                        if (TipoDocumentoDAV.PEDIDO_FATURAMENTO.equals((Object)documento)) {
                            qtdPedidoFaturamento = qtdPedidoFaturamento.add(quantidade);
                            continue;
                        }
                        if (TipoDocumentoDAV.DAV_OS.equals((Object)documento)) {
                            qtdDavOs = qtdDavOs.add(quantidade);
                            continue;
                        }
                        if (TipoDocumentoDAV.PREVENDA.equals((Object)documento) && TipoVenda.DIRETA.getDescricao().equals(mapPedido.get("tipoVenda"))) {
                            qtdPreVenda = qtdPreVenda.add(quantidade);
                            continue;
                        }
                        if (!TipoDocumentoDAV.PREVENDA.equals((Object)documento) || !TipoVenda.ENTREGA_FUTURA.getDescricao().equals(mapPedido.get("tipoVenda"))) continue;
                        qtdEntregaFutura = qtdEntregaFutura.add(quantidade);
                        continue;
                    }
                    qtdMesa = qtdMesa.add(quantidade);
                }
            }
        }
        ConsultaPedidoWrapper consulta = new ConsultaPedidoWrapper(pedidos);
        int casasDecimaisQuantidade = UnidademedidaRN.getInstance().getCasasDecimais(produto.getIdUnidadeMedida());
        if (ModuloManager.getInstance().isAtivo(Modulo.UNIPLUS_SHOP)) {
            List dadosReserva = CarrinhoComprasItemRN.getInstance().buscarCarrinhosReservados(sessao, idProduto, sessao.getIdFilial(), casasDecimaisQuantidade);
            pedidos.addAll(dadosReserva);
            BigDecimal qdtTotal = dadosReserva.stream().map(map -> (BigDecimal)map.get("quantidade")).reduce(BigDecimal.ZERO, BigDecimal::add);
            consulta.setQtdShop(StringUtil.bigDecimal2String((BigDecimal)qdtTotal, (String)StringUtil.getMascaraQuantidade((int)casasDecimaisQuantidade)));
        }
        BigDecimal qtdPedidoCompra = BigDecimal.ZERO;
        if (ModuloManager.getInstance().isAtivo(Modulo.COMPRAS)) {
            qtdPedidoCompra = ProdutoRN.getInstance().getSaldoPedidosCompra(Contexto.getInstance().getFilial().getId(), idProduto);
        }
        BigDecimal total = qtdPedido.add(qtdPedidoFaturamento).add(qtdPreVenda).add(qtdDavOs).add(qtdMesa).add(qtdEntregaFutura).add(qtdPedidoCompra);
        consulta.setTotal(StringUtil.bigDecimal2String((BigDecimal)total, (String)StringUtil.getMascaraQuantidade((int)casasDecimaisQuantidade)));
        consulta.setQtdPedido(StringUtil.bigDecimal2String((BigDecimal)qtdPedido, (String)StringUtil.getMascaraQuantidade((int)casasDecimaisQuantidade)));
        consulta.setQtdPedidoFaturamento(StringUtil.bigDecimal2String((BigDecimal)qtdPedidoFaturamento, (String)StringUtil.getMascaraQuantidade((int)casasDecimaisQuantidade)));
        consulta.setQtdPreVenda(StringUtil.bigDecimal2String((BigDecimal)qtdPreVenda, (String)StringUtil.getMascaraQuantidade((int)casasDecimaisQuantidade)));
        consulta.setQtdDavOs(StringUtil.bigDecimal2String((BigDecimal)qtdDavOs, (String)StringUtil.getMascaraQuantidade((int)casasDecimaisQuantidade)));
        consulta.setQtdMesa(StringUtil.bigDecimal2String((BigDecimal)qtdMesa, (String)StringUtil.getMascaraQuantidade((int)casasDecimaisQuantidade)));
        consulta.setQtdEntregaFutura(StringUtil.bigDecimal2String((BigDecimal)qtdEntregaFutura, (String)StringUtil.getMascaraQuantidade((int)casasDecimaisQuantidade)));
        consulta.setQtdPedidoCompra(StringUtil.bigDecimal2String((BigDecimal)qtdPedidoCompra, (String)StringUtil.getMascaraQuantidade((int)casasDecimaisQuantidade)));
        BigDecimal saldoPrevisto = ProdutoRN.getInstance().getSaldoPrevistoEstoque(sessao, sessao.getIdFilial(), idProduto);
        consulta.setSaldoPrevisto(StringUtil.bigDecimal2String((BigDecimal)saldoPrevisto, (String)StringUtil.getMascaraQuantidade((int)casasDecimaisQuantidade)));
        return consulta;
    }
}

