/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.cotacaomoeda;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.CotacaoMoeda;
import br.intelidata.commons.domain.pojo.Moeda;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.vendas.regranegocio.CotacaoMoedaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cotacoes-moeda"})
@SubMenuMapping(MENU="SubMenuFinanceiroAuxiliar", NOME="Cota\u00e7\u00e3o de moedas", ROTA="/financeiros/cotacoes-moeda", PROGRAMA=34)
public class CotacaoMoedaCrudController
extends CrudController<CotacaoMoeda, CotacaoMoedaRN> {
    public CotacaoMoedaCrudController() {
        super((AbstractRegraNegocio)CotacaoMoedaRN.getInstance(), CotacaoMoeda::new);
    }

    @RequestMapping(value={"/listar-moedas"})
    @DBAutoCommit
    public List<Moeda> getCombo() {
        return CotacaoMoedaRN.getInstance().getMoedas(SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/buscar-cotacoes"})
    @DBAutoCommit
    public List<CotacaoMoeda> getCotacoes() {
        return CotacaoMoedaRN.getInstance().getUltimasCotacoes(SessaoUtil.getSessao());
    }

    protected GridBuilder<CotacaoMoedaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("moeda", "Moeda", 50, false));
        colunas.add(new ColunaSQL("descricaoMoeda", "Moeda", 0, true));
        colunas.add(new ColunaSQL("dataHora", "Data", 0, true));
        colunas.add(new ColunaSQL("valor", "Valor", 0, true));
        colunas.add(new ColunaSQL("casasDecimaisValor", "casasDecimaisValorGrid", "Valor", 0, false, new String[0]));
        return new GridBuilder(CotacaoMoedaRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "cotacoes-moeda";
    }
}

