/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.davs;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.impressao.TrataImagemWeb;
import br.intelidata.commons.core.impressao.TrataModeloIReportWeb;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.InputStreamDataSource;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.ModeloImpressaoCabecalho;
import br.intelidata.commons.domain.pojo.enuns.TipoDocumentoDAV;
import br.intelidata.commons.domain.pojo.pvdav.Dav;
import br.intelidata.commons.domain.regranegocio.ModeloImpressaoCabecalhoRN;
import br.intelidata.commons.modulo.pvdav.impressao.ImpressaoDAVOS;
import br.intelidata.commons.modulo.pvdav.impressao.ImpressaoOrcamento;
import br.intelidata.commons.modulo.pvdav.impressao.ImpressaoPedido;
import br.intelidata.commons.modulo.pvdav.regranegocio.DavRN;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CompartilhamentoController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.web.rest.app.crud.davs.DavNotificacaoCompartilhamento;
import br.intelidata.uniplusweb.web.rest.app.crud.modeloimpressao.TrataModeloIReportWebImpl;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.activation.DataSource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/davs"})
public class DavJobController
extends CompartilhamentoController<DavNotificacaoCompartilhamento> {
    private final TrataModeloIReportWebImpl trataModeloIReportWeb;

    public DavJobController(TaskManager taskManager, TrataModeloIReportWebImpl trataModeloIReportWeb) {
        super(taskManager);
        this.trataModeloIReportWeb = trataModeloIReportWeb;
    }

    protected List<Notificacao> getNotificacoes(Sessao sessao, DavNotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        Notificacao notificacao = new Notificacao();
        notificacao.setFone(compartilhamento.getCelular());
        notificacao.setEmail(compartilhamento.getEmail());
        notificacao.setEmailCopia(compartilhamento.getCopiaPara());
        notificacao.setAssunto(compartilhamento.getAssunto());
        notificacao.setMsg(compartilhamento.getMensagem());
        ModeloImpressaoCabecalho modeloImpressaoCabecalho = (ModeloImpressaoCabecalho)ModeloImpressaoCabecalhoRN.getInstance().buscarPorId(compartilhamento.getIdModelo());
        ArrayList<InputStreamDataSource> sources = new ArrayList<InputStreamDataSource>();
        Malote malote = new Malote();
        List davs = DavRN.getInstance().buscarListaPorIds(compartilhamento.getIdsDocumentos());
        for (Dav dav : davs) {
            Object impressaoDAV = TipoDocumentoDAV.ORCAMENTO.equals((Object)compartilhamento.getTipoDocumentoDAV()) ? new ImpressaoOrcamento(sessao) : (TipoDocumentoDAV.DAV_OS.equals((Object)compartilhamento.getTipoDocumentoDAV()) ? new ImpressaoDAVOS(sessao) : new ImpressaoPedido(sessao));
            impressaoDAV.setTrataImagemWeb((TrataImagemWeb)this);
            Remessa remessa = impressaoDAV.imprimir(modeloImpressaoCabecalho, (TrataModeloIReportWeb)this.trataModeloIReportWeb, new Long[]{dav.getId()});
            byte[] arquivo = remessa.getMalote().extrai("pdf");
            if (arquivo == null) continue;
            String nome = compartilhamento.getTipoDocumentoDAV().getTipoModelo().getDescricao().replace(" ", "").replace("\u00e7", "c").toLowerCase() + "-" + dav.getCodigo() + ".pdf";
            InputStreamDataSource dataSourceXml = new InputStreamDataSource(nome, "application/pdf", (InputStream)new ByteArrayInputStream(arquivo));
            sources.add(dataSourceXml);
            malote.inclui(nome, arquivo);
        }
        notificacao.setMalote(malote);
        notificacao.setDataSources(sources.toArray(new DataSource[0]));
        return Collections.singletonList(notificacao);
    }

    protected void createJobEmail(Sessao sessao, ParametrosEmailWeb parametrosEmail, DavNotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmail, compartilhamento.getTipoDocumentoDAV().getTituloImpressao());
        taskEmail.createTask((Object)parametrosEmail, "Envio de e-mail de " + compartilhamento.getTipoDocumentoDAV().getTituloImpressao());
    }
}

