/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.desmontagem.fichatecnica;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.Unidademedida;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.TipoHierarquiaFichaTecnica;
import br.intelidata.commons.domain.pojo.enuns.TipoProdutoReclassificacao;
import br.intelidata.commons.domain.pojo.producao.FichaTecnicaDesagregacao;
import br.intelidata.commons.domain.pojo.producao.ProdutoFichaTecnicaDesagregacao;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.DesmontagemItemRN;
import br.intelidata.commons.modulo.producao.regranegocio.FichaTecnicaDesagregacaoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.web.rest.app.crud.produto.AbstractProdutoCrudController;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Optional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ficha-tecnica-desagregacao"})
public class FichaTecnicaDesagregacaoCrudController
extends AbstractProdutoCrudController<ProdutoFichaTecnicaDesagregacao, ProdutoRN> {
    public FichaTecnicaDesagregacaoCrudController(FuncionalidadeService funcionalidadeService) {
        super((AbstractRegraNegocio)ProdutoRN.getInstance(), ProdutoFichaTecnicaDesagregacao::new, funcionalidadeService);
    }

    protected String getCacheId() {
        return "/api/ficha-tecnica-desagregacao";
    }

    protected GridBuilder<ProdutoRN> getGridBuilder() {
        GridBuilder grid = super.getGridBuilder();
        grid.setAliasTabela("fichatecnicadesagregacao");
        grid.addReferenciaDefault(new Referencia("tipoProdutoReclassificacao"));
        grid.addCodicaoDefault(new Condicao("tipoProdutoReclassificacao", Operador.IGUAL, TipoProdutoReclassificacao.MESTRE.getId().intValue()));
        return grid;
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    @DBAutoCommit
    public ProdutoFichaTecnicaDesagregacao read(@PathVariable Long id, @PathVariable Optional<Long> parentId, @RequestParam(required=false, defaultValue="0") int modo, @RequestParam(required=false) MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        ProdutoFichaTecnicaDesagregacao produtoFichaTecnica = new ProdutoFichaTecnicaDesagregacao();
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(id);
        if (produto != null) {
            produtoFichaTecnica.setIdProduto(id);
            produtoFichaTecnica.setTipoFichaTecnica(produto.getTipoFichaTecnicaDesagregacao());
            produtoFichaTecnica.setPrecoCustoBruto(produto.getPrecoCustoBaseDesagregacao());
            try {
                List listaProdutos = FichaTecnicaDesagregacaoRN.getInstance().buscarListaPorIdProdutoComEstrutura(produto.getId(), null);
                if (!Util.listNullOrEmpty((List)listaProdutos)) {
                    produtoFichaTecnica.setItens(listaProdutos);
                    for (FichaTecnicaDesagregacao ftd : listaProdutos) {
                        this.carregaDadosItem(ftd);
                    }
                    this.atualizarCamposParaValidacaoItens(produtoFichaTecnica);
                    this.calcularTotalFicha(produtoFichaTecnica);
                }
            }
            catch (Throwable e) {
                String msg = e instanceof StackOverflowError ? "Ocorreu um erro ao carregar a ficha t\u00e9cnica deste produto. Ela precisa ser refeita!" : e.getMessage();
                throw new UnicoException("WPRD37", msg);
            }
        }
        return produtoFichaTecnica;
    }

    @RequestMapping(value={"/popular-validar-item"}, method={RequestMethod.POST})
    @DBAutoCommit
    public FichaTecnicaDesagregacao validarPopularFicha(@RequestBody FichaTecnicaDesagregacao ficha) throws UnicoMensagemUsuarioException {
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(ficha.getIdProduto());
        if (produto.getTipoProdutoReclassificacao() == null || !produto.getTipoProdutoReclassificacao().in(new AbstractEnum[]{TipoProdutoReclassificacao.PERDA, TipoProdutoReclassificacao.RECLASSIFICADO})) {
            throw new UnicoMensagemUsuarioException("WPRD32", "Selecione um produto do tipo reclassificado ou perda");
        }
        if (FichaTecnicaDesagregacaoRN.getInstance().verificaSeProdutoPaiEstaNosInsumos(ficha.getIdProduto(), Integer.valueOf(0), ficha.getIdProdutoPai(), Integer.valueOf(0))) {
            throw new UnicoMensagemUsuarioException("WPRD36", "Este produto n\u00e3o pode ser inclu\u00eddo, pois o produto principal faz parte de seus insumos! Verifique.");
        }
        this.carregaDadosItem(ficha);
        return ficha;
    }

    private void carregaDadosItem(FichaTecnicaDesagregacao fichaTecnicaDesagregacao) {
        if (fichaTecnicaDesagregacao == null) {
            return;
        }
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(fichaTecnicaDesagregacao.getIdProduto());
        if (produto != null) {
            List fichaTecnicaItensDesagregacaoFilho = FichaTecnicaDesagregacaoRN.getInstance().buscarListaPorIdProduto(produto.getId(), null);
            if (!ListMapUtil.listNullOrEmpty((List)fichaTecnicaItensDesagregacaoFilho)) {
                fichaTecnicaDesagregacao.setTipoComponente(TipoHierarquiaFichaTecnica.COMPONENTE_PAI);
            } else {
                fichaTecnicaDesagregacao.setTipoComponente(TipoHierarquiaFichaTecnica.COMPONENTE);
            }
            Unidademedida unidadeMedida = (Unidademedida)UnidademedidaRN.getInstance().buscarPorId(produto.getIdUnidadeMedida());
            fichaTecnicaDesagregacao.setUnidadeMedida(unidadeMedida.getCodigo());
            fichaTecnicaDesagregacao.setDecimaisUnidade(unidadeMedida.getCasasdecimais().intValue());
            fichaTecnicaDesagregacao.setIdProduto(produto.getId());
            fichaTecnicaDesagregacao.setCodigoProduto(produto.getCodigo());
            fichaTecnicaDesagregacao.setDescricaoProduto(produto.getNome());
            fichaTecnicaDesagregacao.setIdUnidadeMedida(produto.getIdUnidadeMedida());
            fichaTecnicaDesagregacao.setDecimaisCusto(produto.getCasasDecimaisPrecoCusto().intValue());
            fichaTecnicaDesagregacao.setTipoProdutoReclassificacao(produto.getTipoProdutoReclassificacao());
            fichaTecnicaDesagregacao.setCusto(DesmontagemItemRN.getInstance().getCustoProduto(SessaoUtil.getSessao(), produto.getId()));
        }
    }

    @RequestMapping(value={"/atualizar-itens"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ProdutoFichaTecnicaDesagregacao atualizarCamposParaValidacaoItens(@RequestBody ProdutoFichaTecnicaDesagregacao produtoFichaTecnica) {
        if (!ListMapUtil.listNullOrEmpty((List)produtoFichaTecnica.getItens())) {
            for (FichaTecnicaDesagregacao itemFicha : produtoFichaTecnica.getItens()) {
                Unidademedida unidade = (Unidademedida)UnidademedidaRN.getInstance().buscarPorId(itemFicha.getIdUnidadeMedida());
                itemFicha.setQuantidadeItemValidacao(Util.CEM.multiply(itemFicha.getQuantidadePercentual()).divide(Util.CEM, 10, RoundingMode.HALF_EVEN).setScale(unidade != null ? unidade.getCasasdecimais() : 3, RoundingMode.HALF_EVEN));
                itemFicha.setPrecoCusto(produtoFichaTecnica.getPrecoCustoBruto());
                itemFicha.setPrecoCustoReal(produtoFichaTecnica.getPrecoCustoBruto().multiply(itemFicha.getGrauCusto()).setScale(itemFicha.getDecimaisCusto(), RoundingMode.HALF_EVEN));
                itemFicha.setValorTotalValidacao(itemFicha.getQuantidadeItemValidacao().multiply(itemFicha.getPrecoCustoReal()).setScale(2, RoundingMode.HALF_EVEN));
            }
        }
        return produtoFichaTecnica;
    }

    private void calcularTotalFicha(ProdutoFichaTecnicaDesagregacao produtoFichaTecnica) {
        BigDecimal totalPercentual = BigDecimal.ZERO;
        BigDecimal totalValor = BigDecimal.ZERO;
        for (FichaTecnicaDesagregacao item : produtoFichaTecnica.getItens()) {
            totalPercentual = totalPercentual.add(item.getQuantidadePercentual());
            totalValor = totalValor.add(item.getValorTotalValidacao());
        }
        produtoFichaTecnica.setQuantidadeTotal(totalPercentual);
        produtoFichaTecnica.setValorTotal(totalValor);
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody ProdutoFichaTecnicaDesagregacao produtoFichaTecnica, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(produtoFichaTecnica.getIdProduto());
        if (produto != null) {
            boolean alterouProduto = false;
            if (produto.getTipoFichaTecnicaDesagregacao() == null || !produto.getTipoFichaTecnicaDesagregacao().equals((Object)produtoFichaTecnica.getTipoFichaTecnica())) {
                produto.setTipoFichaTecnicaDesagregacao(produtoFichaTecnica.getTipoFichaTecnica());
                alterouProduto = true;
            }
            if (produtoFichaTecnica.getPrecoCustoBruto().compareTo(produto.getPrecoCustoBaseDesagregacao()) != 0) {
                produto.setPrecoCustoBaseDesagregacao(produtoFichaTecnica.getPrecoCustoBruto());
                alterouProduto = true;
            }
            if (alterouProduto) {
                ProdutoRN.getInstance().alterar((AbstractPojo)produto, sessao);
            }
            FichaTecnicaDesagregacaoRN.getInstance().excluirPorIdProduto(sessao, produto.getId(), null);
            FichaTecnicaDesagregacaoRN.getInstance().incluirItens(sessao, produto.getId(), null, produtoFichaTecnica.getItens());
        }
        return 0L;
    }
}

