/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.documentoauxiliarfaturamento.pedidofaturamento;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.Modulo;
import br.intelidata.commons.core.licenca.ModuloManager;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractFaturamento;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.DescontoInterface;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.IntermediadorMarketplace;
import br.intelidata.commons.domain.pojo.ItemWeb;
import br.intelidata.commons.domain.pojo.Pedido;
import br.intelidata.commons.domain.pojo.PedidoItem;
import br.intelidata.commons.domain.pojo.ProdutoDTOWeb;
import br.intelidata.commons.domain.pojo.ProdutoItemWeb;
import br.intelidata.commons.domain.pojo.b2c.PedidoEntrega;
import br.intelidata.commons.domain.pojo.b2c.TransacaoFinanceira;
import br.intelidata.commons.domain.pojo.edi.EDIProcessado;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.CstIPI;
import br.intelidata.commons.domain.pojo.enuns.ParceiroIntegracao;
import br.intelidata.commons.domain.pojo.enuns.QuantidadeCampoExtra;
import br.intelidata.commons.domain.pojo.enuns.StatusDAV;
import br.intelidata.commons.domain.pojo.enuns.TipoDocumentoDAV;
import br.intelidata.commons.domain.pojo.enuns.TipoIntegracaoFinanceiro;
import br.intelidata.commons.domain.pojo.enuns.TipoValorPreco;
import br.intelidata.commons.domain.pojo.generico.TextoGenerico;
import br.intelidata.commons.domain.pojo.pvdav.AbstractDav;
import br.intelidata.commons.domain.regranegocio.AbstractFaturamentoItemRN;
import br.intelidata.commons.domain.regranegocio.AbstractFaturamentoRN;
import br.intelidata.commons.domain.regranegocio.DescontoRN;
import br.intelidata.commons.domain.regranegocio.PedidoCommonRN;
import br.intelidata.commons.domain.regranegocio.UnicoIntegracaoEcommerceRN;
import br.intelidata.commons.domain.regranegocio.b2c.PedidoEntregaRN;
import br.intelidata.commons.domain.regranegocio.b2c.TransacaoFinanceiraRN;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.cadastros.regranegocio.IntermediadorMarketplaceRN;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.PedidoDocumentoFinanceiroRN;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.PedidoItemRN;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.PedidoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.entidade.regranegocio.LimiteCreditoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.uniplusshop.TextoEmailDefaultShop;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.ConfiguracaoCampoExtra;
import br.intelidata.uniplusweb.core.coreinterfaces.ProdutoItemInterface;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.EmailUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.AtacarejoService;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.ModuloService;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.calculoimposto.CalculoImpostoService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ImportacaoDadosColetor;
import br.intelidata.uniplusweb.web.rest.app.crud.documentoauxiliarfaturamento.FaturamentoCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.documentoauxiliarfaturamento.FaturamentoTratamentoImposto;
import br.intelidata.uniplusweb.web.rest.app.crud.documentoauxiliarfaturamento.pedidofaturamento.DespachoWrapper;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Component(value="pedido_faturamento")
@ConfiguracaoCampoExtra(TABELA="pedido_faturamento", QUANTIDADE=QuantidadeCampoExtra.DAF)
@RestController
@RequestMapping(value={"/api/pedidos-faturamentos"})
@SubMenuMapping(MENU="SubMenuVendasGeral", NOME="Pedidos de faturamento", ROTA="/vendas/pedidos-faturamentos", ICONE="icon-pedido", PROGRAMA=126)
public class PedidoFaturamentoCrudController
extends FaturamentoCrudController<Pedido, PedidoRN, PedidoItem, PedidoItem, PedidoItemRN>
implements ProdutoItemInterface<PedidoItem> {
    private final TaskManager taskManager;

    @Autowired
    public PedidoFaturamentoCrudController(CalculoImpostoService<PedidoItem> calculoImpostoService, FuncionalidadeService funcionalidadeService, AtacarejoService atacarejoService, ModuloService moduloService, TaskManager taskManager, FaturamentoTratamentoImposto tratamentoImposto) {
        super((AbstractFaturamentoRN)PedidoRN.getInstance(), (AbstractFaturamentoItemRN)PedidoItemRN.getInstance(), calculoImpostoService, funcionalidadeService, atacarejoService, moduloService, Pedido::new, TipoDocumentoDAV.PEDIDO_FATURAMENTO, tratamentoImposto);
        this.setItemSupplier(PedidoItem::new);
        this.taskManager = taskManager;
    }

    @RequestMapping(value={"/gerar-pedidos-dav"}, method={RequestMethod.POST})
    @DBTransaction
    public void gerarPedidosDav(@RequestBody List<Long> ids) throws UnicoMensagemUsuarioException {
        for (Long idPedido : ids) {
            Pedido pedido = (Pedido)PedidoRN.getInstance().buscarPorId(idPedido);
            if (pedido == null) {
                throw new UnicoMensagemUsuarioException("WDAF95", "Pedido n\u00e3o encontrado.");
            }
            PedidoRN.getInstance().gerarDavPedido(SessaoUtil.getSessao(), pedido);
        }
    }

    @PutMapping(value={"/despachar"})
    @DBTransaction
    public void despacharPedido(@RequestBody DespachoWrapper despachoWrapper) throws UnicoMensagemUsuarioException {
        Pedido pedido = (Pedido)PedidoRN.getInstance().buscarPorId(despachoWrapper.getIdPedido());
        if (pedido == null || !StatusDAV.NOTAFISCAL_GERADA.equals((Object)pedido.getStatus()) && !StatusDAV.PEDIDO_ENVIADO.equals((Object)pedido.getStatus())) {
            throw new UnicoMensagemUsuarioException("WWW600", "O pedido precisa estar com status 'Nota fiscal gerada' ou 'Pedido enviado'.");
        }
        pedido.setCodigoRastreio(despachoWrapper.getCodigoObservacao());
        pedido.setStatus(StatusDAV.PEDIDO_ENVIADO);
        pedido.setDataHoraDespacho(DataHoraFactory.getDataHora());
        pedido.setIgnoraValidacaoEstoque(true);
        PedidoRN.getInstance().alterar((AbstractPojo)pedido, SessaoUtil.getSessao());
        Entidade cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(pedido.getIdCliente());
        if (cliente != null && !Util.stringNullOrEmpty((String)cliente.getEmail())) {
            TextoGenerico textoGenerico = TextoEmailDefaultShop.replaceEnvioPedido((Pedido)pedido);
            ParametrosEmailWeb parametrosEmailWeb = EmailUtil.getParametros((Sessao)SessaoUtil.getSessao(), (String)cliente.getEmail(), null, (String)textoGenerico.getAssunto(), (String)textoGenerico.getTexto());
            CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmailWeb, "Envio de mercadoria");
            taskEmail.createTask((Object)parametrosEmailWeb, parametrosEmailWeb.getAssunto());
        }
    }

    @PutMapping(value={"/entregue"})
    @DBTransaction
    public void pedidoEntregue(@RequestBody Long idPedido) throws UnicoMensagemUsuarioException {
        PedidoRN.getInstance().pedidoEntregue(SessaoUtil.getSessao(), idPedido);
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody Pedido pedido, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        return super.create((AbstractPojo)pedido, parentId);
    }

    @PostMapping(value={"/gravar-info-rastreio"})
    @DBTransaction
    public void gravarInfoRastreio(@RequestBody Pedido pedido) {
        UnicoIntegracaoEcommerceRN.getInstance().gravaDadosRastreio((AbstractDav)pedido);
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody Pedido pedido, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        return super.update((AbstractPojo)pedido, parentId);
    }

    @RequestMapping(value={"/validar-pedido"})
    @DBAutoCommit
    public void validarPedidoCliente(@RequestParam String numeroPedido, @RequestParam Long idPedido) throws UnicoMensagemUsuarioException {
        PedidoCommonRN.getInstance().validarPedidoCliente(numeroPedido, idPedido);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @DBTransaction
    public void delete(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        super.verificaSePermiteCancelamento(id);
        if (ModuloManager.getInstance().isAtivo(Modulo.INTELIDATA)) {
            PedidoRN.getInstance().verificarSePodeCancelar(id);
        }
        Sessao sessao = SessaoUtil.getSessao();
        PedidoRN.getInstance().cancelarPedidoFaturamento(sessao, id);
        if (ModuloManager.getInstance().isAtivo(Modulo.INTELIDATA)) {
            PedidoRN.getInstance().extornarLicencaPedido(sessao, id);
        }
        this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
        this.notificationService.notifyTenantNow(NotificationType.DASH_BOARD, "");
    }

    @PostMapping(value={"/preparar-compartilhamento"})
    @DBAutoCommit
    public NotificacaoCompartilhamento prepararCompartilhamento(@RequestBody List<Long> idsPedidos, @RequestParam(required=false) Long idTextoGenerico) throws UnicoMensagemUsuarioException {
        if (Util.listNullOrEmpty(idsPedidos)) {
            throw new UnicoMensagemUsuarioException("WWW563", "Por favor selecione um ou mais pedidos.");
        }
        List pedidos = PedidoRN.getInstance().buscarListaPorIds(idsPedidos);
        List idsClientes = pedidos.stream().map(AbstractDav::getIdCliente).distinct().collect(Collectors.toList());
        if (idsClientes.size() != 1) {
            throw new UnicoMensagemUsuarioException("WWW564", "Os pedidos selecionados devem pertencer ao mesmo cliente.");
        }
        NotificacaoCompartilhamento notificacaoCompartilhamento = this.verificaCompartilhamento(pedidos, "Pedido", "Pedidos");
        if (!NumberUtil.longNullOuZero((Long)idTextoGenerico)) {
            notificacaoCompartilhamento.setMensagem(this.reescreveTextoMensagem(pedidos, idTextoGenerico));
        }
        return notificacaoCompartilhamento;
    }

    @PostMapping(value={"/preparar-texto-compartilhamento"})
    @DBAutoCommit
    public String prepararTextoEmail(@RequestBody List<Long> idsPedidos, @RequestParam Long idTextoGenerico) {
        List pedidos = PedidoRN.getInstance().buscarListaPorIds(idsPedidos);
        if (ListMapUtil.listNullOrEmpty((List)pedidos)) {
            return null;
        }
        return this.reescreveTextoMensagem(pedidos, idTextoGenerico);
    }

    @GetMapping(value={"/codigo-entrega/{idPedido}"})
    @DBAutoCommit
    public String getCodigoEnvio(@PathVariable Long idPedido) throws UnicoMensagemUsuarioException {
        PedidoEntrega pedidoEntrega = PedidoEntregaRN.getInstance().buscarPorIdPedido(idPedido);
        return pedidoEntrega != null ? pedidoEntrega.getCodigoEnvio() : null;
    }

    protected String getCacheId() {
        return "pedidos-faturamentos".concat("_ID_FILIAL_").concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }

    public ProdutoItemWeb<PedidoItem> carregarDadosItem(ProdutoDTOWeb produto, MultiValueMap<String, String> parametros) throws UnicoMensagemUsuarioException {
        ProdutoItemWeb produtoItem = new ProdutoItemWeb();
        PedidoItem item = new PedidoItem();
        item.setQuantidade(BigDecimal.ONE);
        item.setSituacaoTributariaIPI(CstIPI.SAIDA_TRIBUTADA);
        if (!NumberUtil.bigDecimalNullOrZero((BigDecimal)produto.getPesoProduto())) {
            item.setQuantidade(produto.getPesoProduto());
        }
        if (!NumberUtil.bigDecimalNullOrZero((BigDecimal)produto.getPrecoUnitario())) {
            item.setPreco(produto.getPrecoUnitario());
        }
        produtoItem.setItem((ItemWeb)item);
        produtoItem.setProduto(produto);
        super.carregarDadosItem(produtoItem, parametros);
        return produtoItem;
    }

    protected void beforeRead(Pedido pedido, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        pedido.setDocumentosFinanceiros(PedidoDocumentoFinanceiroRN.getInstance().buscarListaPorIdPedido(pedido.getId()));
        if (7 != modo) {
            pedido.setValorTotalFinanceiro(PedidoRN.getInstance().calcularValorTotalFinanceiro((AbstractFaturamento)pedido, pedido.getItens(), SessaoUtil.getSessao().getFilial()));
            if (!NumberUtil.longNullOuZero((Long)pedido.getIdTransacaoFinanceira())) {
                pedido.setMostraFlexEcommerce(PedidoRN.getInstance().isMostraFlexEcommerce(pedido.getIdTransacaoFinanceira()));
            }
        }
        super.beforeRead((AbstractFaturamento)pedido, modo, parentId);
        if (7 == modo) {
            pedido.setDataInclusao(DataHoraFactory.getDataHora());
            pedido.setItens(this.buscarItens(pedido.getId(), true, false));
            pedido.setId(null);
        }
        if (!Util.longNullOuZero((Long)pedido.getIdTransacaoFinanceira())) {
            IntermediadorMarketplace intermediadorMarketplace;
            TransacaoFinanceira transacaoFinanceira = (TransacaoFinanceira)TransacaoFinanceiraRN.getInstance().buscarPorId(pedido.getIdTransacaoFinanceira());
            if (transacaoFinanceira != null && (intermediadorMarketplace = (IntermediadorMarketplace)IntermediadorMarketplaceRN.getInstance().buscarPorId(transacaoFinanceira.getIdIntermediadorMarketplace())) != null) {
                pedido.setFinanceiroGeradoPorUniplusShop(ParceiroIntegracao.UNIPLUS_SHOP.equals((Object)intermediadorMarketplace.getParceiroIntegracao()));
            }
            pedido.setPedidoEntrega(PedidoEntregaRN.getInstance().buscarPorIdPedido(pedido.getId()));
        }
    }

    protected void beforeUpdate(Pedido pedido, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        super.beforeUpdate((AbstractFaturamento)pedido, parentId);
        if (!pedido.isUniplusShop()) {
            pedido.setStatus(PedidoRN.getInstance().buscaStatusPedidoAtualizado(pedido));
        }
    }

    protected void beforeSave(Pedido pedido, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        pedido.setTipodocumento(TipoDocumentoDAV.PEDIDO_FATURAMENTO);
        pedido.setTituloDav(TipoDocumentoDAV.PEDIDO_FATURAMENTO.getDescricao().toUpperCase());
        pedido.setVerificarCredito(LimiteCreditoRN.getInstance().isVerificarLimiteCredito(sessao, (AbstractDav)pedido));
        super.beforeSave((AbstractFaturamento)pedido, parentId);
        boolean possuiIntegracaoFinanceiro = true;
        if (!NumberUtil.longNullOuZero((Long)pedido.getIdCfop()) || !NumberUtil.longNullOuZero((Long)pedido.getIdOperacaoFiscal())) {
            boolean bl = possuiIntegracaoFinanceiro = !this.calculoImpostoService.getIntegracaoCFOP(!NumberUtil.longNullOuZero((Long)pedido.getIdOperacaoFiscal()) ? pedido.getIdOperacaoFiscal() : pedido.getIdCfop(), PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 372)).equals((Object)TipoIntegracaoFinanceiro.NENHUM);
        }
        if (possuiIntegracaoFinanceiro && PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 479) && NumberUtil.bigDecimalNullOrZero((BigDecimal)pedido.getValorTotalFinanceiro()) && this.funcionalidadeService.isAtiva(Funcionalidade.FINANCEIRO_PEDIDO)) {
            throw new UnicoMensagemUsuarioException("WFIN247", "N\u00e3o foram informados os valores do financeiro.");
        }
        if (this.funcionalidadeService.isAtiva(Funcionalidade.FINANCEIRO_PEDIDO) && possuiIntegracaoFinanceiro) {
            pedido.setValorTotalFinanceiro(PedidoDocumentoFinanceiroRN.getInstance().calcularValorTotalFinanceiro(this.getItens(pedido), sessao.getFilial(), BigDecimal.ZERO));
        }
        TransacaoFinanceira transacaoFinanceira = (TransacaoFinanceira)TransacaoFinanceiraRN.getInstance().buscarPorId(pedido.getIdTransacaoFinanceira());
        if (this.funcionalidadeService.isAtiva(Funcionalidade.FINANCEIRO_DETALHADO_PEDIDO) && possuiIntegracaoFinanceiro && !pedido.isUniplusShop() && transacaoFinanceira == null && pedido.getAPrazo().compareTo(BigDecimal.ZERO) != 0 && ListMapUtil.listNullOrEmpty((List)pedido.getDocumentosFinanceiros())) {
            throw new UnicoMensagemUsuarioException("WWW393", "N\u00e3o foram informados os valores do financeiro.");
        }
    }

    @DBAutoCommit
    public EDIProcessado importarArquivoEdi(MultipartFile file, Long idEdi, @RequestParam MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        Long pautaPreco = StringUtil.convertFirstValueMapToLong(parameters, (String)"pauta");
        Long idCondicaoPagamento = StringUtil.convertFirstValueMapToLong(parameters, (String)"idCondicaoPgmto");
        TipoValorPreco tipo = null;
        if (this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_IMPOSTOS_PEDIDO_ORCAMENTO_FATURAMENTO)) {
            boolean utilizaOperacaoFiscal = PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 372);
            Long idCfop = StringUtil.convertFirstValueMapToLong(parameters, (String)"idParametro");
            tipo = this.calculoImpostoService.getTipoValorPreco(idCfop, utilizaOperacaoFiscal);
        }
        ImportacaoDadosColetor importacao = new ImportacaoDadosColetor(PedidoItem.class, idEdi, file, idCondicaoPagamento, pautaPreco, tipo);
        importacao.importar();
        for (PedidoItem item : importacao.getEDIProcessado().getPedidoItens()) {
            ProdutoItemWeb produtoItem = new ProdutoItemWeb();
            ProdutoDTOWeb produto = ProdutoRN.getInstance().buscarProdutoDTOWeb(sessao, item.getIdproduto());
            produtoItem.setItem((ItemWeb)item);
            produtoItem.setProduto(produto);
            super.carregarDadosItem(produtoItem, parameters, true, false);
            item.setItemPermiteDesconto(DescontoRN.getInstance().isItemPermiteDesconto(sessao.getFilial(), (DescontoInterface)item, !NumberUtil.longNullOuZero((Long)item.getIdPromocao()) ? PromocaoRN.getInstance().buscarPorId(item.getIdPromocao()) : null));
        }
        return importacao.getEDIProcessado();
    }

    @RequestMapping(value={"/trocar-filial"})
    @DBTransaction
    public void trocarFilial(@RequestParam Long idPedido, @RequestParam Long idFilial, @RequestParam Long idLocalEstoque) throws UnicoMensagemUsuarioException {
        Pedido pedido = (Pedido)PedidoRN.getInstance().buscarPorId(idPedido);
        if (pedido != null) {
            if (pedido.getStatus().in(new AbstractEnum[]{StatusDAV.CANCELADO, StatusDAV.PDV, StatusDAV.NOTAFISCAL_GERADA, StatusDAV.MESCLADO, StatusDAV.TRANSFORMADO, StatusDAV.INCLUIDO_POR_CLIENTE})) {
                throw new UnicoMensagemUsuarioException("WDAF214", "N\u00e3o \u00e9 permitido trocar a filial de pedidos com status \"" + pedido.getStatus().getDescricao() + "\".");
            }
            PedidoRN.getInstance().validaTrocaFilialPedidoEcommerce((AbstractDav)pedido);
            PedidoCommonRN.getInstance().validaLoteSerie(pedido);
            Sessao sessao = SessaoUtil.getSessao();
            PedidoCommonRN.getInstance().validaTrocaFilial(pedido, idFilial, idLocalEstoque, sessao);
            PedidoRN.getInstance().gravar(1, pedido, sessao);
        }
    }

    private List<PedidoItem> getItens(Pedido pedido) {
        if (this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_IMPOSTOS_PEDIDO_ORCAMENTO_FATURAMENTO)) {
            return pedido.getItens();
        }
        return pedido.getItens().stream().filter(item -> item.getBrinde() == 0).collect(Collectors.toList());
    }
}

