/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.editorsql;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.UnicoSistema;
import br.intelidata.commons.core.sql.model.TipoDadoBase;
import br.intelidata.commons.core.util.Log;
import br.intelidata.commons.core.util.LogSistema;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Auditoria;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.pojo.enuns.TipoLog;
import br.intelidata.commons.domain.regranegocio.AuditoriaCommonRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.FieldDefinition;
import br.intelidata.uniplusweb.core.sgbd.ConnectionHandler;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.web.rest.app.crud.editorsql.EditorSqlWrapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.postgresql.util.PSQLException;
import org.postgresql.util.ServerErrorMessage;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/editor-sql"})
public class EditorSqlSimpleController
extends SimpleController {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/executar-sql"}, method={RequestMethod.POST})
    @DBTransaction
    public EditorSqlWrapper executarConsulta(@RequestBody EditorSqlWrapper editor) throws UnicoMensagemUsuarioException {
        block22: {
            ConnectionHandler connectionHandler = (ConnectionHandler)BeanUtil.getBean((String)"connectionHandler");
            Connection conexao = connectionHandler.getConnection();
            String[] comandosSQL = editor.getSql().split(";");
            boolean isUpdate = editor.getSql().toLowerCase().contains("update") || editor.getSql().toLowerCase().contains("insert") || editor.getSql().toLowerCase().contains("delete");
            String query = null;
            Statement stm = null;
            ResultSet rs = null;
            try {
                for (String comandoSQL : comandosSQL) {
                    String comandoSQLFormatado = (comandoSQL = comandoSQL.trim()).replace("\n", " ");
                    if (comandoSQLFormatado.isEmpty()) continue;
                    LogSistema.escreve((String)Log.SQL, (String)comandoSQL);
                    query = comandoSQL;
                    stm = conexao.prepareStatement(comandoSQLFormatado, 1004, 1007);
                    if (comandoSQLFormatado.toLowerCase().startsWith("select")) {
                        rs = stm.executeQuery();
                        continue;
                    }
                    editor.setMsg("Query executada com sucesso: " + stm.executeUpdate() + " linha(s) afetada(s)");
                }
                if (!conexao.getAutoCommit()) {
                    conexao.commit();
                }
                if (rs != null) {
                    this.montarDados(rs, editor);
                }
                if (isUpdate) {
                    this.gravarAuditoria(editor);
                }
            }
            catch (UnicoMensagemUsuarioException | SQLException e) {
                try {
                    if (!conexao.getAutoCommit()) {
                        conexao.rollback();
                    }
                }
                catch (SQLException ex) {
                    throw new UnicoMensagemUsuarioException("WCOM184", (Throwable)ex);
                }
                if (e instanceof SQLException) {
                    this.mostrarMensagemErro(query, (SQLException)e, editor);
                    break block22;
                }
                throw new UnicoMensagemUsuarioException("WWW523", e);
            }
            finally {
                try {
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    throw new UnicoMensagemUsuarioException("WCOM23379", (Throwable)e);
                }
            }
        }
        return editor;
    }

    private void montarDados(ResultSet rs, EditorSqlWrapper editor) throws SQLException, UnicoMensagemUsuarioException {
        ResultSetMetaData md = rs.getMetaData();
        editor.setFieldDefinitions(this.montarColunas(md));
        String[] colunas = new String[md.getColumnCount()];
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            colunas[i - 1] = md.getColumnLabel(i) == null || md.getColumnLabel(i).equalsIgnoreCase("") ? md.getColumnName(i) : md.getColumnLabel(i);
        }
        ArrayList<Object[]> lista = new ArrayList<Object[]>();
        while (rs.next()) {
            Object[] array = new Object[colunas.length];
            for (int col = 0; col < colunas.length; ++col) {
                array[col] = rs.getObject(col + 1);
            }
            lista.add(array);
        }
        StringBuilder jsonh = new StringBuilder();
        int lin = 0;
        int numeroColunas = colunas.length;
        jsonh.append("[");
        for (Object[] linha : lista) {
            if (lin > 0) {
                jsonh.append(',');
            }
            jsonh.append('{');
            for (int i = 0; i < numeroColunas; ++i) {
                String coluna = colunas[i];
                jsonh.append('\"');
                jsonh.append(coluna);
                jsonh.append("\":");
                jsonh.append(EditorSqlSimpleController.normalizaValor((Object)linha[i]));
                if (i >= numeroColunas - 1) continue;
                jsonh.append(',');
            }
            ++lin;
            jsonh.append('}');
        }
        jsonh.append("]");
        editor.setDados(jsonh.toString());
    }

    public static String normalizaValor(Object valor) {
        if (valor == null) {
            return "\"\"";
        }
        if (valor instanceof Timestamp) {
            return "\"" + valor.toString().replace(' ', 'T') + "Z\"";
        }
        return "\"" + StringEscapeUtils.escapeJson((String)valor.toString()) + "\"";
    }

    private List<FieldDefinition> montarColunas(ResultSetMetaData md) throws SQLException, UnicoMensagemUsuarioException {
        ArrayList<FieldDefinition> fields = new ArrayList<FieldDefinition>();
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            try {
                String coluna = md.getColumnLabel(i) == null || md.getColumnLabel(i).equalsIgnoreCase("") ? md.getColumnName(i) : md.getColumnLabel(i);
                Class<?> tipo = Class.forName(md.getColumnClassName(i));
                int scale = md.getScale(i);
                fields.add(new FieldDefinition(coluna, coluna, this.getTipoDado(tipo), 0, true, scale));
                continue;
            }
            catch (ClassNotFoundException c) {
                throw new UnicoMensagemUsuarioException("WWW542", (Throwable)c);
            }
        }
        return fields;
    }

    private TipoDadoBase getTipoDado(Class<?> tipo) {
        for (TipoDadoBase value : TipoDadoBase.values()) {
            if (!value.getClasseJava().equals(tipo)) continue;
            return value;
        }
        return null;
    }

    public void mostrarMensagemErro(String query, SQLException e, EditorSqlWrapper editor) {
        if (e instanceof PSQLException) {
            this.mostrarMensagemPostgreSQL(query, (PSQLException)e, editor);
        } else {
            this.mostrarMensagemGenerica(query, e, editor);
        }
    }

    private void mostrarMensagemGenerica(String query, SQLException e, EditorSqlWrapper editor) {
        editor.setMsg(e.getMessage() + "RollBack executado\nQuery executada: " + query);
    }

    private void mostrarMensagemPostgreSQL(String query, PSQLException e, EditorSqlWrapper editor) {
        ServerErrorMessage errorMessage = e.getServerErrorMessage();
        int posicao = 0;
        if (errorMessage != null) {
            posicao = errorMessage.getPosition();
        }
        String message = e.getMessage() + "\nRollback executado";
        message = posicao > 0 && posicao <= query.length() ? message + "\n" + query.substring(0, posicao - 1) + query.charAt(posicao - 1) + query.substring(posicao) : message + query;
        editor.setMsg(message);
    }

    private void gravarAuditoria(EditorSqlWrapper editor) throws UnicoMensagemUsuarioException {
        String log = editor.getSql() + " | " + editor.getMsg();
        Auditoria auditoria = new Auditoria();
        auditoria.setDataHora(Long.valueOf(System.currentTimeMillis()));
        auditoria.setIdUsuario(SessaoUtil.getSessao().getUsuario().getId());
        auditoria.setLog(log);
        auditoria.setTipo(TipoLog.SQL_MANUAL);
        auditoria.setBuild(UnicoSistema.getVersao());
        AuditoriaCommonRN.getInstance().incluir((AbstractPojo)auditoria, SessaoUtil.getSessao());
    }
}

