/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.cliente.finalizador;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.EntidadeFinalizador;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeFinalizadorRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/finalizadores-entidade"})
public class EntidadeFinalizadorCrudController
extends CrudController<EntidadeFinalizador, EntidadeFinalizadorRN> {
    public EntidadeFinalizadorCrudController() {
        super((AbstractRegraNegocio)EntidadeFinalizadorRN.getInstance(), EntidadeFinalizador::new);
        this.dependsOn("idEntidade");
    }

    protected void beforeSave(EntidadeFinalizador entidadeFinalizador, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)entidadeFinalizador.getIdEntidade())) {
            throw new UnicoMensagemUsuarioException("WWW49", "Entidade n\u00e3o informada.");
        }
        if (NumberUtil.longNullOuZero((Long)entidadeFinalizador.getIdFinalizador())) {
            throw new UnicoMensagemUsuarioException("WWW50", "Finalizador n\u00e3o informado.");
        }
        for (EntidadeFinalizador fin : EntidadeFinalizadorRN.getInstance().buscaFinalizadorPorEntidade(entidadeFinalizador.getIdEntidade())) {
            if (!fin.getIdFinalizador().equals(entidadeFinalizador.getIdFinalizador()) || !NumberUtil.longNullOuZero((Long)entidadeFinalizador.getId()) && (NumberUtil.longNullOuZero((Long)entidadeFinalizador.getId()) || entidadeFinalizador.getId().equals(fin.getId()))) continue;
            throw new UnicoMensagemUsuarioException("WENT26", "Este finalizador j\u00e1 foi inclu\u00eddo! ");
        }
    }

    protected GridBuilder<EntidadeFinalizadorRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idEntidade", "idEntidade", 0, false));
        colunas.add(new ColunaSQL("idFinalizador", "idFinalizador", 0, false));
        colunas.add(new ColunaSQL("nome", "descricaoFinalizador", "Finalizador", 150, true, new String[]{"fk_entidadefin_finalizador"}));
        return new GridBuilder(EntidadeFinalizadorRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "finalizadores-entidade";
    }
}

