/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.cliente.unidademedidacte;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.conhecimento.EntidadeTipoUnidadeMedida;
import br.intelidata.commons.domain.pojo.enuns.conhecimento.TipoUnidadeMedida;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeTipoUnidadeMedidaRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tipos-unidade-entidade"})
public class EntidadeTipoUnidadeMedidaCrudController
extends CrudController<EntidadeTipoUnidadeMedida, EntidadeTipoUnidadeMedidaRN> {
    public EntidadeTipoUnidadeMedidaCrudController() {
        super((AbstractRegraNegocio)EntidadeTipoUnidadeMedidaRN.getInstance(), EntidadeTipoUnidadeMedida::new);
        this.dependsOn("idEntidade");
    }

    protected void beforeSave(EntidadeTipoUnidadeMedida entidadeTipoUnidadeMedida, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)entidadeTipoUnidadeMedida.getIdEntidade())) {
            throw new UnicoMensagemUsuarioException("WWW52", "Entidade n\u00e3o informada.");
        }
        if (StringUtil.stringNullOrEmpty((String)entidadeTipoUnidadeMedida.getCodigo())) {
            throw new UnicoMensagemUsuarioException("WENT35", "Informe a unidade de medida da Nf-e!");
        }
        if (entidadeTipoUnidadeMedida.getTipoUnidade() == null) {
            throw new UnicoMensagemUsuarioException("WENT36", "Informe a unidade de medida do Ct-e!");
        }
    }

    protected GridBuilder<EntidadeTipoUnidadeMedidaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idEntidade", "idEntidade", 0, false));
        colunas.add(new ColunaSQL("codigo", "Unidade nf-e", 150, true));
        colunas.add(new ColunaSQL("tipoUnidade", "Unidade ct-e", 150, true, TipoUnidadeMedida.class));
        return new GridBuilder(EntidadeTipoUnidadeMedidaRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "tipos-unidade-entidade";
    }
}

