/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.estado;

import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.Estado;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.EstadoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/estados"})
@SubMenuMapping(MENU="SubMenuCadastroAuxiliarEnderecos", NOME="Estados", ROTA="/enderecos/estados", PROGRAMA=16)
public class EstadoCrudController
extends CrudController<Estado, EstadoRN> {
    private ResponseEntityService responseEntityService;

    @Autowired
    public EstadoCrudController(ResponseEntityService responseEntityService) {
        super((AbstractRegraNegocio)EstadoRN.getInstance(), Estado::new);
        this.responseEntityService = responseEntityService;
    }

    @RequestMapping(value={"/filtrar-uf"})
    @DBAutoCommit
    public ResponseEntity<String> filtrarUF(@RequestParam(value="query", required=false) String textoPesquisado, @RequestParam(value="limite", required=false, defaultValue="28") Integer limite) {
        String json = EstadoRN.getInstance().getDadosAutocompleteEstadoWeb(textoPesquisado, limite).stream().map(estado -> new StringBuilder("{\"id\":").append(estado.getId().toString()).append(", \"codigo\":").append(JsonUtil.escapeQuote((String)estado.getCodigo())).append(", \"nome\":").append(JsonUtil.escapeQuote((String)estado.getNome())).append(", \"idPais\":").append(estado.getIdPais().toString()).append("}")).collect(Collectors.joining(","));
        return this.responseEntityService.createJSONResponse("[" + json + "]");
    }

    protected GridBuilder<EstadoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 100, true));
        colunas.add(new ColunaSQL("nome", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("nome", "nomePais", "Pa\u00eds", 0, true, new String[]{"fk_estado_pais"}));
        GridBuilder gridBuilder = new GridBuilder(EstadoRN.getInstance().getTabela(), colunas);
        gridBuilder.addOrdemDefault(new Ordem("codigo"));
        return gridBuilder;
    }

    protected String getCacheId() {
        return "estados";
    }
}

