/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.expedicao.carga.baixa;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.GravarAuditoriaUsuario;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.enuns.StatusCargaDocumento;
import br.intelidata.commons.domain.pojo.vendas.Carga;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.AuditoriaRegistroCommonRN;
import br.intelidata.commons.domain.regranegocio.CargaDocumentoCommonRN;
import br.intelidata.commons.modulo.expedicao.regranegocio.CargaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/carga-baixa"})
public class CargaBaixaCrudController
extends SimpleCrudController<Carga, CargaRN> {
    public CargaBaixaCrudController() {
        super((AbstractRegraNegocio)CargaRN.getInstance());
    }

    @DBAutoCommit
    public Carga get(Long parentId) throws UnicoMensagemUsuarioException {
        Carga carga = (Carga)CargaRN.getInstance().buscarPorId(parentId);
        carga.setDocumentos(CargaDocumentoCommonRN.getInstance().buscarListaPorIdCargaComItens(carga.getId()));
        carga.getDocumentos().forEach(dc -> {
            if (dc.getStatus().equals((Object)StatusCargaDocumento.PENDENTE)) {
                dc.setStatus(StatusCargaDocumento.ENTREGUE);
            }
            if (dc.getHistorico() != null) {
                if (!StringUtil.stringNullOrEmpty((String)dc.getHistorico().getDescricaoHistoricoPadrao()) && !dc.getHistorico().getDescricaoHistoricoPadrao().contains(dc.getHistorico().getHistoricoComplementar())) {
                    dc.getHistorico().setDescricaoHistoricoPadrao(dc.getHistorico().getDescricaoHistoricoPadrao() + ": " + dc.getHistorico().getHistoricoComplementar());
                } else if (StringUtil.stringNullOrEmpty((String)dc.getHistorico().getDescricaoHistoricoPadrao()) && !StringUtil.stringNullOrEmpty((String)dc.getHistorico().getHistoricoComplementar())) {
                    dc.getHistorico().setDescricaoHistoricoPadrao(dc.getHistorico().getHistoricoComplementar());
                }
            }
        });
        return carga;
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody Carga carga) throws UnicoMensagemUsuarioException {
        Carga cargaAnterior = (Carga)carga.clonar();
        CargaRN.getInstance().baixarCarga(carga, SessaoUtil.getSessao());
        if (AuditoriaRegistroCommonRN.getInstance().isHabilitarAuditoriaRegistro()) {
            GravarAuditoriaUsuario.getInstance().gravar(SessaoUtil.getSessao(), "carga", 1, (AbstractPojo)cargaAnterior, (AbstractPojo)carga);
        }
        return carga.getId();
    }

    @RequestMapping(value={"/validar-historico"})
    @DBAutoCommit
    public boolean validarExibicaoHistorico(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        CargaRN.getInstance().validaExibicaoHistorico(id);
        return true;
    }
}

