/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.expedicao.conferencia;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.execoes.UnicoPerguntaUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.core.uviewer.UViewer;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Embalagem;
import br.intelidata.commons.domain.pojo.ModeloNotaFiscal;
import br.intelidata.commons.domain.pojo.Pedido;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.Unidademedida;
import br.intelidata.commons.domain.pojo.compras.PedidoCompra;
import br.intelidata.commons.domain.pojo.edi.EDIProcessado;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.OrigemConferencia;
import br.intelidata.commons.domain.pojo.enuns.TipoInclusaoItem;
import br.intelidata.commons.domain.pojo.expedicao.DocumentoConferidoInterface;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.pojo.vendas.ConferenciaDocumento;
import br.intelidata.commons.domain.pojo.vendas.ConferenciaDocumentoDetalhe;
import br.intelidata.commons.domain.pojo.vendas.ConferenciaDocumentoItem;
import br.intelidata.commons.domain.regranegocio.DavCommonRN;
import br.intelidata.commons.domain.regranegocio.NotaFiscalCommonRN;
import br.intelidata.commons.domain.regranegocio.PedidoCommonRN;
import br.intelidata.commons.domain.regranegocio.VariacaoCommonRN;
import br.intelidata.commons.modulo.compras.regranegocio.PedidoCompraRN;
import br.intelidata.commons.modulo.expedicao.regranegocio.CargaRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.commons.modulo.produto.regranegocio.EmbalagemRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.commons.modulo.vendas.regranegocio.ConferenciaDocumentoDetalheRN;
import br.intelidata.commons.modulo.vendas.regranegocio.ConferenciaDocumentoItemDivergenciaRN;
import br.intelidata.commons.modulo.vendas.regranegocio.ConferenciaDocumentoItemRN;
import br.intelidata.commons.modulo.vendas.regranegocio.ConferenciaDocumentoPedidoCompraRN;
import br.intelidata.commons.modulo.vendas.regranegocio.ConferenciaDocumentoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.RelatorioUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ImportacaoDadosColetor;
import br.intelidata.uniplusweb.web.rest.app.client.report.DummyReport;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import br.intelidata.uniplusweb.web.rest.app.crud.expedicao.conferencia.ConferenciaCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.expedicao.conferencia.ConferenciaWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/conferencias"})
public class ConferenciaCrudController {
    @Autowired
    protected ResponseEntityService responseEntityService;

    @RequestMapping(value={"/conferir"})
    @DBAutoCommit
    public ConferenciaWrapper conferir(@RequestParam OrigemConferencia origem, @RequestParam Long[] idsDocumentos) throws UnicoMensagemUsuarioException {
        ConferenciaWrapper wrapper = new ConferenciaWrapper();
        DocumentoConferidoInterface[] documentos = this.getDocumentos(origem, idsDocumentos, true);
        DocumentoConferidoInterface[] todosDocumentosRelacionados = ConferenciaDocumentoDetalheRN.getInstance().buscarDocumentosRelacionadosConferencia(documentos);
        try {
            ConferenciaDocumentoDetalheRN.getInstance().validarDocumentoConferencia(documentos, todosDocumentosRelacionados);
        }
        catch (UnicoPerguntaUsuarioException ex) {
            wrapper.setPergunta(ex.getMensagemSemCodigoDeErro());
        }
        List itens = new ConferenciaDocumentoItemDivergenciaRN().conferir(todosDocumentosRelacionados);
        itens.forEach(it -> {
            if (it.getNotaFiscal() != null) {
                it.setConferirPreco(NotaFiscalRN.getInstance().isNotaFiscalRelacionadaComPedidoCompra(new DocumentoConferidoInterface[]{it.getNotaFiscal()}));
            }
        });
        wrapper.setItens(itens);
        if (OrigemConferencia.NOTA_FISCAL.equals((Object)origem)) {
            wrapper.setQuantidade(((NotaFiscal)documentos[0]).getQuantidade());
            wrapper.setPesoBruto(((NotaFiscal)documentos[0]).getPesoBruto());
            wrapper.setPesoLiquido(((NotaFiscal)documentos[0]).getPesoLiquido());
        } else if (OrigemConferencia.PEDIDO_FATURAMENTO.equals((Object)origem)) {
            wrapper.setQuantidade(((Pedido)documentos[0]).getQuantidadeTransportadora());
            wrapper.setPesoBruto(((Pedido)documentos[0]).getPesoBrutoTransportadora());
            wrapper.setPesoLiquido(((Pedido)documentos[0]).getPesoLiquidoTransportadora());
        }
        wrapper.setConferenciaNotaEntradaTerceiros(documentos[0] instanceof NotaFiscal && ((NotaFiscal)documentos[0]).isNotaEntrada() && ((NotaFiscal)documentos[0]).isEmissaoTerceiros());
        if (wrapper.isConferenciaNotaEntradaTerceiros()) {
            wrapper.setIdFornecedor(((NotaFiscal)documentos[0]).getIdEntidade());
            DocumentoConferidoInterface doc = this.getDocumento(origem, idsDocumentos[0]);
            Long idConferencia = ConferenciaDocumentoDetalheRN.getInstance().buscarIdConferenciaPorDocumento(doc);
            if (!NumberUtil.longNullOuZero((Long)idConferencia)) {
                wrapper.setIdsPedidos(ConferenciaDocumentoPedidoCompraRN.getInstance().buscarIdsPedidosCompraRelacionados(idConferencia));
            } else {
                wrapper.setIdsPedidos(NotaFiscalRN.getInstance().buscaIdsPedidosCompraRelacionadoComNotaFiscal(documentos));
            }
        }
        return wrapper;
    }

    @RequestMapping(value={"/estornar"})
    @DBTransaction
    public void estornar(@RequestParam OrigemConferencia origem, @RequestParam Long[] idsDocumentos) throws UnicoMensagemUsuarioException {
        DocumentoConferidoInterface[] documentos = this.getDocumentos(origem, idsDocumentos, false);
        ConferenciaDocumentoRN.getInstance().estornarConferenciaDocumento(SessaoUtil.getSessao(), documentos);
    }

    @RequestMapping(value={"/verificar-itens-nao-devolvidos"})
    @DBAutoCommit
    public ConferenciaWrapper verificarItensNaoDevolvidos(@RequestParam OrigemConferencia origem, @RequestParam Long[] idsDocumentos) throws UnicoMensagemUsuarioException {
        ConferenciaWrapper wrapper = new ConferenciaWrapper();
        DocumentoConferidoInterface[] documentos = this.getDocumentos(origem, idsDocumentos, false);
        DocumentoConferidoInterface[] todosDocumentosRelacionados = null;
        try {
            todosDocumentosRelacionados = ConferenciaDocumentoDetalheRN.getInstance().buscarDocumentosRelacionadosConferencia(documentos);
            ConferenciaDocumentoDetalheRN.getInstance().validarDocumentosDevolucaoConferencia(documentos, todosDocumentosRelacionados);
        }
        catch (UnicoPerguntaUsuarioException ex) {
            wrapper.setPergunta(ex.getMensagemSemCodigoDeErro());
        }
        Long idEntidade = null;
        for (DocumentoConferidoInterface documento : todosDocumentosRelacionados) {
            Map mapNotaFiscal = NotaFiscalRN.getInstance().buscarValoresPorID(documento.getId(), new String[]{"serie", "identidade"});
            if (Util.mapNullOrEmpty((Map)mapNotaFiscal)) continue;
            if (!ModeloNotaFiscal.NOTA_FISCAL_ELETRONICA.getId().equals(mapNotaFiscal.get("serie"))) {
                throw new UnicoMensagemUsuarioException("WEXP80", "A nota selecionada n\u00e3o \u00e9 uma NF-e (modelo 55)! Verifique.");
            }
            if (idEntidade == null) {
                idEntidade = (Long)mapNotaFiscal.get("identidade");
                continue;
            }
            if (idEntidade.equals(mapNotaFiscal.get("identidade"))) continue;
            throw new UnicoMensagemUsuarioException("WEXP81", "As notas selecionadas devem pertencer ao mesmo fornecedor! Verifique.");
        }
        List idNotas = Arrays.stream(todosDocumentosRelacionados).map(DocumentoConferidoInterface::getId).collect(Collectors.toList());
        wrapper.setIdsNotas(idNotas);
        return wrapper;
    }

    @PostMapping(value={"/gravar-conferencia"})
    @DBTransaction
    public void conferirDocumentos(@RequestBody ConferenciaWrapper wrapper) throws UnicoMensagemUsuarioException {
        ConferenciaDocumentoRN.getInstance().conferirDocumento(SessaoUtil.getSessao(), this.getDocumentos(wrapper.getOrigem(), wrapper.getIdsDocumentos(), false), wrapper.getQuantidade(), wrapper.getPesoBruto(), wrapper.getPesoLiquido(), wrapper.isDivergencia());
    }

    private DocumentoConferidoInterface[] getDocumentos(OrigemConferencia origem, Long[] idsDocumentos, boolean validar) throws UnicoMensagemUsuarioException {
        DocumentoConferidoInterface[] documentos = null;
        switch (1.$SwitchMap$br$intelidata$commons$domain$pojo$enuns$OrigemConferencia[origem.ordinal()]) {
            case 1: {
                documentos = new DocumentoConferidoInterface[]{(DocumentoConferidoInterface)CargaRN.getInstance().buscarPorId(idsDocumentos[0])};
                break;
            }
            case 2: {
                ArrayList<NotaFiscal> notas = new ArrayList<NotaFiscal>();
                for (Long idNota : idsDocumentos) {
                    NotaFiscal nota = (NotaFiscal)NotaFiscalCommonRN.getInstance().buscarPorId(idNota);
                    if (validar && !notas.isEmpty() && notas.stream().noneMatch(nm -> nm.getStatus().equals((Object)nota.getStatus()))) {
                        throw new UnicoMensagemUsuarioException("WNTF9446", "Selecione apenas notas fiscais com o mesmo status.");
                    }
                    notas.add(nota);
                }
                documentos = (DocumentoConferidoInterface[])notas.toArray(new NotaFiscal[0]);
                break;
            }
            case 3: 
            case 4: {
                documentos = new DocumentoConferidoInterface[]{(DocumentoConferidoInterface)DavCommonRN.getInstance().buscarPorId(idsDocumentos[0])};
                break;
            }
            case 5: {
                documentos = new DocumentoConferidoInterface[]{(DocumentoConferidoInterface)PedidoCommonRN.getInstance().buscarPorId(idsDocumentos[0])};
            }
        }
        return documentos;
    }

    @RequestMapping(value={"/buscar-itens"})
    @DBAutoCommit
    public List<ConferenciaDocumentoItem> buscarItens(@RequestParam OrigemConferencia origem, @RequestParam Long idDocumento) {
        DocumentoConferidoInterface doc = this.getDocumento(origem, idDocumento);
        Long idConferencia = ConferenciaDocumentoDetalheRN.getInstance().buscarIdConferenciaPorDocumento(doc);
        if (!NumberUtil.longNullOuZero((Long)idConferencia)) {
            return ConferenciaDocumentoItemRN.getInstance().buscarItensPorIdConferencia(idConferencia, true, true, FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.VARIACAO));
        }
        return Collections.emptyList();
    }

    @PostMapping(value={"/gravar-item"})
    @DBTransaction
    public void gravarItem(@RequestBody ConferenciaDocumentoItem item, @RequestParam OrigemConferencia origem, @RequestParam Long[] idsDocumentos) throws UnicoMensagemUsuarioException {
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(item.getIdProduto());
        item.setNomeProduto(produto.getNome());
        item.setCodigoProduto(produto.getCodigo());
        if (!StringUtil.stringNullOrEmpty((String)item.getVariacoes())) {
            item.setVariacoesComDescricao(VariacaoCommonRN.getInstance().getDescricaoPorVariacoesQuantidade(produto.getId(), item.getVariacoes()));
            item.setVariacaoJaConfigurada(true);
        } else {
            item.setVariacaoJaConfigurada(false);
        }
        if (!NumberUtil.longNullOuZero((Long)item.getIdEmbalagem()) && item.getIdEmbalagem() > 0L) {
            Embalagem embalagem = (Embalagem)EmbalagemRN.getInstance().buscarPorId(item.getIdEmbalagem());
            item.setEmbalagem(embalagem.getFatorConversao());
            item.setIdUnidadeMedida(embalagem.getIdUnidadeMedida());
        } else {
            item.setIdUnidadeMedida(produto.getIdUnidadeMedida());
        }
        Unidademedida unidademedida = (Unidademedida)UnidademedidaRN.getInstance().buscarPorId(item.getIdUnidadeMedida());
        item.setCasasDecimais(unidademedida.getCasasdecimais().intValue());
        item.setDescricaoUnidadeMedida(unidademedida.getCodigo());
        if (!NumberUtil.longNullOuZero((Long)item.getId()) && item.getId() > 0L) {
            ConferenciaDocumentoItemRN.getInstance().alterar((AbstractPojo)item, SessaoUtil.getSessao());
        } else {
            DocumentoConferidoInterface doc = this.getDocumento(origem, idsDocumentos[0]);
            Long idConferencia = ConferenciaDocumentoDetalheRN.getInstance().buscarIdConferenciaPorDocumento(doc);
            ConferenciaDocumento conferencia = ConferenciaDocumentoRN.getInstance().buscarPorId(idConferencia);
            if (NumberUtil.longNullOuZero((Long)idConferencia)) {
                conferencia = new ConferenciaDocumento();
                conferencia.setData(DataHoraFactory.getDataHora());
                conferencia.setIdUsuario(SessaoUtil.getSessao().getUsuario().getId());
                List documentos = Arrays.stream(idsDocumentos).map(id -> this.getDocumento(origem, id)).collect(Collectors.toList());
                for (DocumentoConferidoInterface documento : documentos) {
                    ConferenciaDocumentoDetalhe detalhe = new ConferenciaDocumentoDetalhe();
                    BeanUtil.set((Object)detalhe, (String)documento.getNomeCampoConferencia(), (Object)documento.getId());
                    conferencia.addDetalhe(detalhe);
                }
                ConferenciaDocumentoRN.getInstance().gravar(0, conferencia, SessaoUtil.getSessao());
            }
            ConferenciaDocumentoItemRN.getInstance().gravarItem(item, new ArrayList(), conferencia, item.getTipoInclusao().equals("AGRUPAR"), SessaoUtil.getSessao());
        }
        TipoInclusaoItem tipo = (TipoInclusaoItem)EnumUtils.getPorNomeConstante(TipoInclusaoItem.class, (String)item.getTipoInclusao());
        if (tipo != null) {
            PropriedadeRN.getInstance().setPropriedade(Contexto.getInstance().getSessao(), 1064, tipo.getId());
        }
    }

    @PostMapping(value={"/excluir-item"})
    @DBTransaction
    public void excluirItem(@RequestBody ConferenciaDocumentoItem item) throws UnicoMensagemUsuarioException {
        ConferenciaDocumentoItemRN.getInstance().excluir((AbstractPojo)item, SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/gerar-lista-conferencia-cega"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> gerarRelatorioConferenciaCega(@RequestBody DummyReport report, @RequestParam OrigemConferencia origem, @RequestParam Long[] idsDocumentos) throws UnicoMensagemUsuarioException {
        UViewer v = ConferenciaDocumentoRN.getInstance().gerarRelatorioConferenciaCega(report.getSaida().getSaida(), report.getDelimitador(), report.isPaisagem(), report.getExtensao(), this.getDocumentos(origem, idsDocumentos, false));
        return RelatorioUtil.visualizar((Remessa)v.getRemessa(), (ResponseEntityService)this.responseEntityService, (SaidaRelatorio)report.getSaidaRelatorio(), (String)"Confer\u00eancia cega");
    }

    @RequestMapping(value={"/gerar-lista-conferencia-fisica"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> gerarRelatorioConferenciaFisica(@RequestBody DummyReport report, @RequestParam OrigemConferencia origem, @RequestParam Long[] idsDocumentos) throws UnicoMensagemUsuarioException {
        UViewer v = ConferenciaDocumentoRN.getInstance().gerarRelatorioListaConferenciaFisica(report.getSaida().getSaida(), report.getDelimitador(), report.isPaisagem(), report.getExtensao(), this.getDocumentos(origem, idsDocumentos, false));
        return RelatorioUtil.visualizar((Remessa)v.getRemessa(), (ResponseEntityService)this.responseEntityService, (SaidaRelatorio)report.getSaidaRelatorio(), (String)"Confer\u00eancia f\u00edsica");
    }

    @RequestMapping(value={"/gerar-lista-divergencias"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> gerarRelatorioDivergencias(@RequestBody DummyReport report, @RequestParam OrigemConferencia origem, @RequestParam Long[] idsDocumentos) throws UnicoMensagemUsuarioException {
        UViewer v = ConferenciaDocumentoRN.getInstance().gerarRelatorioDivergencia(report.getSaida().getSaida(), report.getDelimitador(), report.isPaisagem(), report.getExtensao(), this.getDocumentos(origem, idsDocumentos, false));
        return RelatorioUtil.visualizar((Remessa)v.getRemessa(), (ResponseEntityService)this.responseEntityService, (SaidaRelatorio)report.getSaidaRelatorio(), (String)"Confer\u00eancia cega");
    }

    @RequestMapping(value={"/gerar-relatorio-conferencia"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> gerarRelatorioConferencia(@RequestBody DummyReport report, @RequestParam OrigemConferencia origem, @RequestParam Long[] idsDocumentos, @RequestParam boolean conferencia) throws UnicoMensagemUsuarioException {
        DocumentoConferidoInterface[] documentos = this.getDocumentos(origem, idsDocumentos, false);
        UViewer v = conferencia ? ConferenciaDocumentoRN.getInstance().gerarRelatorioDivergencia(report.getSaida().getSaida(), report.getDelimitador(), report.isPaisagem(), report.getExtensao(), this.conferir(origem, idsDocumentos).getItens(), documentos[0] instanceof NotaFiscal && NotaFiscalRN.getInstance().isNotaFiscalRelacionadaComPedidoCompra(documentos), Arrays.stream(documentos).map(DocumentoConferidoInterface::getIdentificadorDocumento).collect(Collectors.joining(", "))) : ConferenciaDocumentoRN.getInstance().gerarRelatorioConferenciaCega(report.getSaida().getSaida(), report.getDelimitador(), report.isPaisagem(), report.getExtensao(), this.buscarItens(origem, idsDocumentos[0]), Arrays.stream(documentos).map(DocumentoConferidoInterface::getIdentificadorDocumento).collect(Collectors.joining(", ")));
        return RelatorioUtil.visualizar((Remessa)v.getRemessa(), (ResponseEntityService)this.responseEntityService, (SaidaRelatorio)report.getSaidaRelatorio(), (String)"Confer\u00eancia");
    }

    private DocumentoConferidoInterface getDocumento(OrigemConferencia origem, Long idDocumento) {
        switch (1.$SwitchMap$br$intelidata$commons$domain$pojo$enuns$OrigemConferencia[origem.ordinal()]) {
            case 1: {
                return (DocumentoConferidoInterface)CargaRN.getInstance().buscarPorId(idDocumento);
            }
            case 2: {
                return (DocumentoConferidoInterface)NotaFiscalCommonRN.getInstance().buscarPorId(idDocumento);
            }
            case 3: 
            case 4: {
                return (DocumentoConferidoInterface)DavCommonRN.getInstance().buscarPorId(idDocumento);
            }
            case 5: {
                return (DocumentoConferidoInterface)PedidoCommonRN.getInstance().buscarPorId(idDocumento);
            }
        }
        return null;
    }

    @RequestMapping(value={"/importar-edi"}, method={RequestMethod.POST})
    @DBAutoCommit
    public EDIProcessado<ConferenciaDocumentoItem> importarArquivoEdi(MultipartFile file, Long idEdi, @RequestParam MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        OrigemConferencia origemConferencia = (OrigemConferencia)EnumUtils.getPorNomeConstante(OrigemConferencia.class, (String)((String)((List)parameters.get((Object)"origem")).get(0)));
        Long idDocumento = NumberUtil.toLong((String)((String)((List)parameters.get((Object)"idDocumento")).get(0)));
        ImportacaoDadosColetor importacaoDadosColetor = new ImportacaoDadosColetor(ConferenciaDocumentoItem.class, idEdi, file);
        importacaoDadosColetor.importar();
        EDIProcessado ediProcessado = new EDIProcessado();
        ediProcessado.getCriticas().addAll(importacaoDadosColetor.getEDIProcessado().getCriticas());
        ediProcessado.setConferenciaItens(importacaoDadosColetor.getEDIProcessado().getConferenciaItens());
        for (ConferenciaDocumentoItem item : importacaoDadosColetor.getEDIProcessado().getConferenciaItens()) {
            this.gravarItem(item, origemConferencia, new Long[]{idDocumento});
        }
        return ediProcessado;
    }

    @PostMapping(value={"/buscar-pedidos-compra"})
    @DBAutoCommit
    public List<PedidoCompra> buscarPedidosCompra(@RequestBody ConferenciaWrapper wrapper) {
        ArrayList idsPedidosConsiderar = new ArrayList();
        if (wrapper.getIdsPedidos() != null) {
            idsPedidosConsiderar.addAll(wrapper.getIdsPedidos());
        }
        idsPedidosConsiderar.addAll(NotaFiscalRN.getInstance().buscaIdsPedidosCompraRelacionadoComNotaFiscalPorListaId(wrapper.getIdsDocumentos()));
        return PedidoCompraRN.getInstance().buscaPedidosEmAbertoPorFornecedor(SessaoUtil.getSessao().getFilial().getId(), wrapper.getIdFornecedor(), idsPedidosConsiderar, wrapper.getIdsPedidos());
    }

    @PostMapping(value={"/adicionar-pedidos-compra"})
    @DBTransaction
    public void adicionarPedidosCompra(@RequestBody ConferenciaWrapper wrapper) throws UnicoMensagemUsuarioException {
        DocumentoConferidoInterface doc = this.getDocumento(wrapper.getOrigem(), wrapper.getIdsDocumentos()[0]);
        Long idConferencia = ConferenciaDocumentoDetalheRN.getInstance().buscarIdConferenciaPorDocumento(doc);
        if (NumberUtil.longNullOuZero((Long)idConferencia)) {
            ConferenciaDocumento conferencia = new ConferenciaDocumento();
            conferencia.setData(DataHoraFactory.getDataHora());
            conferencia.setIdUsuario(SessaoUtil.getSessao().getUsuario().getId());
            List documentos = Arrays.stream(wrapper.getIdsDocumentos()).map(id -> this.getDocumento(wrapper.getOrigem(), id)).collect(Collectors.toList());
            for (DocumentoConferidoInterface documento : documentos) {
                ConferenciaDocumentoDetalhe detalhe = new ConferenciaDocumentoDetalhe();
                BeanUtil.set((Object)detalhe, (String)documento.getNomeCampoConferencia(), (Object)documento.getId());
                conferencia.addDetalhe(detalhe);
            }
            conferencia.setPedidosCompraRelacionados(wrapper.getIdsPedidos());
            ConferenciaDocumentoRN.getInstance().gravar(0, conferencia, SessaoUtil.getSessao());
        } else {
            ConferenciaDocumento conferencia = ConferenciaDocumentoRN.getInstance().buscarPorId(idConferencia);
            conferencia.setPedidosCompraRelacionados(wrapper.getIdsPedidos());
            ConferenciaDocumentoRN.getInstance().gravar(1, conferencia, SessaoUtil.getSessao());
        }
    }
}

