/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro.configuracaoconciliacaorecebimento;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.conciliacaorecebimento.IntegracaoConciliacaoRecebimento;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.integracao.ConfiguracaoConciliadoraRecebimento;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.financeiro.regranegocio.ConfiguracaoConciliadoraRecebimentoFilialRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ConfiguracaoConciliadoraRecebimentoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/configuracao-conciliacao-recebimento"})
@SubMenuMapping(MENU="SubMenuFinanceiroAuxiliar", NOME="Configura\u00e7\u00e3o de concilia\u00e7\u00e3o de recebimentos", ROTA="/financeiros/configuracao-conciliacao-recebimento", PROGRAMA=1130)
public class ConfiguracaoConcilicaoRecebimentoCrudController
extends SimpleCrudController<ConfiguracaoConciliadoraRecebimento, ConfiguracaoConciliadoraRecebimentoRN> {
    @Autowired
    private NotificationService notificationService;

    public ConfiguracaoConcilicaoRecebimentoCrudController() {
        super((AbstractRegraNegocio)ConfiguracaoConciliadoraRecebimentoRN.getInstance());
    }

    @DBAutoCommit
    public ConfiguracaoConciliadoraRecebimento get(Long parentId) {
        return ConfiguracaoConciliadoraRecebimentoRN.getInstance().buscarConfiguracao(SessaoUtil.getSessao());
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody ConfiguracaoConciliadoraRecebimento conf) throws UnicoMensagemUsuarioException {
        return this.gravar(conf);
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody ConfiguracaoConciliadoraRecebimento conf) throws UnicoMensagemUsuarioException {
        return this.gravar(conf);
    }

    private Long gravar(ConfiguracaoConciliadoraRecebimento conf) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        int transacao = Util.longNullOuZero((Long)conf.getId()) ? 0 : 1;
        ConfiguracaoConciliadoraRecebimentoRN.getInstance().gravar(transacao, (AbstractPojo)conf, sessao);
        ConfiguracaoConciliadoraRecebimentoFilialRN.getInstance().gravaAtualizaDadosPorFilial(sessao, conf.getId(), conf.getIdsFiliais());
        IntegracaoConciliacaoRecebimento integracao = new IntegracaoConciliacaoRecebimento(Contexto.getInstance().getSessao());
        integracao.atualizarOperadoras(sessao, null, false);
        integracao.atualizarBandeiras(sessao, null, false);
        integracao.atualizarProdutosConciliadora(sessao, null, false);
        return 0L;
    }
}

