/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro.lancamentocontacorrente;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.ConnectionSql;
import br.intelidata.commons.core.sql.usql.Caso;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Constante;
import br.intelidata.commons.core.sql.usql.Escolha;
import br.intelidata.commons.core.sql.usql.OperacaoUnaria;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.OperadorUnario;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.Separador;
import br.intelidata.commons.core.sql.usql.USelect;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.EventoFinanceiro;
import br.intelidata.commons.domain.pojo.FinanceiroDado;
import br.intelidata.commons.domain.pojo.HierarquiaPlanoContas;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.enuns.TipoEventoFinanceiro;
import br.intelidata.commons.domain.pojo.enuns.TipoLancamentoContaCorrente;
import br.intelidata.commons.domain.pojo.enuns.contabil.ModuloSistemaPeriodoContabil;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrente;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteLancamento;
import br.intelidata.commons.domain.pojo.financeiro.NegociacaoFinanceiro;
import br.intelidata.commons.domain.pojo.financeiro.TipoContaCorrente;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.FinanceiroDadoCommonRN;
import br.intelidata.commons.domain.regranegocio.NotaFiscalCommonRN;
import br.intelidata.commons.domain.regranegocio.OperacaoCommonRN;
import br.intelidata.commons.domain.wrapper.ListaIDWrapper;
import br.intelidata.commons.modulo.contabilidade.regranegocio.PeriodoContabilRN;
import br.intelidata.commons.modulo.financeiro.centrocusto.enuns.OrigemRateioCentroCusto;
import br.intelidata.commons.modulo.financeiro.centrocusto.regranegocio.CentroCustoRateioRN;
import br.intelidata.commons.modulo.financeiro.enums.OperacaoLancamentoFinanceiro;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteLancamentoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.EventoFinanceiroRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroDadoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.HierarquiaPlanoContasRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.NegociacaoFinanceiroRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.grid.Operator;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.lancamentocontacorrente.FiltroBancoOnlineWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.lancamentocontacorrente.RetornoConsultaConciliacaoOnline;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.lancamentocontacorrente.ValidacaoEstornoLancamentoFinanceiroWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.lancamentocontacorrente.ValidacaoExclusaoLancamentoFinanceiroWrapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/lancamentos-conta-corrente"})
public class ContaCorrenteLancamentoCrudController
extends CrudController<ContaCorrenteLancamento, ContaCorrenteLancamentoRN> {
    private boolean caixa;
    private final FuncionalidadeService funcionalidadeService;

    @Autowired
    public ContaCorrenteLancamentoCrudController(FuncionalidadeService funcionalidadeService) {
        super((AbstractRegraNegocio)ContaCorrenteLancamentoRN.getInstance(), ContaCorrenteLancamento::new);
        this.funcionalidadeService = funcionalidadeService;
    }

    public ContaCorrenteLancamentoCrudController(FuncionalidadeService funcionalidadeService, boolean caixa) {
        super((AbstractRegraNegocio)ContaCorrenteLancamentoRN.getInstance(), ContaCorrenteLancamento::new, true, true);
        this.funcionalidadeService = funcionalidadeService;
        this.caixa = caixa;
    }

    @RequestMapping(value={"/validar-estorno"})
    @DBAutoCommit
    public ValidacaoEstornoLancamentoFinanceiroWrapper validarEstornoExclusao(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        return this.validar((ContaCorrenteLancamento)ContaCorrenteLancamentoRN.getInstance().buscarPorId(id));
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @DBTransaction
    public void delete(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        ContaCorrenteLancamento lancamento = (ContaCorrenteLancamento)ContaCorrenteLancamentoRN.getInstance().buscarPorId(id);
        this.validar(lancamento);
        this.gravarAuditoriaRegistro(id, null, 2);
        if (!Util.longNullOuZero((Long)lancamento.getEvento())) {
            NegociacaoFinanceiro negociacao;
            if (lancamento.isIdentificado() && FinanceiroDadoRN.getInstance().buscaDocumentoAdiantamentoPorEvento(lancamento.getEvento()) != null) {
                ContaCorrenteLancamentoRN.getInstance().excluir(lancamento, SessaoUtil.getSessao());
            }
            if ((negociacao = NegociacaoFinanceiroRN.getInstance().buscarNegociacaoPorEventoFinanceiro(lancamento.getEvento())) != null) {
                NegociacaoFinanceiroRN.getInstance().estornarNegociacao(SessaoUtil.getSessao(), negociacao.getId());
            } else {
                EventoFinanceiroRN.getInstance().estornaBaixa(EventoFinanceiroRN.getInstance().buscarPorId(lancamento.getEvento()), SessaoUtil.getSessao());
            }
        } else {
            ContaCorrenteLancamentoRN.getInstance().excluir(lancamento, SessaoUtil.getSessao());
        }
        this.notificationService.notifyTenantNow(NotificationType.DASH_BOARD, "");
    }

    protected void tratarParametros(MultiValueMap<String, String> parameters) {
        parameters.remove((Object)"saldoAnterior");
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) {
        String saldoAnterior;
        BigDecimal saldo = BigDecimal.ZERO;
        boolean carregar = true;
        if (!ListMapUtil.mapNullOrEmpty(parameters) && !StringUtil.stringNullOrEmpty((String)(saldoAnterior = (String)parameters.getFirst((Object)"saldoAnterior")))) {
            saldo = new BigDecimal(saldoAnterior);
            carregar = false;
        }
        if (!ListMapUtil.listNullOrEmpty(filters) && carregar) {
            Long idContaCorrente = filters.stream().filter(filterField -> filterField.getField().equals("idcontacorrente")).findFirst().map(filterField -> Long.parseLong(filterField.getValue1())).orElse(-1L);
            LocalDate dataInicial = filters.stream().filter(filterField -> filterField.getField().equals("dataFiltro") && Operator.OPERADOR_MAIOR_IGUAL.getId().equals(filterField.getFilter())).findFirst().map(filterField -> DataHoraFactory.string2LocalDate((String)filterField.getValue1(), (String)"dd/MM/yyyy")).orElse(null);
            saldo = ContaCorrenteRN.getInstance().getSaldoNaData(idContaCorrente, dataInicial != null ? dataInicial.minusDays(1L) : null);
        }
        for (Object[] registro : dados) {
            int idxEntrada = this.getIndexColuna("entrada", colunas);
            int idxSaida = this.getIndexColuna("saida", colunas);
            int idxSaldo = this.getIndexColuna("valorfinal", colunas);
            if (idxEntrada <= -1 || idxSaida <= -1 || idxSaldo <= -1) continue;
            BigDecimal entrada = (BigDecimal)registro[idxEntrada];
            BigDecimal saida = (BigDecimal)registro[idxSaida];
            saldo = entrada.compareTo(BigDecimal.ZERO) > 0 ? saldo.add(entrada) : saldo.subtract(saida);
            registro[idxSaldo] = saldo;
        }
    }

    protected void afterSave(ContaCorrenteLancamento lancamento, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        ContaCorrenteLancamento lancamento1 = (ContaCorrenteLancamento)ContaCorrenteLancamentoRN.getInstance().buscarPorId(lancamento.getId());
        if (lancamento.getOperacao().equals((Object)OperacaoLancamentoFinanceiro.TRANFERENCIA)) {
            Long idLancamento1 = lancamento1.getId();
            ContaCorrente origem = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(lancamento.getIdContaCorrenteTranferencia());
            ContaCorrente destino = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(lancamento.getIdcontacorrente());
            String texto = "Transfer\u00eancia do " + (origem.isCaixa() ? "caixa " : "banco ") + origem.getDescricao() + ", para o " + (destino.isCaixa() ? "caixa " : "banco ") + destino.getDescricao() + ".";
            if (lancamento1.getHistorico() != null) {
                lancamento1.setHistorico(lancamento1.getHistorico() + "\n " + texto);
            } else {
                lancamento1.setHistorico(texto);
            }
            ContaCorrenteLancamento lancamento2 = (ContaCorrenteLancamento)lancamento1.clonar();
            lancamento2.setIdLancamentoTransferencia(idLancamento1);
            lancamento2.setTipo(TipoLancamentoContaCorrente.DEBITO.getId());
            if (this.funcionalidadeService.isAtiva(Funcionalidade.PLANO_DE_CONTAS)) {
                lancamento2.setIdplanocontas(lancamento.getIdPlanoContasTransferencia());
            }
            lancamento2.setIdcontacorrente(lancamento.getIdContaCorrenteTranferencia());
            lancamento2.setIdFilial(lancamento.getIdFilialSaida());
            Long idLancamento2 = ContaCorrenteLancamentoRN.getInstance().incluir(lancamento2, SessaoUtil.getSessao());
            lancamento1.setIdLancamentoTransferencia(idLancamento2);
            ContaCorrenteLancamentoRN.getInstance().alterar(lancamento1, SessaoUtil.getSessao());
        }
        if (PropriedadeRN.getInstance().getPropriedadeBoolean(Contexto.getInstance().getFilial(), 597)) {
            if (TipoLancamentoContaCorrente.DEBITO.getId().equals(lancamento.getTipo())) {
                PropriedadeRN.getInstance().setPropriedade(SessaoUtil.getSessao(), 595, lancamento.getIdplanocontas());
            } else {
                PropriedadeRN.getInstance().setPropriedade(SessaoUtil.getSessao(), 596, lancamento.getIdplanocontas());
            }
        }
    }

    protected void beforeSave(ContaCorrenteLancamento lancamento, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        HierarquiaPlanoContas planoContas;
        lancamento.setTipo(lancamento.getOperacao().equals((Object)OperacaoLancamentoFinanceiro.SAIDA) ? TipoLancamentoContaCorrente.DEBITO.getId() : TipoLancamentoContaCorrente.CREDITO.getId());
        if (this.funcionalidadeService.isAtiva(Funcionalidade.CONCILIACAO_BANCARIA)) {
            lancamento.setIdUsuarioConciliacao(lancamento.getDataConciliacao() == null ? null : SessaoUtil.getSessao().getIdUsuario());
        }
        lancamento.setIdusuario(SessaoUtil.getSessao().getIdUsuario());
        lancamento.setTipoContaCorrente(this.caixa ? TipoContaCorrente.CAIXA : TipoContaCorrente.BANCOS);
        if (lancamento.getOperacao().equals((Object)OperacaoLancamentoFinanceiro.TRANFERENCIA)) {
            ContaCorrente origem = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(lancamento.getIdContaCorrenteTranferencia());
            ContaCorrente destino = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(lancamento.getIdcontacorrente());
            ArrayList<ModuloSistemaPeriodoContabil> sistemas = new ArrayList<ModuloSistemaPeriodoContabil>();
            sistemas.add(origem.isCaixa() ? ModuloSistemaPeriodoContabil.CAIXA : ModuloSistemaPeriodoContabil.BANCO);
            sistemas.add(destino.isCaixa() ? ModuloSistemaPeriodoContabil.CAIXA : ModuloSistemaPeriodoContabil.BANCO);
            PeriodoContabilRN.getInstance().validaPeriodoContabil(SessaoUtil.getSessao(), 0, sistemas, lancamento.getDataPeriodoContabil());
        }
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CENTRO_CUSTO) && (planoContas = (HierarquiaPlanoContas)HierarquiaPlanoContasRN.getInstance().buscarPorId(lancamento.getIdplanocontas())) != null && planoContas.isCentroCustoObrigatorio()) {
            CentroCustoRateioRN.getInstance().validarRateio(lancamento.getValor(), lancamento.getRateiosCentroCusto());
        }
    }

    protected GridBuilder<ContaCorrenteLancamentoRN> getGridBuilder() {
        USelect subQueryFormaPagamento = new USelect("eventofinanceirodestino", "formaPagamento");
        subQueryFormaPagamento.add(new ColunaSQL("descricao", "descricaoformapagamento", "Descri\u00e7\u00e3o", 120, true, new String[]{"fk_eventofinanceirodestino_2"}));
        subQueryFormaPagamento.add((ColunaSQL)new Referencia("idcontacorrentelancamento", "idcontacorrentelancamento"));
        subQueryFormaPagamento.add(new Condicao("idcontacorrentelancamento", Operador.IGUAL_REFERENCIA_EXTERNA, "id"));
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("evento", "Evento", 0, false));
        colunas.add(new ColunaSQL("datahora", "Data", 120, true));
        colunas.add(new ColunaSQL("historico", "Hist\u00f3rico", 350, true));
        ColunaSQL colunaEntrada = new ColunaSQL(new Escolha(new Caso(new Condicao("valor", Operador.MAIOR_QUE, BigDecimal.ZERO), "valor"), new Constante((Object)BigDecimal.ZERO)), "entrada", "Entrada", 120, true, true);
        colunaEntrada.setClasseValor(BigDecimal.class);
        colunas.add(colunaEntrada);
        ColunaSQL colunaSaida = new ColunaSQL(new Escolha(new Caso(new Condicao("valor", Operador.MENOR_QUE, BigDecimal.ZERO), new OperacaoUnaria("valor", OperadorUnario.NEGACAO)), new Constante((Object)BigDecimal.ZERO)), "saida", "Sa\u00edda", 120, true, true);
        colunaSaida.setClasseValor(BigDecimal.class);
        colunas.add(colunaSaida);
        ColunaSQL colunaSaldo = new ColunaSQL("valor", "valorfinal", "Saldo", 120, true, new String[0]);
        colunaSaldo.setVirtual(true);
        colunaSaldo.setTotalizar(true);
        colunas.add(colunaSaldo);
        ColunaSQL colunaSubQueryFormaPagamento = new ColunaSQL(subQueryFormaPagamento, "Descri\u00e7\u00e3o", 180, true);
        colunaSubQueryFormaPagamento.setClasseValor(String.class);
        colunas.add(colunaSubQueryFormaPagamento);
        colunas.add(new ColunaSQL("nome", "nomePlanoContas", "Plano", 250, true, new String[]{"fk_contacorrentelancamento_planocontas"}));
        colunas.add(new ColunaSQL("nome", "nomeEntidade", "Fornec./Cliente", 250, true, new String[]{"fk_contacorrentelancamento_eve", "fk_eventofinanceiro_entidade"}));
        colunas.add(new ColunaSQL("nome", "nomeUsuario", "Usu\u00e1rio", 250, true, new String[]{"fk_contacorrentelancamento_usuario"}));
        colunas.add(new ColunaSQL("datahora", "dataFiltro", "Data", 120, false, new String[0]));
        GridBuilder grid = new GridBuilder(((ContaCorrenteLancamentoRN)this.rn).getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("status", "statusEvento", new String[]{"fk_contacorrentelancamento_eve"}));
        grid.addReferenciaDefault(new Referencia("idcontacorrente", "idcontacorrente"));
        grid.addReferenciaDefault(new Referencia("valor", "valor"));
        grid.addCodicaoDefault(new Condicao(Separador.ABRE_PARENTESIS));
        grid.addCodicaoDefault(new Condicao("statusEvento", Operador.IS_NULL));
        grid.addCodicaoDefault(new Condicao(OperadorLogico.OU));
        grid.addCodicaoDefault(new Condicao("statusEvento", Operador.DIFERENTE, "E"));
        grid.addCodicaoDefault(new Condicao(Separador.FECHA_PARENTESIS));
        grid.addCondicao(new Condicao("idcontacorrente", Operador.IGUAL, -9999));
        grid.addOrdemDefault(new Ordem("dataFiltro"));
        grid.addOrdemDefault(new Ordem("id"));
        return grid;
    }

    protected String getCacheId() {
        return "lancamentos-conta-corrente".concat(this.caixa ? "caixa" : "banco");
    }

    protected void beforeRead(ContaCorrenteLancamento lancamento, int modo, Optional<Long> parentId) {
        HierarquiaPlanoContas planoContas;
        FinanceiroDado documentoAdiantamento;
        if (lancamento.getTipo().equals(TipoLancamentoContaCorrente.DEBITO.getId())) {
            lancamento.setValor(lancamento.getValor().negate());
            lancamento.setOperacao(OperacaoLancamentoFinanceiro.SAIDA);
        } else {
            lancamento.setOperacao(OperacaoLancamentoFinanceiro.ENTRADA);
        }
        if (lancamento.isIdentificado() && !Util.longNullOuZero((Long)lancamento.getEvento()) && (documentoAdiantamento = FinanceiroDadoCommonRN.getInstance().buscaDocumentoAdiantamentoPorEvento(lancamento.getEvento())) != null) {
            lancamento.setIdEntidade(documentoAdiantamento.getIdEntidade());
        }
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CENTRO_CUSTO) && (planoContas = (HierarquiaPlanoContas)HierarquiaPlanoContasRN.getInstance().buscarPorId(lancamento.getIdplanocontas())) != null && planoContas.isCentroCustoObrigatorio()) {
            lancamento.setRateiosCentroCusto(CentroCustoRateioRN.getInstance().buscaRateios(OrigemRateioCentroCusto.LANCAMENTO, lancamento.getId()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/validar-exclusao"})
    @DBAutoCommit
    public ValidacaoExclusaoLancamentoFinanceiroWrapper validarExclusao(@RequestBody ListaIDWrapper listaIDWrapper) throws UnicoMensagemUsuarioException {
        ValidacaoExclusaoLancamentoFinanceiroWrapper wrapper = new ValidacaoExclusaoLancamentoFinanceiroWrapper();
        StringBuilder mensagem = new StringBuilder();
        List lancamentosSelecionados = ContaCorrenteLancamentoRN.getInstance().getLancamentosPorListaID(listaIDWrapper.getIds(), false, false);
        if (!Util.listNullOrEmpty((List)lancamentosSelecionados)) {
            void var11_20;
            Long idEvento;
            boolean isExisteLanamentosParaExclusao;
            Map<Long, List<ContaCorrenteLancamento>> mapLancamentosPorEvento = lancamentosSelecionados.stream().filter(f -> f.getEvento() != null).collect(Collectors.groupingBy(ContaCorrenteLancamento::getEvento));
            List listLancamentosSemEvento = lancamentosSelecionados.stream().filter(f -> f.getEvento() == null).collect(Collectors.toList());
            HashMap mensagemLancamentosExcluidos = new HashMap();
            HashMap mensagemLancamentosNaoExcluidos = new HashMap();
            HashMap mensagemLancamentosNotasFiscais = new HashMap();
            for (Long l : mapLancamentosPorEvento.keySet()) {
                ContaCorrenteLancamentoRN.getInstance().validaLancamento(l, mensagemLancamentosNaoExcluidos, mensagemLancamentosExcluidos, mensagemLancamentosNotasFiscais, lancamentosSelecionados);
            }
            boolean bl = isExisteLanamentosParaExclusao = !mensagemLancamentosExcluidos.isEmpty() || !Util.listNullOrEmpty(listLancamentosSemEvento);
            if (isExisteLanamentosParaExclusao) {
                mensagem.append("Lan\u00e7amentos que ser\u00e3o exclu\u00eddos:");
                for (Map.Entry entry : mensagemLancamentosExcluidos.entrySet()) {
                    idEvento = (Long)entry.getKey();
                    ContaCorrenteLancamentoRN.getInstance().montaMensagem((String)entry.getValue(), mapLancamentosPorEvento.get(idEvento), mensagem);
                }
                ContaCorrenteLancamentoRN.getInstance().montaMensagem("Estorno do lan\u00e7amento", listLancamentosSemEvento, mensagem);
            }
            if (!isExisteLanamentosParaExclusao && mensagemLancamentosNaoExcluidos.isEmpty() && !mensagemLancamentosNotasFiscais.isEmpty()) {
                wrapper.setMensagem("Deseja estornar o(s) lan\u00e7amento(s)?");
                wrapper.setPerguntar(true);
                return wrapper;
            }
            if (!mensagemLancamentosNaoExcluidos.isEmpty() || !mensagemLancamentosNotasFiscais.isEmpty()) {
                if (isExisteLanamentosParaExclusao) {
                    mensagem.append("<br>");
                }
                mensagem.append("Lan\u00e7amentos que n\u00e3o ser\u00e3o exclu\u00eddos:");
                if (!isExisteLanamentosParaExclusao) {
                    mensagem.append("<br>");
                }
                for (Map.Entry entry : mensagemLancamentosNaoExcluidos.entrySet()) {
                    idEvento = (Long)entry.getKey();
                    ContaCorrenteLancamentoRN.getInstance().montaMensagem((String)entry.getValue(), mapLancamentosPorEvento.get(idEvento), mensagem);
                }
                for (Map.Entry entry : mensagemLancamentosNotasFiscais.entrySet()) {
                    idEvento = (Long)entry.getKey();
                    ContaCorrenteLancamentoRN.getInstance().montaMensagem((String)entry.getValue(), mapLancamentosPorEvento.get(idEvento), mensagem);
                }
            }
            if (mensagemLancamentosExcluidos.isEmpty() && Util.listNullOrEmpty(listLancamentosSemEvento)) {
                wrapper.setMensagem("Nenhum dos lan\u00e7amentos pode ser exclu\u00eddo. Verifique os motivos abaixo.");
                wrapper.setDetalhe(mensagem.toString());
                return wrapper;
            }
            String string = "Todos os lan\u00e7amentos selecionados ser\u00e3o exclu\u00eddos. ";
            if (!mensagemLancamentosNaoExcluidos.isEmpty() || !mensagemLancamentosNotasFiscais.isEmpty()) {
                String string2 = "Nem todos os lan\u00e7amentos selecionados ser\u00e3o exclu\u00eddos. Verifique os motivos abaixo.";
            }
            wrapper.setMensagem((String)var11_20 + " Deseja continuar?");
            wrapper.setDetalhe(mensagem.toString().replace(Util.lineSeparator, "<br>"));
            wrapper.setPerguntar(true);
            return wrapper;
        }
        return null;
    }

    @PostMapping(value={"/excluir-estornar-documentos"})
    @DBAutoCommit
    public void excluirDocumentos(@RequestBody ListaIDWrapper listaIDWrapper) throws UnicoMensagemUsuarioException {
        List lancamentosSelecionados = ContaCorrenteLancamentoRN.getInstance().getLancamentosPorListaID(listaIDWrapper.getIds(), false, false);
        if (!Util.listNullOrEmpty((List)lancamentosSelecionados)) {
            boolean isExisteLanamentosParaExclusao;
            Map<Long, List<ContaCorrenteLancamento>> mapLancamentosPorEvento = lancamentosSelecionados.stream().filter(f -> f.getEvento() != null).collect(Collectors.groupingBy(ContaCorrenteLancamento::getEvento));
            List listLancamentosSemEvento = lancamentosSelecionados.stream().filter(f -> f.getEvento() == null).collect(Collectors.toList());
            HashMap mensagemLancamentosExcluidos = new HashMap();
            HashMap mensagemLancamentosNaoExcluidos = new HashMap();
            HashMap mensagemLancamentosNotasFiscais = new HashMap();
            for (Long idEvento : mapLancamentosPorEvento.keySet()) {
                ContaCorrenteLancamentoRN.getInstance().validaLancamento(idEvento, mensagemLancamentosNaoExcluidos, mensagemLancamentosExcluidos, mensagemLancamentosNotasFiscais, lancamentosSelecionados);
            }
            boolean bl = isExisteLanamentosParaExclusao = !mensagemLancamentosExcluidos.isEmpty() || !Util.listNullOrEmpty(listLancamentosSemEvento);
            if (!isExisteLanamentosParaExclusao && mensagemLancamentosNaoExcluidos.isEmpty() && !mensagemLancamentosNotasFiscais.isEmpty()) {
                for (Map.Entry entry : mensagemLancamentosNotasFiscais.entrySet()) {
                    for (ContaCorrenteLancamento lancamento : lancamentosSelecionados.stream().filter(f -> f.getEvento().equals(entry.getKey())).collect(Collectors.toList())) {
                        ContaCorrenteLancamentoRN.getInstance().criaEstornoGerandoLancamentoContrarioAoAtual(Contexto.getInstance().getSessao(), lancamento, Contexto.getInstance().getUsuario().getId());
                    }
                }
            } else if (!mensagemLancamentosExcluidos.isEmpty() || !Util.listNullOrEmpty(listLancamentosSemEvento)) {
                ConnectionSql.inicioTransacao();
                if (!Util.listNullOrEmpty(listLancamentosSemEvento)) {
                    for (ContaCorrenteLancamento lancamento : listLancamentosSemEvento) {
                        ContaCorrenteLancamentoRN.getInstance().excluir(lancamento, Contexto.getInstance().getSessao());
                    }
                }
                ContaCorrenteLancamentoRN.getInstance().excluirLancamentos(SessaoUtil.getSessao(), mapLancamentosPorEvento, mensagemLancamentosExcluidos.keySet());
                ConnectionSql.commit();
            }
        }
    }

    private ValidacaoEstornoLancamentoFinanceiroWrapper validar(ContaCorrenteLancamento lancamento) throws UnicoMensagemUsuarioException {
        if (lancamento != null) {
            EventoFinanceiro eventoFinanceiro;
            if (!Util.longNullOuZero((Long)lancamento.getEvento()) && (eventoFinanceiro = EventoFinanceiroRN.getInstance().buscarPorId(lancamento.getEvento())) != null) {
                Operacao pdv;
                String mensagem = null;
                if (eventoFinanceiro.getTipoOrigem() == 2) {
                    NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalCommonRN.getInstance().buscarPorId(eventoFinanceiro.getIdOrigem());
                    if (notaFiscal != null) {
                        mensagem = "Lan\u00e7amento referente \u00e0 nota fiscal " + notaFiscal.getNumeroNotaFiscal() + "! Imposs\u00edvel continuar.";
                    }
                } else if (eventoFinanceiro.getTipoOrigem() == 1 && (pdv = (Operacao)OperacaoCommonRN.getInstance().buscarPorId(eventoFinanceiro.getIdOrigem())) != null) {
                    mensagem = "Lan\u00e7amento referente ao cupom fiscal " + (!Util.stringNullOrEmpty((String)pdv.getNumeroNfce()) ? pdv.getNumeroNfce() : pdv.getCoo() + "/" + pdv.getPdv()) + "! Imposs\u00edvel continuar.";
                }
                if (!Util.stringNullOrEmpty(mensagem)) {
                    throw new UnicoMensagemUsuarioException("FIN295", mensagem);
                }
                if (EventoFinanceiroRN.getInstance().podeEstornarBaixa(eventoFinanceiro)) {
                    if (eventoFinanceiro.getOrigem() == 1 && eventoFinanceiro.getTipoevento().equals(TipoEventoFinanceiro.BAIXA.getId())) {
                        throw new UnicoMensagemUsuarioException("FIN185", "Estorno n\u00e3o permitido. Para estornar esse documento acessar Cadastro>Outros>Paf-Ecf>Cancelamento de opera\u00e7\u00e3o");
                    }
                    return new ValidacaoEstornoLancamentoFinanceiroWrapper(NegociacaoFinanceiroRN.getInstance().buscarNegociacaoPorEventoFinanceiro(lancamento.getEvento()) != null);
                }
                throw new UnicoMensagemUsuarioException("FIN188", "Existem documentos com lan\u00e7amentos que impedem o estorno");
            }
            return new ValidacaoEstornoLancamentoFinanceiroWrapper();
        }
        throw new UnicoMensagemUsuarioException("FIN309", "Documento n\u00e3o encontrado");
    }

    protected Map<String, BigDecimal> getMapValoresTotalizados(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) {
        Map mapValores = super.getMapValoresTotalizados(colunas, dados, filters, parameters);
        if (mapValores != null) {
            BigDecimal entrada = Util.seBigDecimalNullOrZeroEntao((BigDecimal)((BigDecimal)mapValores.get("entrada")), (BigDecimal)BigDecimal.ZERO);
            BigDecimal saida = Util.seBigDecimalNullOrZeroEntao((BigDecimal)((BigDecimal)mapValores.get("saida")), (BigDecimal)BigDecimal.ZERO);
            BigDecimal saldoAnterior = BigDecimal.ZERO;
            if (!ListMapUtil.listNullOrEmpty(filters)) {
                Long idContaCorrente = filters.stream().filter(filterField -> filterField.getField().equals("idcontacorrente")).findFirst().map(filterField -> Long.parseLong(filterField.getValue1())).orElse(-1L);
                LocalDate dataInicial = filters.stream().filter(filterField -> filterField.getField().equals("dataFiltro") && Operator.OPERADOR_MAIOR_IGUAL.getId().equals(filterField.getFilter())).findFirst().map(filterField -> DataHoraFactory.string2LocalDate((String)filterField.getValue1(), (String)"dd/MM/yyyy")).orElse(null);
                saldoAnterior = ContaCorrenteRN.getInstance().getSaldoNaData(idContaCorrente, dataInicial != null ? dataInicial.minusDays(1L) : null);
            }
            BigDecimal saldo = saldoAnterior.add(entrada.subtract(saida)).setScale(2, RoundingMode.HALF_EVEN);
            mapValores.put("valorfinal", saldo);
        }
        return mapValores;
    }

    @RequestMapping(value={"/filtrar-conta-online"})
    @DBAutoCommit
    public RetornoConsultaConciliacaoOnline carregarDados(@RequestBody FiltroBancoOnlineWrapper filtros) throws UnicoMensagemUsuarioException {
        RetornoConsultaConciliacaoOnline retorno = new RetornoConsultaConciliacaoOnline();
        ContaCorrente contaCorrente = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(filtros.getIdContaCorrente());
        if (contaCorrente != null) {
            LocalDate dataInicial = filtros.getInicio();
            LocalDate dataFinal = filtros.getFim();
            if (dataInicial == null) {
                throw new UnicoMensagemUsuarioException("WCBE264", "Data inicial n\u00e3o informada! Verifique.");
            }
            if (dataFinal == null) {
                throw new UnicoMensagemUsuarioException("WCBE265", "Data final n\u00e3o informada! Verifique.");
            }
            if (dataInicial.isAfter(dataFinal)) {
                throw new UnicoMensagemUsuarioException("WCBE266", "Data inicial n\u00e3o pode ser maior que a data final! Verifique.");
            }
            Sessao sessao = SessaoUtil.getSessao();
            retorno.setListaMovimento(ContaCorrenteLancamentoRN.getInstance().buscarExtratoParaConciliacaoOnLine(sessao, contaCorrente, dataInicial, dataFinal));
            retorno.setSaldo(ContaCorrenteRN.getInstance().buscarSaldoContaCorrenteOnLine(sessao, contaCorrente));
        }
        return retorno;
    }
}

