/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.gnre;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.documentosfiscais.gnre.enums.StatusGnre;
import br.intelidata.commons.core.documentosfiscais.gnre.enums.TipoValorExigido;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Estado;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.gnre.Gnre;
import br.intelidata.commons.domain.pojo.gnre.GnreDetalhamentoReceita;
import br.intelidata.commons.domain.pojo.gnre.GnrePeriodoApuracao;
import br.intelidata.commons.domain.pojo.gnre.GnreProduto;
import br.intelidata.commons.domain.pojo.gnre.GnreReceita;
import br.intelidata.commons.domain.pojo.gnre.GnreTipoDocumentoOrigem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.EstadoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.gnre.GnreManager;
import br.intelidata.commons.modulo.gnre.regranegocio.GnreDetalhamentoReceitaRN;
import br.intelidata.commons.modulo.gnre.regranegocio.GnrePeriodoApuracaoRN;
import br.intelidata.commons.modulo.gnre.regranegocio.GnreProdutoRN;
import br.intelidata.commons.modulo.gnre.regranegocio.GnreRN;
import br.intelidata.commons.modulo.gnre.regranegocio.GnreReceitaRN;
import br.intelidata.commons.modulo.gnre.regranegocio.GnreTipoDocumentoOrigemRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.gnre.ExclusaoGNREWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gnre"})
@SubMenuMapping(MENU="SubMenuFiscalGeral", NOME="GNRE On-line", ICONE="icon-nota-fiscal-saida", ROTA="/gnre/gnre", PROGRAMA=536)
public class GnreCrudController
extends CrudController<Gnre, GnreRN> {
    @Autowired
    public GnreCrudController() {
        super((AbstractRegraNegocio)GnreRN.getInstance(), Gnre::new, true, false);
    }

    @RequestMapping(value={"/carregar-config-estados"}, method={RequestMethod.POST})
    @DBTransaction
    public void carregarConfigEstados() throws UnicoMensagemUsuarioException {
        try {
            GnreManager gnreManager = new GnreManager(SessaoUtil.getSessao());
            this.verificarValidadeCertificado(gnreManager);
            gnreManager.carregarConfigEstados((mensagem, processo) -> this.notificationService.notifyGnreNow(mensagem));
        }
        catch (UnicoMensagemUsuarioException ex) {
            this.notificationService.notifyGnreNow(ex.getMensagemSemCodigo());
        }
    }

    @RequestMapping(value={"/transmitir"}, method={RequestMethod.POST})
    @DBTransaction
    public void transmitir(@RequestBody List<Long> ids) throws UnicoMensagemUsuarioException {
        try {
            GnreManager gnreManager = new GnreManager(SessaoUtil.getSessao());
            this.verificarValidadeCertificado(gnreManager);
            gnreManager.processarGnres(ids, (mensagem, processo) -> this.notificationService.notifyGnreNow(mensagem));
        }
        catch (UnicoMensagemUsuarioException ex) {
            this.notificationService.notifyGnreNow(ex.getMensagemSemCodigo());
        }
    }

    @RequestMapping(value={"/imprimir-guias"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> gerarDamdfe(@RequestBody List<Long> ids) throws UnicoMensagemUsuarioException {
        if (!Util.listNullOrEmpty(ids)) {
            GnreManager gnreManager = new GnreManager(Contexto.getInstance().getSessao());
            byte[] arrByte = gnreManager.imprimirGnre(ids, Contexto.getInstance().getSessao());
            return this.responseEntityService.createPDFResponse(arrByte, "boleto_gnre");
        }
        throw new UnicoMensagemUsuarioException("WGNRE30", "Selecione uma ou mais GNREs para a impress\u00e3o");
    }

    @RequestMapping(value={"/buscar-receita"})
    @DBAutoCommit
    public GnreReceita buscarReceita(@RequestParam Long idReceita) {
        return (GnreReceita)GnreReceitaRN.getInstance().buscarPorId(idReceita);
    }

    void verificarValidadeCertificado(GnreManager mdfeManagerWeb) throws UnicoMensagemUsuarioException {
        String mensagemCertificado = mdfeManagerWeb.getTransmissorGnre().getValidadeCertificado();
        if (!StringUtil.stringNullOrEmpty((String)mensagemCertificado)) {
            this.notificationService.simpleNotifyUserTenantNow(ContextoHolder.getTenant(), SessaoUtil.getSessao().getIdUsuario(), TipoNotificacaoSimples.WARNING, mensagemCertificado);
        }
    }

    @RequestMapping(value={"/combo-receita"})
    @DBAutoCommit
    public List<GnreReceita> getListaReceita(@RequestParam Long idEstado) {
        return GnreReceitaRN.getInstance().buscarListaPorIdEstadoWeb(idEstado);
    }

    @RequestMapping(value={"/combo-detalhamento-receita"})
    @DBAutoCommit
    public List<GnreDetalhamentoReceita> getListaDetalhamentoReceita(@RequestParam Long idReceita) {
        return GnreDetalhamentoReceitaRN.getInstance().buscarListaPorIdReceita(idReceita);
    }

    @RequestMapping(value={"/combo-produto"})
    @DBAutoCommit
    public List<GnreProduto> getListaProduto(@RequestParam Long idReceita) {
        return GnreProdutoRN.getInstance().buscarListaPorIdReceita(idReceita);
    }

    @RequestMapping(value={"/combo-periodo-apuracao"})
    @DBAutoCommit
    public List<GnrePeriodoApuracao> getListaPeriodoApuracao(@RequestParam Long idReceita) {
        return GnrePeriodoApuracaoRN.getInstance().buscarListaPorIdReceita(idReceita);
    }

    @RequestMapping(value={"/combo-tipo-documento-origem"})
    @DBAutoCommit
    public List<GnreTipoDocumentoOrigem> getListaTipoDocOrigem(@RequestParam Long idReceita) {
        return GnreTipoDocumentoOrigemRN.getInstance().buscarListaPorIdReceita(idReceita);
    }

    protected String getCacheId() {
        return "gnre".concat("_ID_FILIAL_").concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }

    @RequestMapping(value={"/validar-exclusao"})
    @DBAutoCommit
    public ExclusaoGNREWrapper validarExclusao(@RequestParam Long id) {
        Gnre gnre = GnreRN.getInstance().buscarPorId(id);
        ExclusaoGNREWrapper exclusaoGNREWrapper = new ExclusaoGNREWrapper();
        if (gnre != null) {
            exclusaoGNREWrapper.setPermiteCancelar(gnre.getStatus().isPermiteCancelar());
            exclusaoGNREWrapper.setPermiteExcluir(gnre.getStatus().isPermiteExcluir());
        }
        return exclusaoGNREWrapper;
    }

    @RequestMapping(value={"/cancelar"})
    @DBAutoCommit
    public void cancelar(@RequestParam Long id, @RequestParam String justificativa) throws UnicoMensagemUsuarioException {
        Gnre gnre = GnreRN.getInstance().buscarPorId(id);
        GnreRN.getInstance().cancelarGnre(SessaoUtil.getSessao(), gnre, justificativa);
    }

    protected GridBuilder<GnreRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("id", "identificador", "Identificador", 200, true, new String[0]));
        colunas.add(new ColunaSQL("nome", "estado", "Estado", 200, true, new String[]{"fk_gnre_estado"}));
        colunas.add(new ColunaSQL("data", "Data", 0, true));
        colunas.add(new ColunaSQL("receita", "Receita", 0, true));
        colunas.add(new ColunaSQL("status", "Status", 200, true));
        colunas.add(new ColunaSQL("descricaosituacao", "Mensagem de processamento", 0, true));
        colunas.add(new ColunaSQL("recibotransmissao", "Recibo", 200, true));
        colunas.add(new ColunaSQL("protocolo", "Protocolo", 250, true));
        colunas.add(new ColunaSQL("data", "dataFiltro", "Data", 250, false, new String[0]));
        colunas.add(new ColunaSQL("status", "statusGrid", "Status", 200, false, new String[0]));
        GridBuilder grid = new GridBuilder(GnreRN.getInstance().getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("id"));
        return grid;
    }

    protected void beforeCreate(Gnre gnre, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        gnre.setIdFilial(SessaoUtil.getSessao().getFilial().getId());
        if (gnre.getStatus() == null) {
            gnre.setStatus(StatusGnre.NORMAL);
        }
        if (gnre.getData() == null) {
            gnre.setData(DataHoraFactory.getData());
        }
    }

    protected void beforeSave(Gnre gnre, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        GnreReceita gnreReceita = (GnreReceita)GnreReceitaRN.getInstance().buscarPorId(gnre.getIdReceita());
        if (gnreReceita != null && gnreReceita.getValorExigido() != null && !TipoValorExigido.NENHUM.equals((Object)gnreReceita.getValorExigido()) && !gnreReceita.getValorExigido().in(new AbstractEnum[]{TipoValorExigido.VALOR_PRINCIPAL_OU_TOTAL, TipoValorExigido.AMBOS_OPCIONAL})) {
            gnre.setTipoValor(gnreReceita.getValorExigido());
        }
        if (!NumberUtil.longNullOuZero((Long)gnre.getIdContribuinteDestinatario())) {
            Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(gnre.getIdContribuinteDestinatario());
            Estado estado = (Estado)EstadoRN.getInstance().buscarPorId(gnre.getIdEstado());
            if (!estado.getId().equals(entidade.getEndereco().getIdEstado())) {
                throw new UnicoMensagemUsuarioException("WGNRE27", "Estado do contribuinte destinat\u00e1rio deve ser o mesmo do estado favorecido");
            }
        }
    }
}

