/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.grade;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.Grade;
import br.intelidata.commons.domain.pojo.GradeValor;
import br.intelidata.commons.domain.pojo.enuns.TipoVariacao;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.produto.regranegocio.GradeRN;
import br.intelidata.commons.modulo.produto.regranegocio.GradeValorRN;
import br.intelidata.commons.modulo.produto.regranegocio.VariacaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/grades"})
@SubMenuMapping(MENU="SubMenuCadastroAuxiliarProdutos", NOME="Grades", ROTA="/estoques/grades", PROGRAMA=1323)
public class GradeCrudController
extends CrudController<Grade, GradeRN> {
    @Autowired
    public GradeCrudController() {
        super((AbstractRegraNegocio)GradeRN.getInstance(), Grade::new);
        this.setItemSupplier(GradeValor::new);
    }

    @RequestMapping(value={"/buscar-dados-combo"})
    @DBAutoCommit
    public List<Grade> buscarGradesCombo(@RequestParam(required=false) String query, @RequestParam(required=false, defaultValue="6") Integer limit) {
        return GradeRN.getInstance().getComboWeb(query, limit.intValue());
    }

    @RequestMapping(value={"/buscar-valores"})
    @DBAutoCommit
    public List<GradeValor> buscarValores(@RequestParam Long idGrade) {
        List valores = GradeValorRN.getInstance().buscaPorIdGrade(idGrade);
        if (!ListMapUtil.listNullOrEmpty((List)valores)) {
            valores.sort(Comparator.comparing(GradeValor::getValor));
        }
        return valores;
    }

    @RequestMapping(value={"/buscar-variacao"})
    @DBAutoCommit
    public List<GradeValor> buscarVariacao(@RequestParam Long idGrade, @RequestParam(required=false) Long idProduto, @RequestParam(required=false) TipoVariacao tipoVariacao) {
        return GradeValorRN.getInstance().carregaDados(idGrade, idProduto, tipoVariacao);
    }

    @RequestMapping(value={"/permite-alterar-excluir"})
    @DBAutoCommit
    public boolean isPermiteExcluirValor(@RequestParam Long idGradeValor) {
        return !VariacaoRN.getInstance().isUtilizaGradePadrao(idGradeValor);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @DBTransaction
    public void delete(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        for (GradeValor gradeValor : this.buscarValores(id)) {
            if (this.isPermiteExcluirValor(gradeValor.getId())) continue;
            throw new UnicoMensagemUsuarioException("WPRD295", "N\u00e3o \u00e9 poss\u00edvel excluir uma grade j\u00e1 utilizada em produtos");
        }
        super.delete(id);
    }

    protected GridBuilder<GradeRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 0, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        return new GridBuilder(GradeRN.getInstance().getTabela(), colunas);
    }

    protected void beforeRead(Grade grade, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        grade.setValores(GradeValorRN.getInstance().buscaPorIdGrade(grade.getId()));
        for (GradeValor gradeValor : grade.getValores()) {
            gradeValor.setPermiteExcluir(this.isPermiteExcluirValor(gradeValor.getId()));
        }
    }

    protected void beforeSave(Grade grade, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (ListMapUtil.listNullOrEmpty((List)grade.getValores())) {
            throw new UnicoMensagemUsuarioException("WWW94", "Por favor informe os valores da grade.");
        }
        if (!NumberUtil.longNullOuZero((Long)grade.getId())) {
            List valoresOriginais = this.buscarValores(grade.getId());
            List idsOriginais = valoresOriginais.stream().map(GradeValor::getId).collect(Collectors.toList());
            List variacoesExcluidasAlteradas = grade.getValores().stream().filter(gradeValor -> this.isValorAlteradoExcluido(valoresOriginais, idsOriginais, gradeValor)).collect(Collectors.toList());
            for (GradeValor gradeValor2 : variacoesExcluidasAlteradas) {
                if (this.isPermiteExcluirValor(gradeValor2.getId())) continue;
                throw new UnicoMensagemUsuarioException("WPRD296", "N\u00e3o \u00e9 poss\u00edvel alterar uma grade j\u00e1 utilizada em produtos");
            }
        }
    }

    protected void afterSave(Grade grade, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.notificationService.notifyTenantNow(NotificationType.CACHE_REFRESH, "variacoes");
    }

    protected String getCacheId() {
        return "grades";
    }

    private boolean isValorAlteradoExcluido(List<GradeValor> valoresOriginais, List<Long> idsOriginais, GradeValor gradeValor) {
        return !NumberUtil.longNullOuZero((Long)gradeValor.getId()) && (!idsOriginais.contains(gradeValor.getId()) || !valoresOriginais.stream().filter(gradeValorOrignal -> gradeValor.getId().equals(gradeValorOrignal.getId())).findFirst().get().getValor().equals(gradeValor.getValor()));
    }
}

