/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.hierarquia.grupo;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.HierarquiaGrupoProduto;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.modulo.produto.regranegocio.HierarquiaGrupoProdutoRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.crud.hierarquia.grupo.JobAtualizacaoGrupo;
import br.intelidata.uniplusweb.web.rest.app.wrapper.AtualizacaoGrupoWrapper;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/grupos-produto"})
public class GrupoProdutoJobController
implements ICreateTask {
    private final TaskManager taskManager;

    public GrupoProdutoJobController(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public TipoJob getTipoJob() {
        return TipoJob.ATUALIZAR_DADOS_GRUPO;
    }

    public Class<? extends AbstractJob> job() {
        return JobAtualizacaoGrupo.class;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    @RequestMapping(value={"/atualizar-dados-produto"}, method={RequestMethod.POST})
    @DBTransaction
    public void atualizarProdutosGrupo(@RequestBody AtualizacaoGrupoWrapper atualizacao) throws UnicoMensagemUsuarioException {
        HierarquiaGrupoProduto grupoProduto = (HierarquiaGrupoProduto)HierarquiaGrupoProdutoRN.getInstance().buscarPorId(atualizacao.getIdHierarquia());
        this.createTask((Object)atualizacao, "Atualiza\u00e7\u00e3o dos produtos do grupo " + grupoProduto.getNome());
    }
}

