/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.hierarquia.planocontas;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.ItemComboBox;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.usql.ColunaCustomizavelGrid;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Hierarquia;
import br.intelidata.commons.domain.pojo.HierarquiaPlanoContas;
import br.intelidata.commons.domain.pojo.PlanoContasContaContabil;
import br.intelidata.commons.domain.pojo.enuns.TipoPlanoContas;
import br.intelidata.commons.domain.regranegocio.HierarquiaRN;
import br.intelidata.commons.domain.regranegocio.PlanoContasContaContabilCommonRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.HierarquiaPlanoContasRN;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelCodigoExtensoContaContabilPlanoContas;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelCodigoReduzidoContaContabilPlanoContas;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelDescricaoContaContabilPlanoContas;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.crud.hierarquia.HierarquiaCrudController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/planos-contas"})
@SubMenuMapping(MENU="SubMenuFinanceiroAuxiliar", NOME="Plano de contas", ROTA="/financeiros/planos-contas", PROGRAMA=14)
public class PlanoContasCrudController
extends HierarquiaCrudController<HierarquiaPlanoContas, HierarquiaPlanoContasRN> {
    @Autowired
    public PlanoContasCrudController() {
        super((HierarquiaRN)HierarquiaPlanoContasRN.getInstance(), HierarquiaPlanoContas::new);
    }

    @RequestMapping(value={"/filtrar-plano-conta-sem-filhos-propriedades"})
    @DBAutoCommit
    public List<ItemComboBox> filtrarPlanoContaSemFilhosPropriedade(@RequestParam(required=false) String query) {
        if (!StringUtil.stringNullOrEmpty((String)query)) {
            ArrayList<Condicao> condicoes = new ArrayList<Condicao>();
            condicoes.add(new Condicao("nome_pesquisa", Operador.CONTEM, query));
            List hierarquiaPlanoContas = HierarquiaPlanoContasRN.getInstance().buscarTodosCombo(true, condicoes);
            return hierarquiaPlanoContas.stream().map(h -> new ItemComboBox((Object)h.getId(), h.getNome())).collect(Collectors.toList());
        }
        return this.filtrarPlanoContaSemFilhos().stream().map(h -> new ItemComboBox((Object)h.getId(), h.getNome())).collect(Collectors.toList());
    }

    @RequestMapping(value={"/filtrar-plano-conta-sem-filhos"})
    @DBAutoCommit
    public List<HierarquiaPlanoContas> filtrarPlanoContaSemFilhos() {
        ArrayList<Condicao> condicoes = new ArrayList<Condicao>();
        condicoes.add(new Condicao("tipoconta", Operador.DIFERENTE, TipoPlanoContas.NAO_SE_APLICA.getId().intValue()));
        condicoes.add(new Condicao(OperadorLogico.OU));
        condicoes.add(new Condicao("tipoconta", Operador.IS_NULL));
        return HierarquiaPlanoContasRN.getInstance().buscarListaHierarquiaSemFilhos(true, condicoes);
    }

    @RequestMapping(value={"/validar-inativo"})
    @DBAutoCommit
    public boolean validarPlanoContas(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        HierarquiaPlanoContas hierarquia = (HierarquiaPlanoContas)HierarquiaPlanoContasRN.getInstance().buscarPorId(id);
        if (hierarquia != null && hierarquia.isInativo()) {
            throw new UnicoMensagemUsuarioException("COM236556", "O plano de contas n\u00e3o pode ser usado pois est\u00e1 inativo.");
        }
        return true;
    }

    protected void beforeRead(HierarquiaPlanoContas hierarquiaPlanoContas, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (!Util.longNullOuZero((Long)hierarquiaPlanoContas.getId()) && (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.INTEGRACAO_COM_CONTABILIDADE) || FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.SPED_CONTRIBUICOES_CONTA_CONTABIL) || FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.SPED_FISCAL_CONTA_CONTABIL))) {
            PlanoContasContaContabil planoContasContaContabil = PlanoContasContaContabilCommonRN.getInstance().buscarPorPlanoContas(hierarquiaPlanoContas.getId(), SessaoUtil.getSessao().getFilial().getIdEmpresa());
            hierarquiaPlanoContas.setIdContaContabilIntegracao(planoContasContaContabil != null ? planoContasContaContabil.getIdContaContabil() : null);
        }
    }

    protected void afterSave(HierarquiaPlanoContas hierarquiaPlanoContas, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.INTEGRACAO_COM_CONTABILIDADE) || FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.SPED_CONTRIBUICOES_CONTA_CONTABIL) || FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.SPED_FISCAL_CONTA_CONTABIL)) {
            PlanoContasContaContabilCommonRN.getInstance().gravarContaContabilPlanoContas(sessao, hierarquiaPlanoContas.getId(), sessao.getFilial().getIdEmpresa(), hierarquiaPlanoContas.getIdContaContabilIntegracao());
        }
        this.setDadosFilhos(sessao, (Hierarquia)hierarquiaPlanoContas, (Hierarquia)hierarquiaPlanoContas);
    }

    protected GridBuilder<HierarquiaPlanoContasRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 0, false));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        colunas.add(new ColunaSQL("tipomovimento", "tipoMovimento", "Tipo", 0, true, new String[0]));
        colunas.add(new ColunaSQL("inativo", "Inativo", 200, true, EnumSimNao.class));
        this.addColunaNivel(colunas);
        Sessao sessao = SessaoUtil.getSessao();
        GridBuilder grid = new GridBuilder(HierarquiaPlanoContasRN.getInstance().getTabela(), colunas, Collections.singletonList(new Ordem("nome")));
        grid.addReferenciaDefault(new Referencia("inativo", "inativoView"));
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.INTEGRACAO_COM_CONTABILIDADE) || FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.SPED_CONTRIBUICOES_CONTA_CONTABIL) || FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.SPED_FISCAL_CONTA_CONTABIL)) {
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelCodigoReduzidoContaContabilPlanoContas(sessao));
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelCodigoExtensoContaContabilPlanoContas(sessao));
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelDescricaoContaContabilPlanoContas(sessao));
        }
        grid.setOrdemDefault(new Ordem("codigo"));
        return grid;
    }

    public void setDadosFilhos(Sessao sessao, Hierarquia hierarquia, Hierarquia hierarquiaPai) throws UnicoMensagemUsuarioException {
        List filhos = HierarquiaPlanoContasRN.getInstance().buscarHierarquiasFilhas(hierarquia.getId());
        for (HierarquiaPlanoContas hierarquiaFilho : filhos) {
            if (hierarquia.getId().equals(hierarquiaFilho.getId())) continue;
            hierarquiaFilho.setInativo(this.getFilhoInativo((HierarquiaPlanoContas)hierarquiaPai, hierarquiaFilho));
            hierarquiaFilho.setCentroCustoObrigatorio(((HierarquiaPlanoContas)hierarquiaPai).isCentroCustoObrigatorio());
            ((HierarquiaPlanoContasRN)this.rn).alterar((AbstractPojo)hierarquiaFilho, sessao);
            List filhosDoFilho = HierarquiaPlanoContasRN.getInstance().buscarHierarquiasFilhas(hierarquiaFilho.getId());
            if (Util.listNullOrEmpty((List)filhosDoFilho)) continue;
            this.setDadosFilhos(sessao, (Hierarquia)hierarquiaFilho, hierarquia);
        }
    }

    private boolean getFilhoInativo(HierarquiaPlanoContas hierarquiaPai, HierarquiaPlanoContas hierarquiaFilha) {
        return hierarquiaPai.isAlterarStatusFilhos() ? hierarquiaPai.isInativo() : hierarquiaFilha.isInativo();
    }

    protected String getCacheId() {
        return "planos-contas";
    }

    public List<Coluna> getColunasCustomizaveis() {
        return ((HierarquiaPlanoContasRN)this.rn).getColunaGridCustomizavelHierarquiaPlanoContas();
    }
}

