/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.meiotransporte;

import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.enuns.conhecimento.TipoVeiculo;
import br.intelidata.commons.domain.pojo.vendas.MeioTransporte;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.expedicao.regranegocio.MeioTransporteRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.SerieRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/meios-transporte"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliar", NOME="Meios de transporte", ROTA="/cadastros/meios-transporte", PROGRAMA=137)
public class MeiosTransporteCrudController
extends CrudController<MeioTransporte, MeioTransporteRN> {
    public MeiosTransporteCrudController() {
        super((AbstractRegraNegocio)MeioTransporteRN.getInstance(), MeioTransporte::new);
    }

    protected GridBuilder<SerieRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 100, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("tipotransporte", "Tipo", 0, true));
        return new GridBuilder(MeioTransporteRN.getInstance().getTabela(), colunas);
    }

    @RequestMapping(value={"/combo-por-tipo-veiculo"})
    @DBAutoCommit
    public List<MeioTransporte> getCombo(@RequestParam(required=false) TipoVeiculo tipoVeiculo) {
        return MeioTransporteRN.getInstance().getComboWeb(tipoVeiculo);
    }

    protected String getCacheId() {
        return "meios-transporte";
    }
}

