/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.mensagensusuarios;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.MensagemUsuario;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.r2d2rest.regranegocio.MensagemUsuarioRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/mensagens-usuario"})
@SubMenuMapping(MENU="SubMenuCadastroAuxiliarUsuario", NOME="Mensagens para usu\u00e1rios", ROTA="/cadastros/mensagens-usuario", PROGRAMA=1357)
public class MensagemUsuarioCrudController
extends CrudController<MensagemUsuario, MensagemUsuarioRN> {
    public MensagemUsuarioCrudController() {
        super((AbstractRegraNegocio)MensagemUsuarioRN.getInstance(), MensagemUsuario::new);
    }

    @RequestMapping(value={"/enviar"})
    @DBAutoCommit
    public void enviarMensagens() throws UnicoMensagemUsuarioException {
        ((MensagemUsuarioRN)this.rn).enviarMensagens();
    }

    protected String getCacheId() {
        return "mensagens-usuario";
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("datacriacao", "Data", 200, true));
        colunas.add(new ColunaSQL("titulo", "Titulo", 0, true));
        colunas.add(new ColunaSQL("mensagem", "Mensagem", 0, true));
        GridBuilder grid = new GridBuilder(((MensagemUsuarioRN)this.rn).getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("datacriacao"));
        return grid;
    }

    protected void beforeSave(MensagemUsuario mensagemUsuario, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (ListMapUtil.listNullOrEmpty((List)mensagemUsuario.getItens())) {
            throw new UnicoMensagemUsuarioException("WR2D2R187", "Nenhum usu\u00e1rio selecionado!");
        }
    }
}

