/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.metasvendas;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.vendas.MetaVendas;
import br.intelidata.commons.domain.pojo.vendas.MetaVendasItem;
import br.intelidata.commons.domain.pojo.vendas.MetaVendasItemFaixa;
import br.intelidata.commons.domain.pojo.vendas.TipoVinculoMetaVendaItem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.vendas.regranegocio.MetaVendasRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/metas-vendas"})
@SubMenuMapping(MENU="SubMenuVendasAuxiliarParametrosVenda", NOME="Metas de venda", ROTA="/vendas/metas-vendas", PROGRAMA=1366)
public class MetaVendaCrudController
extends CrudController<MetaVendas, MetaVendasRN> {
    public MetaVendaCrudController() {
        super((AbstractRegraNegocio)MetaVendasRN.getInstance(), MetaVendas::new);
    }

    protected String getCacheId() {
        return "metas-vendas";
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 200, true));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        colunas.add(new ColunaSQL("anoexercicio", "Ano", 200, true));
        return new GridBuilder(((MetaVendasRN)this.rn).getTabela(), colunas);
    }

    protected void beforeSave(MetaVendas metaVendas, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (!ListMapUtil.listNullOrEmpty((List)metaVendas.getCadastroMetasVendedorGeralItemFaixa())) {
            for (MetaVendasItemFaixa itemFaixa : metaVendas.getCadastroMetasVendedorGeralItemFaixa()) {
                if (itemFaixa.getPercAtingInicial().compareTo(itemFaixa.getPercAtingFinal()) < 0) continue;
                throw new UnicoMensagemUsuarioException("WVND68", "% Atingimento Final deve ser maior que % Atingimento Inicial.");
            }
            if (ListMapUtil.listNullOrEmpty((List)metaVendas.getCadastroMetasGeralVendedor())) {
                MetaVendasItem metaItem = new MetaVendasItem();
                metaItem.setIdMetaVendas(metaVendas.getId());
                metaItem.setTipoVinculoMetaVendaItem(TipoVinculoMetaVendaItem.V);
                metaVendas.setCadastroMetasGeralVendedor(Collections.singletonList(metaItem));
            }
        }
    }

    protected void beforeRead(MetaVendas metaVendas, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (modo == 7) {
            metaVendas.setId(Long.valueOf(0L));
            metaVendas.setCodigo(MetaVendasRN.getInstance().getCodigoUnico(SessaoUtil.getSessao()));
        }
    }
}

