/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.motivoajusteestoque;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.MotivoAjusteEstoque;
import br.intelidata.commons.domain.pojo.enuns.OperacaoMotivoAjusteEstoque;
import br.intelidata.commons.domain.pojo.enuns.TipoAjusteEstoque;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.estoque.regranegocio.MotivoAjusteEstoqueRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/motivos-ajuste-estoque"})
@SubMenuMapping(MENU="SubMenuEstoqueAuxiliar", NOME="Motivos de ajuste de estoque", ROTA="/estoques/motivos-ajuste-estoque", PROGRAMA=23)
public class MotivoAjusteEstoqueCrudController
extends CrudController<MotivoAjusteEstoque, MotivoAjusteEstoqueRN> {
    public MotivoAjusteEstoqueCrudController() {
        super((AbstractRegraNegocio)MotivoAjusteEstoqueRN.getInstance(), MotivoAjusteEstoque::new);
    }

    @RequestMapping(value={"/filtrar-por-operacao"})
    @DBAutoCommit
    public List<MotivoAjusteEstoque> filtrarPorOperacao(@RequestParam TipoAjusteEstoque tipoAjuste) {
        OperacaoMotivoAjusteEstoque operacao = null;
        if (tipoAjuste == TipoAjusteEstoque.ENTRADA) {
            operacao = OperacaoMotivoAjusteEstoque.ENTRADA;
        } else if (tipoAjuste == TipoAjusteEstoque.SAIDA) {
            operacao = OperacaoMotivoAjusteEstoque.SAIDA;
        } else if (tipoAjuste == TipoAjusteEstoque.TRANSFERENCIA_LOCAL_ESTOQUE) {
            operacao = OperacaoMotivoAjusteEstoque.TRANSFERENCIA;
        }
        return MotivoAjusteEstoqueRN.getInstance().getDadosAsyncSelectWeb(SessaoUtil.getSessao(), operacao);
    }

    protected void beforeSave(MotivoAjusteEstoque motivoAjusteEstoque, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (motivoAjusteEstoque.getCodigo() <= -1) {
            throw new UnicoMensagemUsuarioException("WWW80", "N\u00e3o \u00e9 poss\u00edvel manipular motivos de ajustes propriet\u00e1rios do sistema.");
        }
    }

    protected GridBuilder<MotivoAjusteEstoqueRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 120, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        GridBuilder grid = new GridBuilder(MotivoAjusteEstoqueRN.getInstance().getTabela(), colunas);
        grid.addOrdemDefault(new Ordem("codigo"));
        return grid;
    }

    protected String getCacheId() {
        return "motivos-ajuste-estoque";
    }
}

