/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.notafiscal;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.core.util.TipoNotificacao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.StatusNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoEmailEntidade;
import br.intelidata.commons.domain.pojo.enuns.TipoEmissaoNotaFiscal;
import br.intelidata.commons.domain.pojo.generico.LocalUsoTextoGenerico;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.notafiscal.nfe.GeradorXMLNFE;
import br.intelidata.commons.modulo.notafiscal.nfe.NfeManagerWeb;
import br.intelidata.commons.modulo.notafiscal.nfe.NotificacaoNotaFiscalCliente;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.service.TrabalhoImpressaoNFSeComponent;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.ArquivoFiscalWeb;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CompartilhamentoController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.NotaFiscalCompartilhamento;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.NotaFiscalCompartilhamentoComponent;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.wrapper.DadosBoletoCompartilhamento;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/jobs-nota-fiscal"})
public class NotaFiscalTaskJobController
extends CompartilhamentoController<NotaFiscalCompartilhamento> {
    private final ResponseEntityService responseEntityService;
    private final TrabalhoImpressaoNFSeComponent trabalhoImpressao;
    private final NotaFiscalCompartilhamentoComponent notaFiscalCompartilhamentoComponent;
    private final ArquivoFiscalWeb arquivoFiscalWeb;

    @Autowired
    public NotaFiscalTaskJobController(ResponseEntityService responseEntityService, TaskManager taskManager, NotaFiscalCompartilhamentoComponent notaFiscalCompartilhamentoComponent, ArquivoFiscalWeb arquivoFiscal, TrabalhoImpressaoNFSeComponent trabalhoImpressao) {
        super(taskManager);
        this.responseEntityService = responseEntityService;
        this.notaFiscalCompartilhamentoComponent = notaFiscalCompartilhamentoComponent;
        this.arquivoFiscalWeb = arquivoFiscal;
        this.trabalhoImpressao = trabalhoImpressao;
    }

    @RequestMapping(value={"/gerar-danfe"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> gerarDanfe(@RequestBody Long idNotaFiscal) throws UnicoMensagemUsuarioException {
        NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(idNotaFiscal);
        if (notaFiscal != null) {
            byte[] arquivo;
            Sessao sessao = SessaoUtil.getSessao();
            String nome = "DANFE-".concat(notaFiscal.getChaveNfe());
            if (NotaFiscalRN.getInstance().isNfse(notaFiscal)) {
                return this.trabalhoImpressao.imprimirDanfe(notaFiscal, this.arquivoFiscalWeb);
            }
            if (notaFiscal.getStatus().equals((Object)StatusNotaFiscal.NFE_AUTORIZADA) || notaFiscal.getStatus().equals((Object)StatusNotaFiscal.CANCELADA)) {
                arquivo = new NfeManagerWeb(sessao, null).gerarDanfeWeb(notaFiscal.getChaveNfe());
            } else if (notaFiscal.getStatus().equals((Object)StatusNotaFiscal.NFE_EMITIDA_CONTINGENCIA) || notaFiscal.getStatus().equals((Object)StatusNotaFiscal.NFE_EMITIDA_EPEC)) {
                arquivo = new NfeManagerWeb(sessao, null).gerarDanfeContingencia(notaFiscal);
            } else if (notaFiscal.getArquivoXmlNotaOriginal() != null) {
                arquivo = new NfeManagerWeb(SessaoUtil.getSessao(), null).gerarDanfeNotaEntradaWeb(notaFiscal);
            } else {
                throw new UnicoMensagemUsuarioException("WNTF708", "Nota fiscal selecionada n\u00e3o \u00e9 uma NF-e autorizada, emitida em conting\u00eancia ou para uma nota de entrada importada por XML de NF-e.");
            }
            return this.responseEntityService.createPDFResponse(arquivo, nome);
        }
        throw new UnicoMensagemUsuarioException("WNTF9047", "N\u00e3o foram selecionadas notas fiscais para a impress\u00e3o! Verifique.");
    }

    @RequestMapping(value={"/gerar-danfe-lote"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> gerarDanfeEmLote(@RequestBody List<Long> idsNotaFiscal) throws UnicoMensagemUsuarioException {
        List notasFiscais = idsNotaFiscal.stream().map(id -> (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(id)).filter(nota -> nota.getStatus().in(new AbstractEnum[]{StatusNotaFiscal.NFE_AUTORIZADA, StatusNotaFiscal.NFE_EMITIDA_CONTINGENCIA, StatusNotaFiscal.NFE_EMITIDA_EPEC, StatusNotaFiscal.CANCELADA}) || nota.getArquivoXmlNotaOriginal() != null).collect(Collectors.toList());
        if (!Util.listNullOrEmpty(notasFiscais)) {
            ArrayList<byte[]> pdfs = new ArrayList<byte[]>();
            for (NotaFiscal notaFiscal : notasFiscais) {
                if (notaFiscal.getStatus().in(new AbstractEnum[]{StatusNotaFiscal.NFE_AUTORIZADA, StatusNotaFiscal.CANCELADA})) {
                    pdfs.add(new NfeManagerWeb(SessaoUtil.getSessao(), null).gerarDanfeWeb(notaFiscal.getChaveNfe()));
                    continue;
                }
                if (notaFiscal.getStatus().equals((Object)StatusNotaFiscal.NFE_EMITIDA_CONTINGENCIA) || notaFiscal.getStatus().equals((Object)StatusNotaFiscal.NFE_EMITIDA_EPEC)) {
                    pdfs.add(new NfeManagerWeb(SessaoUtil.getSessao(), null).gerarDanfeContingencia(notaFiscal));
                    continue;
                }
                if (notaFiscal.getArquivoXmlNotaOriginal() == null) continue;
                pdfs.add(new NfeManagerWeb(SessaoUtil.getSessao(), null).gerarDanfeNotaEntradaWeb(notaFiscal));
            }
            return this.responseEntityService.createPDFResponse(FileUtil.concatPDFs(pdfs, (boolean)false), "DANFEs");
        }
        throw new UnicoMensagemUsuarioException("WWW348", "A DANFE s\u00f3 pode ser gerada para uma NF-e autorizada, emitida em conting\u00eancia ou para uma nota de entrada importada por XML de NF-e.");
    }

    @RequestMapping(value={"/pre-visualizar-danfe"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> preVisualizarDanfe(@RequestBody Long idNotaFiscal) throws UnicoMensagemUsuarioException {
        NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(idNotaFiscal);
        if (notaFiscal != null && notaFiscal.getSerie().equalsIgnoreCase("55") && TipoEmissaoNotaFiscal.PROPRIA.equals((Object)notaFiscal.getTipoEmissao()) && !notaFiscal.getStatus().equals((Object)StatusNotaFiscal.NFE_AUTORIZADA)) {
            GeradorXMLNFE geradorXMLNFE = new GeradorXMLNFE();
            String chaveNfe = geradorXMLNFE.getChaveAcesso(notaFiscal);
            return this.responseEntityService.createPDFResponse(new NfeManagerWeb(SessaoUtil.getSessao(), null).gerarPreVisualizacaoDanfe(notaFiscal, chaveNfe), "DANFE-".concat(chaveNfe));
        }
        throw new UnicoMensagemUsuarioException("WNTF700", "Op\u00e7\u00e3o habilitada apenas para notas com o modelo 55 (Nf-e) e que foram emitidas pelo sistema e n\u00e3o foram transmitidas.");
    }

    @PostMapping(value={"/compartilhar"})
    @DBTransaction
    public String compartilhar(@RequestBody NotaFiscalCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        this.validarNotasEmail(compartilhamento);
        return super.compartilhar((NotificacaoCompartilhamento)compartilhamento);
    }

    @GetMapping(value={"/preparar-texto-compartilhamento"})
    @DBAutoCommit
    public String prepararTextoEmail(@RequestParam Long idNotaFiscal, @RequestParam Long idTextoGenerico) {
        NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(idNotaFiscal);
        if (notaFiscal != null) {
            return NotaFiscalRN.getInstance().getMensagemCompartilhamentoNFe(SessaoUtil.getSessao().getFilial(), notaFiscal, idTextoGenerico);
        }
        return null;
    }

    @GetMapping(value={"/preparar-compartilhamento"})
    @DBAutoCommit
    public NotificacaoCompartilhamento prepararCompartilhamento(@RequestParam Long idNotaFiscal, @RequestParam(required=false) Long idTextoGenerico, @RequestParam TipoNotificacao tipoNotificacao) throws UnicoMensagemUsuarioException {
        NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(idNotaFiscal);
        if (notaFiscal == null) {
            throw new UnicoMensagemUsuarioException("NTF9418", "Nota fiscal n\u00e3o encontrada");
        }
        NotificacaoCompartilhamento notificacaoCompartilhamento = new NotificacaoCompartilhamento();
        notificacaoCompartilhamento.setIdsDocumentos(Collections.singletonList(notaFiscal.getId()));
        notificacaoCompartilhamento.setTipoNotificacao(tipoNotificacao);
        Map mapCliente = EntidadeRN.getInstance().getDadosNotificacaoWeb(Collections.singletonList(notaFiscal.getIdEntidade()), TipoEmailEntidade.PRINCIPAL);
        if (!mapCliente.isEmpty()) {
            NotificacaoNotaFiscalCliente notificacaoNotaFiscalCliente = (NotificacaoNotaFiscalCliente)mapCliente.get(notaFiscal.getIdEntidade());
            notificacaoCompartilhamento.setEmail(notificacaoNotaFiscalCliente.getEmailEnvio());
            notificacaoCompartilhamento.setCopiaPara(notificacaoNotaFiscalCliente.getEmailCC());
            notificacaoCompartilhamento.setCelular(notificacaoNotaFiscalCliente.getFoneEnvio());
        }
        if (StringUtil.stringNullOrEmpty((String)notificacaoCompartilhamento.getEmail()) && !NumberUtil.longNullOuZero((Long)notaFiscal.getIdTransportadora())) {
            String emailTransportadora = (String)EntidadeRN.getInstance().buscarValorPorID(notaFiscal.getIdTransportadora(), "email");
            notificacaoCompartilhamento.setEmail(emailTransportadora);
        }
        boolean isNFSe = NotaFiscalRN.getInstance().isNfse(notaFiscal);
        Filial filial = (Filial)FilialRN.getInstance().buscarPorId(notaFiscal.getIdFilial());
        String nomeEmpresa = filial.getRazaoSocialCompleta();
        String assunto = isNFSe ? "Nota Fiscal de Servi\u00e7o eletr\u00f4nica (NFS-e) " + notaFiscal.getNumeroNfse() + " de " + nomeEmpresa : "Nota Fiscal eletr\u00f4nica (NF-e) " + notaFiscal.getNumeroNotaFiscal() + " de " + nomeEmpresa;
        notificacaoCompartilhamento.setAssunto(assunto);
        notificacaoCompartilhamento.setMensagem(NotaFiscalRN.getInstance().getMensagemCompartilhamentoNFe(SessaoUtil.getSessao().getFilial(), notaFiscal, idTextoGenerico, tipoNotificacao));
        return notificacaoCompartilhamento;
    }

    protected List<Notificacao> getNotificacoes(Sessao sessao, NotaFiscalCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        List clientesSemEmailFone;
        ArrayList<Notificacao> notificacoes = new ArrayList<Notificacao>();
        boolean emailFixo = !StringUtil.stringNullOrEmpty((String)compartilhamento.getEmail()) && compartilhamento.getTipoNotificacao().equals((Object)TipoNotificacao.EMAIL);
        LocalUsoTextoGenerico localUso = compartilhamento.isNfse() ? LocalUsoTextoGenerico.EMAIL_NFSE : LocalUsoTextoGenerico.EMAIL_NFE;
        Map mapCliente = new HashMap();
        if (!emailFixo) {
            TipoEmailEntidade tipoEmail = compartilhamento.getTipo() != null ? compartilhamento.getTipo() : TipoEmailEntidade.FATURAMENTO;
            mapCliente = EntidadeRN.getInstance().getDadosNotificacaoWeb(compartilhamento.getNotaFiscals().stream().map(NotaFiscal::getIdEntidade).distinct().collect(Collectors.toList()), tipoEmail);
        }
        if (!Util.listNullOrEmpty(clientesSemEmailFone = compartilhamento.getTipoNotificacao().equals((Object)TipoNotificacao.EMAIL) ? mapCliente.values().stream().filter(f -> Util.stringNullOrEmpty((String)f.getEmailEnvio()) && f.getNotasFiscais().stream().anyMatch(n -> Util.stringNullOrEmpty((String)n.getEmailCCTransportadora()))).collect(Collectors.toList()) : mapCliente.values().stream().filter(f -> Util.stringNullOrEmpty((String)Util.apenasNumeros((String)f.getFoneEnvio())) && Util.stringNullOrEmpty((String)Util.apenasNumeros((String)compartilhamento.getCelular()))).collect(Collectors.toList()))) {
            if (clientesSemEmailFone.size() > 1) {
                throw new UnicoMensagemUsuarioException("WWW628", "Existem clientes sem " + (compartilhamento.getTipoNotificacao().equals((Object)TipoNotificacao.EMAIL) ? "e-mail" : "celular") + " cadastrado. Favor inform\u00e1-los.");
            }
            throw new UnicoMensagemUsuarioException("WWW629", "O cliente " + ((NotificacaoNotaFiscalCliente)clientesSemEmailFone.get(0)).getNomeCliente() + " n\u00e3o possui " + (compartilhamento.getTipoNotificacao().equals((Object)TipoNotificacao.EMAIL) ? "e-mail" : "celular") + " cadastrado. Favor inform\u00e1-lo.");
        }
        for (NotaFiscal notaFiscal : compartilhamento.getNotaFiscals()) {
            Notificacao notificacao = new Notificacao();
            notificacao.setUuid(UUID.randomUUID().toString());
            notificacao.setDadosNF(notaFiscal.getNumeroNotaFiscal());
            if (emailFixo) {
                notificacao.setEmail(compartilhamento.getEmail());
                notificacao.setEmailCopia(compartilhamento.getCopiaPara());
            } else {
                String emailTransportadora;
                NotificacaoNotaFiscalCliente notificacaoNotaFiscalCliente = mapCliente.getOrDefault(notaFiscal.getIdEntidade(), new NotificacaoNotaFiscalCliente());
                notificacao.setFone(Util.apenasNumeros((String)notificacaoNotaFiscalCliente.getFoneEnvio()));
                notificacao.setEmail(notificacaoNotaFiscalCliente.getEmailEnvio());
                String cc = notificacaoNotaFiscalCliente.getEmailCC();
                if (compartilhamento.isEnviarEmailTransportadora() && !NumberUtil.longNullOuZero((Long)notaFiscal.getIdTransportadora()) && !StringUtil.stringNullOrEmpty((String)(emailTransportadora = EntidadeRN.getInstance().buscarEmailTransportadoraWeb(notaFiscal.getIdTransportadora())))) {
                    cc = cc + (!StringUtil.stringNullOrEmpty((String)cc) ? "; " : "") + emailTransportadora;
                }
                notificacao.setEmailCopia(cc);
            }
            notificacao.setAssunto(NotaFiscalRN.getInstance().getMensagemCompartilhamentoNFe(sessao.getFilial(), notaFiscal, localUso, compartilhamento.getAssunto()));
            String msg = NotaFiscalRN.getInstance().getMensagemCompartilhamentoNFe(sessao.getFilial(), notaFiscal, localUso, compartilhamento.getMensagem());
            if (TipoNotificacao.EMAIL.equals((Object)compartilhamento.getTipoNotificacao())) {
                if (msg.contains("http://") || msg.contains("https://")) {
                    int inicio = msg.contains("http://") ? msg.indexOf("http://") : msg.indexOf("https://");
                    int fim = msg.indexOf("\n", inicio);
                    if (fim < 0 && (fim = msg.indexOf(" ", inicio)) < 0) {
                        fim = msg.length();
                    }
                    if (fim > inicio) {
                        String linkOriginal = msg.substring(inicio, fim);
                        String linkHtml = "<a href=\"" + linkOriginal + "\">" + linkOriginal + "</a>";
                        msg = msg.replace(linkOriginal, linkHtml);
                    }
                }
                msg = msg + "<br><br>Powered by <a href=\"https://www.intelidata.inf.br/\">Uniplus - Intelidata</a>";
                msg = "<html><body>" + msg + "</body></html>";
            } else {
                msg = msg + "\n\nUniplus - Intelidata";
            }
            notificacao.setMsg(msg);
            DadosBoletoCompartilhamento dadosBoleto = new DadosBoletoCompartilhamento(compartilhamento.getIdContaCorrente(), compartilhamento.getIdCarteira(), compartilhamento.getInstrucao(), compartilhamento.getNumeroDiasInstrucao().intValue(), compartilhamento.getPercentualDescontoPagamentoAteVencimento(), compartilhamento.getObservacao());
            if (compartilhamento.isNfse()) {
                this.notaFiscalCompartilhamentoComponent.montarDadosNFSe(sessao, notaFiscal, dadosBoleto, notificacao);
            } else {
                this.notaFiscalCompartilhamentoComponent.montarDadosNFe(sessao, notaFiscal, dadosBoleto, notificacao);
            }
            notificacoes.add(notificacao);
        }
        return notificacoes;
    }

    protected void createJobEmail(Sessao sessao, ParametrosEmailWeb parametrosEmail, NotaFiscalCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmail, (compartilhamento.isNfse() ? "NFS-e - " : "NF-e - ").concat(compartilhamento.getDadosNF()));
        taskEmail.createTask((Object)parametrosEmail, compartilhamento.getAssunto());
    }

    private void validarNotasEmail(NotaFiscalCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        ArrayList<NotaFiscal> notas = new ArrayList<NotaFiscal>();
        for (int i = 0; i < compartilhamento.getIdsDocumentos().size(); ++i) {
            boolean nfe;
            NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId((Long)compartilhamento.getIdsDocumentos().get(i));
            if (notaFiscal == null) {
                throw new UnicoMensagemUsuarioException("WWW270", "Nota fiscal n\u00e3o encontrada.");
            }
            boolean nfse = NotaFiscalRN.getInstance().isNfse(notaFiscal);
            boolean nfseAutorizada = nfse && (notaFiscal.getStatus().equals((Object)StatusNotaFiscal.NFSE_AUTORIZADA) || notaFiscal.getStatus().equals((Object)StatusNotaFiscal.CANCELADA));
            boolean bl = nfe = NotaFiscalRN.getInstance().isNfe(notaFiscal) && (notaFiscal.getStatus().equals((Object)StatusNotaFiscal.NFE_AUTORIZADA) || notaFiscal.getStatus().equals((Object)StatusNotaFiscal.CANCELADA));
            if (!nfseAutorizada && !nfe) {
                throw new UnicoMensagemUsuarioException("NTF724", "Nf-e n\u00e3o autorizada ou cancelada");
            }
            if (i == 0) {
                compartilhamento.setNfse(nfse);
            }
            notas.add(notaFiscal);
        }
        compartilhamento.setNotaFiscals(notas);
    }
}

