/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.faturamento;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.licenca.Modulo;
import br.intelidata.commons.core.licenca.ModuloManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.model.TipoDadoBase;
import br.intelidata.commons.core.sql.usql.Caso;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Escolha;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.DescontoInterface;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.NaturezaOperacao;
import br.intelidata.commons.domain.pojo.Pedido;
import br.intelidata.commons.domain.pojo.PedidoItem;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.enuns.StatusDAV;
import br.intelidata.commons.domain.pojo.enuns.TipoDocumentoDAV;
import br.intelidata.commons.domain.pojo.enuns.TipoNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.enuns.notafiscal.TipoFaturamentoPedido;
import br.intelidata.commons.domain.pojo.notafiscal.DocumentoPesavelInterface;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalItem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.DescontoRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.PedidoItemRN;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.PedidoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NaturezaOperacaoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalDocumentoFinanceiroRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.commons.modulo.produto.regranegocio.KitRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.faturamento.BuscarItensWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.faturamento.FaturamentoPedidoWrapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/faturamento-pedidos"})
@SubMenuMapping(MENU="SubMenuFiscalGeral", NOME="Faturamento de pedidos", ICONE="icon-faturar", ROTA="/notas-fiscais/faturamento-pedidos", PROGRAMA=215)
public class NotaFiscalFaturamentoPedidoController
extends CrudController<Pedido, PedidoRN> {
    private final FuncionalidadeService funcionalidadeService;

    public NotaFiscalFaturamentoPedidoController(FuncionalidadeService funcionalidadeService) {
        super((AbstractRegraNegocio)PedidoRN.getInstance(), Pedido::new, true, true, true);
        this.funcionalidadeService = funcionalidadeService;
    }

    @RequestMapping(value={"/recalcular-valores-nota-fiscal"}, method={RequestMethod.POST})
    @DBAutoCommit
    public NotaFiscal recalcularValoresNotaFiscal(@RequestBody FaturamentoPedidoWrapper wrapper) throws UnicoMensagemUsuarioException {
        BigDecimal totalFinanceiroItens;
        boolean recalcularImpostos;
        NotaFiscal notaFiscal = wrapper.getNotaFiscal();
        if (ListMapUtil.listNullOrEmpty((List)notaFiscal.getNotaFiscalItens())) {
            throw new UnicoMensagemUsuarioException("WWW195", "N\u00e3o foram definidos os itens de nota fiscal. Verifique!");
        }
        if (PedidoRN.getInstance().isPedidoFaturado(wrapper.getIdsPedidos())) {
            String msg = "Um dos pedidos selecionados j\u00e1 foi faturado.";
            if (wrapper.getIdsPedidos().size() == 1) {
                msg = "O pedido selecionado j\u00e1 foi faturado.";
            }
            throw new UnicoMensagemUsuarioException("WWW736", msg);
        }
        boolean bl = recalcularImpostos = !this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_IMPOSTOS_PEDIDO_ORCAMENTO_FATURAMENTO) || wrapper.isNotaAlterada();
        if (recalcularImpostos) {
            NotaFiscalRN.getInstance().calcularImpostosNotaFiscal(notaFiscal);
        }
        NotaFiscalRN.getInstance().recalculaValoresSubtotal(notaFiscal, notaFiscal.getNotaFiscalItens());
        NaturezaOperacao naturezaOperacaoCabecalho = NaturezaOperacaoRN.getInstance().buscarPorId(notaFiscal.getIdCfop());
        if (naturezaOperacaoCabecalho != null) {
            notaFiscal.setPresencaConsumidor(naturezaOperacaoCabecalho.getPresencaConsumidor());
        }
        Sessao sessao = SessaoUtil.getSessao();
        if (PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 149)) {
            notaFiscal.setDataPedido(PedidoRN.getInstance().buscaMaiorData(wrapper.getIdsPedidos()));
        }
        if ((totalFinanceiroItens = NotaFiscalDocumentoFinanceiroRN.getInstance().calcularValorTotalFinanceiro(notaFiscal.getNotaFiscalItens(), sessao.getFilial(), notaFiscal.getValorVendor())).compareTo(notaFiscal.getAPrazo().add(notaFiscal.getAVista())) != 0) {
            totalFinanceiroItens = totalFinanceiroItens.subtract(notaFiscal.getAVista());
            notaFiscal.setListaDocumentoFinanceiro(NotaFiscalDocumentoFinanceiroRN.getInstance().gerarParcelas(notaFiscal.getIdCondicaoPagto(), totalFinanceiroItens, TipoNotaFiscal.SAIDA.equals((Object)notaFiscal.getTipoDocumento()), notaFiscal.getIdEntidade(), notaFiscal.getIdTipoDocumento(), notaFiscal.getDataPedido(), notaFiscal.getEmissao(), notaFiscal.getDiaFaturamentoContrato(), notaFiscal.getDataVencimentoContrato(), sessao.getFilial(), notaFiscal.getIcmsSubstituicao()));
        }
        NotaFiscalRN.getInstance().atualizarInformacoesCargaNotaFiscal((DocumentoPesavelInterface)notaFiscal, notaFiscal.getNotaFiscalItens());
        return wrapper.getNotaFiscal();
    }

    @RequestMapping(value={"/validar-totais-item"})
    @DBAutoCommit
    public Map<String, BigDecimal> validarTotaisItem(@RequestParam Long id, @RequestParam BigDecimal quantidade) throws UnicoMensagemUsuarioException {
        PedidoItem itemPedido = (PedidoItem)PedidoItemRN.getInstance().buscarPorId(id);
        if (quantidade.compareTo(itemPedido.getSaldoItem()) > 0) {
            throw new UnicoMensagemUsuarioException("WNTF391", "A quantidade n\u00e3o pode ser maior que o saldo do item.");
        }
        return PedidoItemRN.getInstance().getTotalParcial(itemPedido, quantidade);
    }

    @RequestMapping(value={"/importar-pedidos"}, method={RequestMethod.POST})
    @DBAutoCommit
    public FaturamentoPedidoWrapper importarPedidosFaturamento(@RequestBody FaturamentoPedidoWrapper wrapper) throws UnicoMensagemUsuarioException {
        NotaFiscal notaFiscal;
        Sessao sessao = SessaoUtil.getSessao();
        this.validarPedidosConferencia(wrapper.getIdsPedidos(), true);
        PedidoRN.getInstance().verificarPedidos(TipoFaturamentoPedido.PADRAO, wrapper.getIdsPedidos(), true, sessao.getFilial());
        if (!NumberUtil.longNullOuZero((Long)wrapper.getIdCarga())) {
            notaFiscal = NotaFiscalRN.getInstance().importarPedidosCarga(sessao, wrapper.getIdsPedidos(), wrapper.getIdCarga(), wrapper.getIdOperacaoFiscal());
        } else {
            notaFiscal = NotaFiscalRN.getInstance().importarPedidosFaturamento(sessao, wrapper.getIdsPedidos(), 18, wrapper.getIdOperacaoFiscal(), null);
            if (!FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.FINANCEIRO_DETALHADO_PEDIDO)) {
                BigDecimal totalFinanceiroItens = NotaFiscalDocumentoFinanceiroRN.getInstance().calcularValorTotalFinanceiro(notaFiscal.getNotaFiscalItens(), sessao.getFilial(), notaFiscal.getValorVendor());
                if (totalFinanceiroItens.compareTo(notaFiscal.getAVista()) > 0) {
                    totalFinanceiroItens = totalFinanceiroItens.subtract(notaFiscal.getAVista());
                    notaFiscal.setListaDocumentoFinanceiro(NotaFiscalDocumentoFinanceiroRN.getInstance().gerarParcelas(notaFiscal.getIdCondicaoPagto(), totalFinanceiroItens, TipoNotaFiscal.SAIDA.equals((Object)notaFiscal.getTipoDocumento()), notaFiscal.getIdEntidade(), notaFiscal.getIdTipoDocumento(), notaFiscal.getDataPedido(), notaFiscal.getEmissao(), notaFiscal.getDiaFaturamentoContrato(), notaFiscal.getDataVencimentoContrato(), sessao.getFilial(), notaFiscal.getIcmsSubstituicao()));
                } else {
                    notaFiscal.setListaDocumentoFinanceiro(null);
                }
            }
        }
        for (int i = 0; i < notaFiscal.getNotaFiscalItens().size(); ++i) {
            NotaFiscalItem item = (NotaFiscalItem)notaFiscal.getNotaFiscalItens().get(i);
            item.setId(Long.valueOf(Long.parseLong(String.valueOf(-(i + 1)))));
            item.setItemPermiteDesconto(DescontoRN.getInstance().isItemPermiteDesconto(SessaoUtil.getSessao().getFilial(), (DescontoInterface)item, !NumberUtil.longNullOuZero((Long)item.getIdPromocao()) ? PromocaoRN.getInstance().buscarPorId(item.getIdPromocao()) : null));
        }
        Filial filialNotaFiscal = (Filial)FilialRN.getInstance().buscarPorId(notaFiscal.getIdFilial());
        wrapper.setNotaFiscal(notaFiscal);
        wrapper.setCriticas(NotaFiscalItemRN.getInstance().gerarCriticasFaturamentoWeb(filialNotaFiscal, notaFiscal.getNotaFiscalItens(), true));
        return wrapper;
    }

    @RequestMapping(value={"/importar-pedidos-lote"}, method={RequestMethod.POST})
    @DBTransaction
    public List<Long> importarPedidosFaturamentoLote(@RequestBody FaturamentoPedidoWrapper wrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        PedidoRN.getInstance().verificarPedidos(TipoFaturamentoPedido.LOTE, wrapper.getIdsPedidos(), true, sessao.getFilial());
        return NotaFiscalRN.getInstance().importarPedidosEmLote(sessao, wrapper.getIdsPedidos(), wrapper.getIdCarga());
    }

    @PostMapping(value={"/buscar-itens"})
    @DBAutoCommit
    public List<HashMap<String, Object>> carregarItens(@RequestBody BuscarItensWrapper wrapper) {
        ArrayList itens = new ArrayList();
        if (!ListMapUtil.listNullOrEmpty((List)wrapper.getItensCarga())) {
            Map mapItens = PedidoRN.getInstance().buscarListaItensParaFaturarPedido(Arrays.asList(wrapper.getIdPedido()), wrapper.getItensCarga());
            if (!ListMapUtil.mapNullOrEmpty((Map)mapItens)) {
                mapItens.values().forEach(value -> value.forEach(pedItem -> itens.add(pedItem.getItem())));
            }
        } else {
            itens.addAll(KitRN.getInstance().agruparItensKit(PedidoItemRN.getInstance().buscarListaPorIdPedidoSemCancelados(wrapper.getIdPedido())));
        }
        if (!ListMapUtil.listNullOrEmpty(itens)) {
            ArrayList<HashMap<String, Object>> listaItens = new ArrayList<HashMap<String, Object>>(itens.size());
            for (PedidoItem item : itens) {
                listaItens.add(this.getMapItemPedido(item));
            }
            return listaItens;
        }
        return Collections.emptyList();
    }

    private HashMap<String, Object> getMapItemPedido(PedidoItem item) {
        BigDecimal saldoItem = item.getSaldoItem();
        if (saldoItem.compareTo(BigDecimal.ZERO) <= 0) {
            return null;
        }
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(item.getIdproduto());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sequencia", item.getContador());
        map.put("codigo", produto != null ? produto.getCodigo() : null);
        map.put("produto", produto != null ? produto.getNome() : null);
        map.put("unidadeMedida", produto != null ? produto.getUnidadeMedida() : null);
        map.put("preco", item.getPreco().setScale(2, RoundingMode.HALF_EVEN));
        map.put("quantidade", item.getQuantidade().setScale(item.getDecimaisQuantidade(), RoundingMode.HALF_EVEN));
        map.put("saldoItem", saldoItem.setScale(item.getDecimaisQuantidade(), RoundingMode.HALF_EVEN));
        map.put("decimaisQuantidade", item.getDecimaisQuantidade());
        map.put("desconto", item.getDesconto().setScale(2, RoundingMode.HALF_EVEN));
        map.put("total", item.getTotal().setScale(2, RoundingMode.HALF_EVEN));
        map.put("nrPedidoCliente", item.getNumeroPedidoCliente());
        map.put("brinde", item.getBrinde());
        map.put("tipoKit", item.getTipoKit());
        if (!ListMapUtil.listNullOrEmpty((List)item.getFilhosKit())) {
            ArrayList<HashMap> listaItensKit = new ArrayList<HashMap>(item.getFilhosKit().size());
            for (PedidoItem itemKit : item.getFilhosKit()) {
                listaItensKit.add(this.getMapItemPedido(itemKit));
            }
            map.put("filhosKit", listaItensKit);
        }
        map.put("item", item);
        return map;
    }

    protected String getCacheId() {
        return "faturamento-pedidos".concat("_ID_FILIAL_").concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }

    protected GridBuilder<PedidoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("idCliente", "ID Cliente", 0, false));
        colunas.add(new ColunaSQL("idOperacaoFiscal", "ID da Opera\u00e7\u00e3o Fiscal", 0, false));
        colunas.add(new ColunaSQL("data", "Data", 100, false));
        colunas.add(new ColunaSQL("idOperacaoFiscal", "idOperacaoFiscalCliente", "Opera\u00e7\u00e3o fiscal", 0, false, new String[]{"fk_dav_cliente"}));
        colunas.add(new ColunaSQL("codigo", "Documento", 110, true));
        colunas.add(new ColunaSQL("data", "Data", 100, true));
        colunas.add(new ColunaSQL("pedidoCliente", "Pedido do cliente", 0, true));
        colunas.add(new ColunaSQL("nome", "nomeCliente", "Cliente", 340, true, new String[]{"fk_dav_cliente"}));
        colunas.add(new ColunaSQL("nome", "nomeVendedor", "Vendedor", 0, true, new String[]{"fk_dav_representante"}));
        colunas.add(new ColunaSQL("descricao", "descricaoCondPagto", "Cond. de pagamento", 0, true, new String[]{"fk_dav_condicaopagamento"}));
        colunas.add(new ColunaSQL("valor", "Valor", 120, true));
        colunas.add(new ColunaSQL("entrega", "Data entrega", 150, true));
        if (ModuloManager.getInstance().isAtivo(Modulo.EXPEDICAO)) {
            colunas.add(new ColunaSQL("idestadoentrega", "idestadoentregaped"));
            colunas.add(new ColunaSQL("id", "idestadocliente", "Estado entrega cliente", 0, false, new String[]{"fk_dav_cliente", "fk_entidade_estado"}));
            Escolha escolhaEstadoEntrega = new Escolha(new Caso(new Condicao("idestadoentregaped", Operador.MAIOR_QUE, Long.valueOf(0L)), "idestadoentregaped"), "idestadocliente");
            ColunaSQL colunaSQLEstadoEntrega = new ColunaSQL(escolhaEstadoEntrega, "entregaidestado");
            colunaSQLEstadoEntrega.setTipoDadoBase(TipoDadoBase.NUMERIC);
            colunas.add(colunaSQLEstadoEntrega);
            colunas.add(new ColunaSQL("idcidadeentrega", "idcidadeentregaped"));
            colunas.add(new ColunaSQL("id", "idcidadecliente", "Cidade entrega cliente", 0, false, new String[]{"fk_dav_cliente", "fk_entidade_cidade"}));
            Escolha escolhaCidadeEntrega = new Escolha(new Caso(new Condicao("idestadoentregaped", Operador.MAIOR_QUE, Long.valueOf(0L)), "idcidadeentregaped"), "idcidadecliente");
            ColunaSQL colunaSQLCidadeEntrega = new ColunaSQL(escolhaCidadeEntrega, "entregaidcidade");
            colunaSQLCidadeEntrega.setTipoDadoBase(TipoDadoBase.NUMERIC);
            colunas.add(colunaSQLCidadeEntrega);
            colunas.add(new ColunaSQL("idrota", "idrota", new String[]{"fk_dav_cliente"}));
        }
        GridBuilder grid = new GridBuilder(((PedidoRN)this.rn).getTabela(), colunas, Arrays.asList(new Ordem("data", true), new Ordem("codigo", true)), "faturamento_pedido");
        grid.addReferenciaDefault(new Referencia("tipodocumento"));
        grid.addReferenciaDefault(new Referencia("idfilial"));
        grid.addReferenciaDefault(new Referencia("status"));
        grid.addReferenciaDefault(new Referencia("entrega"));
        grid.addCodicaoDefault(new Condicao("tipodocumento", Operador.IGUAL, TipoDocumentoDAV.PEDIDO_FATURAMENTO.getId().intValue()));
        grid.addCodicaoDefault(new Condicao("status", Operador.CONTIDO_EM, Arrays.asList(StatusDAV.FECHADO, StatusDAV.PARCIAL, StatusDAV.AGUARDANDO_FATURAMENTO)));
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getFilial().getId()));
        return grid;
    }

    @RequestMapping(value={"/validar-conferencia"})
    @DBAutoCommit
    public void verificarPedidosConferencia(@RequestParam List<Long> idsPedidos) throws UnicoMensagemUsuarioException {
        this.validarPedidosConferencia(idsPedidos, false);
    }

    @DBAutoCommit
    private void validarPedidosConferencia(List<Long> idsPedidos, boolean notificar) throws UnicoMensagemUsuarioException {
        String mensagem;
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CONFERENCIA) && PropriedadeRN.getInstance().getPropriedadeBoolean(Contexto.getInstance().getFilial(), 908) && !Util.stringNullOrEmpty((String)(mensagem = PedidoRN.getInstance().verificarConferenciaPedidos(idsPedidos)))) {
            if (notificar) {
                this.notificationService.notifyUser(SessaoUtil.getSessao().getIdUsuario(), mensagem, TipoNotificacaoSimples.WARNING, NotificationType.SIMPLE_NOTIFICATION, 20000);
            } else {
                throw new UnicoMensagemUsuarioException("NTF9578", mensagem + "<br>Deseja continuar com o faturamento?");
            }
        }
    }
}

