/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.cartacorrecao;

import br.intelidata.commons.core.documentosfiscais.util.CCE;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.InputStreamDataSource;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.domain.pojo.CartaCorrecao;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.notafiscal.regranegocio.CartaCorrecaoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CompartilhamentoController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.activation.DataSource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/cartas-correcoes"})
public class CartaCorrecaoJobController
extends CompartilhamentoController<NotificacaoCompartilhamento> {
    public CartaCorrecaoJobController(TaskManager taskManager) {
        super(taskManager);
    }

    protected List<Notificacao> getNotificacoes(Sessao sessao, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        Notificacao notificacao = new Notificacao();
        notificacao.setFone(compartilhamento.getCelular());
        notificacao.setEmail(compartilhamento.getEmail());
        notificacao.setEmailCopia(compartilhamento.getCopiaPara());
        notificacao.setMsg(compartilhamento.getMensagem());
        NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId((Long)compartilhamento.getIdsDocumentos().get(0));
        if (notaFiscal == null) {
            throw new UnicoMensagemUsuarioException("WWW263", "Nota fiscal n\u00e3o encontrada.");
        }
        String nomeEmpresa = sessao.getFilial().getRazaoSocialCompleta();
        String assunto = "Cartas de corre\u00e7\u00e3o eletr\u00f4nica referente a NF-e " + notaFiscal.getNumeroNotaFiscal() + " de " + nomeEmpresa;
        notificacao.setAssunto(assunto);
        Malote malote = new Malote();
        ArrayList<InputStreamDataSource> dataSources = new ArrayList<InputStreamDataSource>();
        byte[] pdf = CCE.getInstance().geraCCEWeb(notaFiscal.getId());
        malote.inclui("CCE-" + notaFiscal.getChaveNfe() + ".pdf", pdf);
        InputStreamDataSource dataSourcePDF = new InputStreamDataSource("CCE-" + notaFiscal.getChaveNfe() + ".pdf", "application/pdf", (InputStream)new ByteArrayInputStream(pdf));
        dataSources.add(dataSourcePDF);
        List cartas = CartaCorrecaoRN.getInstance().buscarListaPorIdNotaFiscal(notaFiscal.getId());
        for (CartaCorrecao cartaCorrecao : cartas) {
            if (cartaCorrecao.getArquivoTransmitido() == null) continue;
            try {
                String arquivo = notaFiscal.getChaveNfe() + "-CCE" + StringUtil.zeroEsquerda((String)String.valueOf(cartaCorrecao.getSequencia()), (int)2) + ".xml";
                InputStreamDataSource dataSourceXml = new InputStreamDataSource(arquivo, "text/xml", (InputStream)new ByteArrayInputStream(cartaCorrecao.getArquivoTransmitido()));
                dataSources.add(dataSourceXml);
                malote.inclui(arquivo, cartaCorrecao.getArquivoTransmitido());
            }
            catch (NullPointerException ex) {
                throw new UnicoMensagemUsuarioException("WNTF40", "N\u00e3o foi poss\u00edvel anexar carta de corre\u00e7\u00e3o ao e-mail.", (Throwable)ex);
            }
        }
        if (dataSources.isEmpty()) {
            throw new UnicoMensagemUsuarioException("WNTF866", "Nenhuma carta de corre\u00e7\u00e3o foi enviada por e-mail.");
        }
        notificacao.setDataSources(dataSources.toArray(new DataSource[0]));
        notificacao.setMalote(malote);
        return Collections.singletonList(notificacao);
    }

    protected void createJobEmail(Sessao sessao, ParametrosEmailWeb parametrosEmail, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmail, "Carta de corre\u00e7\u00e3o");
        taskEmail.createTask((Object)parametrosEmail, compartilhamento.getAssunto());
    }
}

