/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.documentodestinado.nfe;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.RetornoEnvioEventoNFE;
import br.intelidata.commons.core.documentosfiscais.util.Danfe2;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.UnicoSistema;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.DocumentoDestinado;
import br.intelidata.commons.domain.pojo.enuns.SituacaoManifestacaoDestinatario;
import br.intelidata.commons.domain.pojo.enuns.StatusNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoRegistroConsultaDocumentoDestinatario;
import br.intelidata.commons.domain.pojo.manifesto.ManifestoDocumento;
import br.intelidata.commons.domain.pojo.manifesto.ManifestoNotaFiscal;
import br.intelidata.commons.modulo.notafiscal.nfe.NfeManagerRN;
import br.intelidata.commons.modulo.notafiscal.nfe.NfeManagerWeb;
import br.intelidata.commons.modulo.notafiscal.regranegocio.DocumentoDestinadoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.LogAcaoUsuarioRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.documentodestinado.DocumentoDestinadoCrudController;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/documentos-destinados-nfe"})
public class DocumentoDestinadoNfeCrudController
extends DocumentoDestinadoCrudController {
    public DocumentoDestinadoNfeCrudController() {
        super(TipoRegistroConsultaDocumentoDestinatario.NFE);
    }

    @RequestMapping(value={"/manifestar"})
    @DBTransaction
    public String manifestarDocumento(@RequestParam Long idDocumento, @RequestParam SituacaoManifestacaoDestinatario situacao, @RequestParam(required=false) String justificativa) throws UnicoMensagemUsuarioException {
        if (situacao.isPedirJustificativa() && StringUtil.stringNullOrEmpty((String)justificativa)) {
            throw new UnicoMensagemUsuarioException("WWW272", "Por favor informe a justificativa.");
        }
        DocumentoDestinado documentoDestinado = (DocumentoDestinado)DocumentoDestinadoRN.getInstance().buscarPorId(idDocumento);
        if (documentoDestinado != null) {
            RetornoEnvioEventoNFE retornoEnvioEventoNFE = new NfeManagerWeb(SessaoUtil.getSessao(), null).manifestacaoDestinatarioEvento(documentoDestinado.getId().toString(), documentoDestinado.getChaveAcesso(), situacao, justificativa);
            if (retornoEnvioEventoNFE.getStatusEvento().equals(128)) {
                Integer status = retornoEnvioEventoNFE.getRetornoEvento().getInformacaoRetornoEvento().getStatusEvento();
                String descricao = retornoEnvioEventoNFE.getRetornoEvento().getInformacaoRetornoEvento().getMotivo();
                if (status.equals(135) || status.equals(136) || status.equals(573)) {
                    documentoDestinado.setSituacaoManifestacaoDest(situacao);
                    DocumentoDestinadoRN.getInstance().gravar(1, (AbstractPojo)documentoDestinado, SessaoUtil.getSessao());
                    LogAcaoUsuarioRN.getInstance().incluirAcaoUsuarioCorrente(SessaoUtil.getSessao(), DocumentoDestinadoRN.getInstance().getTabela(), documentoDestinado.getId(), situacao.getDescricaoAcaoLog() + documentoDestinado.getChaveAcesso(), situacao.getTipoLogAcaoUsuario());
                    String msg = status + " - " + descricao;
                    if (status.equals(573)) {
                        msg = msg + ". Documento atualizado no sistema";
                    }
                    return msg;
                }
                throw new UnicoMensagemUsuarioException("WNTF365", status + " - " + descricao);
            }
            throw new UnicoMensagemUsuarioException("WNTF367", retornoEnvioEventoNFE.getStatusEvento() + " - " + retornoEnvioEventoNFE.getMotivo());
        }
        throw new UnicoMensagemUsuarioException("WWW273", "Documento n\u00e3o encontrado.");
    }

    @RequestMapping(value={"/download-xml"}, method={RequestMethod.POST})
    @DBTransaction
    public String confirmarDownloadXml(@RequestBody Long idDocumento) throws UnicoMensagemUsuarioException {
        DocumentoDestinado doc = (DocumentoDestinado)DocumentoDestinadoRN.getInstance().buscarPorId(idDocumento);
        if (doc != null) {
            if (doc.getSituacaoManifestacaoDest() != SituacaoManifestacaoDestinatario.CONFIRMADA && doc.getSituacaoManifestacaoDest() != SituacaoManifestacaoDestinatario.CIENCIA) {
                throw new UnicoMensagemUsuarioException("WWW277", "O download s\u00f3 pode ocorrer para os documentos com situa\u00e7\u00e3o de manifesta\u00e7\u00e3o igual a 'Ci\u00eancia' ou 'Confirmada'.");
            }
            return doc.getChaveAcesso();
        }
        throw new UnicoMensagemUsuarioException("WWW278", "N\u00e3o foi poss\u00edvel encontrar o documento.");
    }

    @RequestMapping(value={"/confirma-visualiza"}, method={RequestMethod.POST})
    @DBTransaction
    public ResponseEntity<byte[]> confirmaEVisualisa(@RequestBody String chaveNfe) throws UnicoMensagemUsuarioException {
        byte[] xml = new NfeManagerWeb(SessaoUtil.getSessao(), null).reconhecerEBaixarNFe(chaveNfe);
        if (xml == null) {
            throw new UnicoMensagemUsuarioException("WNTF822", "N\u00e3o foi poss\u00edvel importar o XML. Verifique!");
        }
        byte[] arquivoPdf = Danfe2.getInstance().geraDanfeWeb(chaveNfe, null, (InputStream)new ByteArrayInputStream(xml), false, null, null, null, null, false, UnicoSistema.getNomeSistema(), SessaoUtil.getSessao().getFilial(), StatusNotaFiscal.NORMAL);
        return this.responseEntityService.createPDFResponse(arquivoPdf, chaveNfe);
    }

    @RequestMapping(value={"/gerar-mdfe"}, method={RequestMethod.POST})
    @DBTransaction
    public ManifestoDocumento gerarMDFE(@RequestBody List<Long> ids) throws UnicoMensagemUsuarioException {
        List docs = DocumentoDestinadoRN.getInstance().buscarListaPorIds(ids);
        ManifestoDocumento manifestoDocumento = new NfeManagerRN(SessaoUtil.getSessao()).gerarMDFe(docs.stream().map(DocumentoDestinado::getChaveAcesso).collect(Collectors.toList()));
        if (!Util.listNullOrEmpty((List)manifestoDocumento.getNfes())) {
            ArrayList<ManifestoNotaFiscal> listaNF = new ArrayList<ManifestoNotaFiscal>();
            ArrayList<ManifestoNotaFiscal> listaNFTerceiro = new ArrayList<ManifestoNotaFiscal>();
            for (ManifestoNotaFiscal nota : manifestoDocumento.getNfes()) {
                if (!Util.longNullOuZero((Long)nota.getIdNotaFiscal())) {
                    listaNF.add(nota);
                    continue;
                }
                listaNFTerceiro.add(nota);
            }
            manifestoDocumento.setNfes(listaNF);
            manifestoDocumento.setNfesTerceiro(listaNFTerceiro);
        }
        return manifestoDocumento;
    }

    protected String getCacheId() {
        return "documentos-destinados-nfe";
    }
}

