/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.parametrosnfse;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.documentosfiscais.unfse.Parametro;
import br.intelidata.commons.core.documentosfiscais.unfse.TransmissorNfseLocal;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.IFileStorage;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.ParametroNFSE;
import br.intelidata.commons.domain.pojo.ProvedorUnicoNfseParametro;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.enuns.nfse.ModeloNfse;
import br.intelidata.commons.domain.pojo.enuns.nfse.ProvedorUnicoNfse;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.ProvedorUnicoNfseParametroRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.ArquivoFiscalWeb;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.parametrosnfse.JobAtualizarCidadeTOM;
import br.intelidata.uniplusweb.web.rest.app.crud.parametrosnfse.ParametroNfseCrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/parametros-nfse"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliarParametrosNotaFiscal", NOME="Par\u00e2metros da NFS-e", ROTA="/notas-fiscais/parametros-nfse", PROGRAMA=45)
public class ParametroNfseCrudController
extends SimpleCrudController<ParametroNFSE, FilialRN>
implements ICreateTask {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TaskManager taskManager;
    private final NotificationService notificationService;
    private final ArquivoFiscalWeb arquivoFiscal;

    @Autowired
    public ParametroNfseCrudController(TaskManager taskManager, NotificationService notificationService, ArquivoFiscalWeb arquivoFiscal) {
        super((AbstractRegraNegocio)FilialRN.getInstance(), TipoArquivoArmazenado.ParametrosNFSe);
        this.notificationService = notificationService;
        this.taskManager = taskManager;
        this.arquivoFiscal = arquivoFiscal;
    }

    public TipoJob getTipoJob() {
        return TipoJob.ATUALIZACAO_CIDADE_TOM;
    }

    public Class<? extends AbstractJob> job() {
        return JobAtualizarCidadeTOM.class;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    @RequestMapping(value={"/por-provedor"})
    @DBAutoCommit
    public List<ProvedorUnicoNfseParametro> buscarParametrosPorProvedor(@RequestParam ProvedorUnicoNfse provedor) {
        ArrayList<ProvedorUnicoNfseParametro> parametros = ProvedorUnicoNfseParametroRN.getInstance().buscarParametrosPorProvedor(SessaoUtil.getSessao().getFilial().getId(), provedor);
        if (ListMapUtil.listNullOrEmpty((List)parametros)) {
            parametros = new ArrayList<ProvedorUnicoNfseParametro>();
        }
        Parametro[] parametrosNfse = null;
        try {
            TransmissorNfseLocal uNfse = new TransmissorNfseLocal(SessaoUtil.getSessao().getFilial(), provedor.getProvedor(), false, (IFileStorage)this.arquivoFiscal);
            parametrosNfse = uNfse.getParametros();
        }
        catch (UnicoMensagemUsuarioException e) {
            this.log.error("N\u00e3o foi poss\u00edvel carregar os p\u00e2rametros do provedor", (Throwable)e);
        }
        if (parametrosNfse != null) {
            for (Parametro p : parametrosNfse) {
                Optional<ProvedorUnicoNfseParametro> filtroExistente = parametros.stream().filter(parametro -> parametro.getParametro().equals(p.getId())).findFirst();
                if (filtroExistente.isPresent()) {
                    filtroExistente.get().setObservacao(p.getObservacao());
                    continue;
                }
                ProvedorUnicoNfseParametro parametro2 = new ProvedorUnicoNfseParametro();
                parametro2.setProvedor(provedor);
                parametro2.setParametro(p.getId());
                parametro2.setValor(p.getDescricao());
                parametro2.setObservacao(p.getObservacao());
                parametros.add(parametro2);
            }
        }
        return parametros;
    }

    @DBAutoCommit
    public ParametroNFSE get(@RequestParam(required=false) Long parentId) {
        return ((Filial)FilialRN.getInstance().buscarPorIdLazy(SessaoUtil.getSessao().getIdFilial())).getParametroNFSE();
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody ParametroNFSE parametroNFSE) throws UnicoMensagemUsuarioException {
        Long id = this.gravar(parametroNFSE);
        this.afterSave(parametroNFSE);
        return id;
    }

    @ResponseBody
    @RequestMapping(value={"/create-files"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @DBTransaction
    public Long createWithFile(@RequestPart(value="files") MultipartFile[] files, @RequestPart(value="entity") ParametroNFSE parametroNFSE) throws UnicoMensagemUsuarioException {
        this.loadFile(files, (AbstractPojo)parametroNFSE);
        Long id = this.gravar(parametroNFSE);
        this.afterSave(parametroNFSE);
        return id;
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody ParametroNFSE parametroNFSE) throws UnicoMensagemUsuarioException {
        this.validarCurrentTimeMillis((AbstractPojo)parametroNFSE);
        Long id = this.gravar(parametroNFSE);
        this.afterSave(parametroNFSE);
        return id;
    }

    @ResponseBody
    @RequestMapping(value={"/update-files"}, method={RequestMethod.PUT}, consumes={"multipart/form-data"})
    @DBTransaction
    public Long updateWithFiles(@RequestPart(value="files") MultipartFile[] files, @RequestPart(value="entity") ParametroNFSE parametroNFSE) throws UnicoMensagemUsuarioException {
        this.loadFile(files, (AbstractPojo)parametroNFSE);
        Long id = this.gravar(parametroNFSE);
        this.afterSave(parametroNFSE);
        return id;
    }

    public void afterSave(ParametroNFSE parametroNFSE) throws UnicoMensagemUsuarioException {
        this.createTask((Object)parametroNFSE, "Atualizando cadastro de cidades");
        this.notificationService.simpleNotifyTenantAll(TipoNotificacaoSimples.WARNING, "As configura\u00e7\u00f5es de NFS-e foram alteradas, por favor realize o login novamente para aplicar as novas configura\u00e7\u00f5es.");
    }

    private Long gravar(ParametroNFSE parametroNFSE) throws UnicoMensagemUsuarioException {
        String caminhoOriginal;
        Filial filial = (Filial)FilialRN.getInstance().buscarPorIdLazy(SessaoUtil.getSessao().getIdFilial());
        ModeloNfse modeloNfseAnterior = filial.getParametroNFSE().getModeloNfse();
        ParametroNFSE parametrosOriginais = this.get(null);
        if (parametrosOriginais != null) {
            parametroNFSE.setCertificadoNfse(parametrosOriginais.getCertificadoNfse());
        }
        if (!(StringUtil.stringNullOrEmpty((String)(caminhoOriginal = filial.getParametroNFSE().getArquivoImagemDANFSE())) || !StringUtil.stringNullOrEmpty((String)parametroNFSE.getArquivoImagemDANFSE()) && parametroNFSE.getArquivoImagemDANFSE().equals(caminhoOriginal))) {
            this.saveFile.excluirArquivo(ContextoHolder.getTenant(), this.getTipoArmazenamento(), caminhoOriginal, false);
        }
        filial.setParametroNFSE(parametroNFSE);
        filial.setAtualizaParametrosNfse(true);
        filial.setNaoGravarListas(true);
        FilialRN.getInstance().gravar(1, filial, SessaoUtil.getSessao());
        if (parametroNFSE.getModeloNfse().equals((Object)ModeloNfse.NFSE_NACIONAL) && modeloNfseAnterior != null && !modeloNfseAnterior.equals((Object)ModeloNfse.NFSE_NACIONAL)) {
            1 iCreateTask = new /* Unavailable Anonymous Inner Class!! */;
            iCreateTask.createTask(null, "Atualizando a cadeia de certificados");
            this.notificationService.notifyUserNow(NotificationType.SIMPLE_NOTIFICATION, (Object)"Atualiza\u00e7\u00e3o de cadeia de certificados agendada com sucesso");
        }
        return filial.getId();
    }

    static /* synthetic */ TaskManager access$000(ParametroNfseCrudController x0) {
        return x0.taskManager;
    }
}

