/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.pdv.sangriasuprimento;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.Pagamento;
import br.intelidata.commons.domain.pojo.enuns.TipoLiberacaoSupervisorPdv;
import br.intelidata.commons.domain.pojo.enuns.pafecf.StatusFechamentoPdv;
import br.intelidata.commons.domain.pojo.enuns.pafecf.TipoOperacao;
import br.intelidata.commons.domain.pojo.pafecf.FechamentoPdv;
import br.intelidata.commons.domain.pojo.pafecf.Finalizador;
import br.intelidata.commons.domain.pojo.pafecf.MotivoSangriaSuprimento;
import br.intelidata.commons.domain.regranegocio.FechamentoPdvCommonRN;
import br.intelidata.commons.domain.regranegocio.OperacaoCommonRN;
import br.intelidata.commons.modulo.pdv.regranegocio.FinalizadorRN;
import br.intelidata.uniplusweb.web.rest.app.crud.pdv.InicioOperacaoWeb;
import br.intelidata.uniplusweb.web.rest.app.crud.pdv.InicioPagamentoWeb;
import java.math.BigDecimal;
import java.util.Collections;

public abstract class SangriaSuprimentoAbstract {
    private final TipoOperacao tipoOperacao;
    private TipoLiberacaoSupervisorPdv tipoLiberacao;
    private MotivoSangriaSuprimento motivo;
    private String historico;
    private String documento;
    private boolean fechamento;
    private BigDecimal valorSobra;
    private Long idSobraFalta;
    private boolean imprimirComprovante;

    public SangriaSuprimentoAbstract(TipoOperacao tipoOperacao) {
        this.tipoOperacao = tipoOperacao;
        this.imprimirComprovante = true;
    }

    public Long lancar(Sessao sessao, BigDecimal valor) throws UnicoMensagemUsuarioException {
        Operacao opercao = this.novaOperacao(sessao, valor);
        this.subtotalizar(opercao, valor);
        this.gravarOperacao(sessao, opercao);
        return opercao.getId();
    }

    protected Operacao novaOperacao(Sessao sessao, BigDecimal valor) throws UnicoMensagemUsuarioException {
        Finalizador finalizador = FinalizadorRN.getInstance().buscarLista().stream().filter(f -> f.getNome().equalsIgnoreCase("DINHEIRO")).findFirst().orElse(null);
        Pagamento pagamento = new Pagamento();
        pagamento.setDataVencimento(DataHoraFactory.getData());
        pagamento.setValorTotal(valor);
        if (finalizador != null) {
            pagamento.setFinalizador(finalizador.getCodigo());
            pagamento.setNomeFinalizador(finalizador.getNome());
        }
        Operacao operacao = new InicioOperacaoWeb().iniciarNovaOperacao(sessao, this.tipoOperacao);
        operacao.setMotivo(this.getMotivo() == null ? Integer.valueOf(0) : this.getMotivo().getCodigo());
        operacao.setFechamentoCaixa(this.isFechamento());
        operacao.setDocumento(this.getDocumento());
        operacao.setSobraCaixa(this.getValorSobra());
        operacao.setIdSobraFalta(this.getIdSobraFalta());
        new InicioPagamentoWeb().gerarParcelas(sessao, Collections.singletonList(pagamento), operacao);
        operacao.addPagamento(pagamento);
        new InicioOperacaoWeb().marcaInicioOperacao(sessao, operacao);
        return operacao;
    }

    protected void subtotalizar(Operacao operacao, BigDecimal valor) {
        operacao.setValorBruto(valor);
        operacao.setValorLiquido(valor);
        operacao.setAVista(valor);
        operacao.setHistorico(this.getHistorico());
    }

    protected void gravarOperacao(Sessao sessao, Operacao operacao) throws UnicoMensagemUsuarioException {
        operacao.setNfce(false);
        operacao.setTipoDocumento(0);
        operacao.setHoraFinal(DataHoraFactory.getDataHora());
        OperacaoCommonRN.getInstance().incluirOperacaoCompleta(operacao, sessao);
        this.gravarFechamento(sessao, operacao);
    }

    protected BigDecimal getSaldo(Sessao sessao) {
        FechamentoPdv fechamentoPdv = FechamentoPdvCommonRN.getInstance().buscarFechamentoAbertoUsuario(sessao, sessao.getIdUsuario());
        if (fechamentoPdv != null) {
            return FechamentoPdvCommonRN.getInstance().getSaldo(fechamentoPdv);
        }
        return BigDecimal.ZERO;
    }

    private void gravarFechamento(Sessao sessao, Operacao operacao) throws UnicoMensagemUsuarioException {
        if (!this.isFechamento()) {
            return;
        }
        FechamentoPdv fechamentoPdv = (FechamentoPdv)FechamentoPdvCommonRN.getInstance().buscarPorId(operacao.getIdFechamento());
        BigDecimal saldoApurado = FechamentoPdvCommonRN.getInstance().getSaldo(fechamentoPdv);
        fechamentoPdv.setStatus(StatusFechamentoPdv.FECHADO);
        fechamentoPdv.setSaldoInformado(operacao.getValorLiquido());
        fechamentoPdv.setSaldoConferido(operacao.getValorLiquido());
        fechamentoPdv.setSaldoApurado(saldoApurado);
        fechamentoPdv.setIdOperacao(operacao.getId());
        FechamentoPdvCommonRN.getInstance().alterar((AbstractPojo)fechamentoPdv, sessao);
    }

    public TipoLiberacaoSupervisorPdv getTipoLiberacao() {
        return this.tipoLiberacao;
    }

    public void setTipoLiberacao(TipoLiberacaoSupervisorPdv tipoLiberacao) {
        this.tipoLiberacao = tipoLiberacao;
    }

    public MotivoSangriaSuprimento getMotivo() {
        return this.motivo;
    }

    public void setMotivo(MotivoSangriaSuprimento motivo) {
        this.motivo = motivo;
    }

    public String getHistorico() {
        return this.historico;
    }

    public void setHistorico(String historico) {
        this.historico = historico;
    }

    public String getDocumento() {
        return this.documento;
    }

    public void setDocumento(String documento) {
        this.documento = documento;
    }

    public boolean isFechamento() {
        return this.fechamento;
    }

    public void setFechamento(boolean fechamento) {
        this.fechamento = fechamento;
    }

    public BigDecimal getValorSobra() {
        return this.valorSobra;
    }

    public void setValorSobra(BigDecimal valorSobra) {
        this.valorSobra = valorSobra;
    }

    public Long getIdSobraFalta() {
        return this.idSobraFalta;
    }

    public void setIdSobraFalta(Long idSobraFalta) {
        this.idSobraFalta = idSobraFalta;
    }

    public boolean isImprimirComprovante() {
        return this.imprimirComprovante;
    }

    public void setImprimirComprovante(boolean imprimirComprovante) {
        this.imprimirComprovante = imprimirComprovante;
    }
}

