/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.pendenciasnfce.inutilizacoes;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.EnumJoin;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Separador;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.enuns.nfe.SituacaoInutilizacaoNfce;
import br.intelidata.commons.domain.pojo.notafiscal.PendenciaNfe;
import br.intelidata.commons.domain.pojo.pafecf.InutilizacaoNfce;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.notafiscal.regranegocio.PendenciaNfeRN;
import br.intelidata.commons.modulo.pdv.patches.CorrigiNfceEmDuplicidade;
import br.intelidata.commons.modulo.pdv.regranegocio.InutilizacaoNfceRN;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoNfceRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pendencia-inutilizacao"})
public class PendenciaInutilizacaoCrudController
extends CrudController<PendenciaNfe, PendenciaNfeRN> {
    public PendenciaInutilizacaoCrudController() {
        super((AbstractRegraNegocio)PendenciaNfeRN.getInstance(), PendenciaNfe::new, true, true);
    }

    protected String getCacheId() {
        return "pendencia-inutilizacao";
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id"));
        colunas.add(new ColunaSQL("idNfce"));
        colunas.add(new ColunaSQL("id", "idobjeto_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_inutnfce"}));
        colunas.add(new ColunaSQL("filial", "filial_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_inutnfce"}));
        colunas.add(new ColunaSQL("serie", "serie_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_inutnfce"}));
        colunas.add(new ColunaSQL("numero", "numero_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_inutnfce"}));
        colunas.add(new ColunaSQL("data", "data_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_inutnfce"}));
        colunas.add(new ColunaSQL("situacaoinutilizacao", "situacao_", EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_inutnfce"}));
        colunas.add(new ColunaSQL("qtdtransmissao", "qtdtransmissao_"));
        colunas.add(new ColunaSQL("ultimatransmissao", "ultimatransmissao_"));
        colunas.add(new ColunaSQL("codigorejeicao", "codigorejeicao_"));
        colunas.add(new ColunaSQL("serie", "serie_inutilizacao", "S\u00e9rie", 50, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_inutnfce"}));
        colunas.add(new ColunaSQL("numero", "numero_inutilizacao", "N\u00famero", 90, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_inutnfce"}));
        colunas.add(new ColunaSQL("data", "data_inutilizacao", "Emiss\u00e3o", 150, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_inutnfce"}));
        colunas.add(new ColunaSQL("qtdtransmissao", "Qtd. Transmiss\u00e3o", 130, true));
        colunas.add(new ColunaSQL("ultimatransmissao", "Ult. Transmiss\u00e3o", 150, true));
        colunas.add(new ColunaSQL("statusretorno", "stretorno_inutilizacao", "Status Retorno", 100, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_inutnfce"}));
        colunas.add(new ColunaSQL("mensagemretorno", "msgretorno_inutilizacao", "Mensagem Retorno", 400, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_inutnfce"}));
        colunas.add(new ColunaSQL("codigoerro", "C\u00f3digo do erro", 150, true));
        colunas.add(new ColunaSQL("mensagemexcecao", "Mensagem erro interno", 400, true));
        colunas.add(new ColunaSQL("tipoambiente", "tipoambiente_inutilizacao", "Ambiente", 130, true, EnumJoin.RIGHT_JOIN, new String[]{"fk_pendencianfe_inutnfce"}));
        GridBuilder controler = new GridBuilder(((PendenciaNfeRN)this.rn).getTabela(), colunas, "pendenciainutilizacaonfce_v2");
        controler.addCodicaoDefault(new Condicao("situacao_", Operador.CONTIDO_EM, new Integer[]{SituacaoInutilizacaoNfce.AUTORIZANDO.getId(), SituacaoInutilizacaoNfce.ERRO_NA_INUTILIZACAO.getId()}));
        controler.addCodicaoDefault(new Condicao("filial_", Operador.IGUAL, SessaoUtil.getSessao().getCodigoFilial()));
        controler.addCodicaoDefault(new Condicao(OperadorLogico.E));
        controler.addCodicaoDefault(new Condicao(Separador.ABRE_PARENTESIS));
        controler.addCodicaoDefault(new Condicao("codigorejeicao_", Operador.IGUAL, 0));
        controler.addCodicaoDefault(new Condicao(OperadorLogico.OU));
        controler.addCodicaoDefault(new Condicao("codigorejeicao_", Operador.IS_NULL));
        controler.addCodicaoDefault(new Condicao(Separador.FECHA_PARENTESIS));
        controler.addOrdem(new Ordem("data_"));
        controler.addOrdem(new Ordem("serie_"));
        controler.addOrdem(new Ordem("numero_"));
        return controler;
    }

    @RequestMapping(value={"/buscar-operacao"})
    @DBAutoCommit
    public List<Long> buscarOperacaoPorInutilizacao(@RequestParam Long idInutilizacao) {
        InutilizacaoNfce inut = (InutilizacaoNfce)InutilizacaoNfceRN.getInstance().buscarPorId(idInutilizacao);
        List nfces = OperacaoNfceRN.getInstance().buscarListaPorNumeroDocumento(inut.getFilial(), inut.getSerie(), inut.getNumero(), inut.getTipoAmbiente());
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Operacao nfce : nfces) {
            if (!Util.longNullOuZero((Long)nfce.getIdNfceSubstituta())) {
                ids.add(nfce.getIdNfceSubstituta());
                continue;
            }
            ids.add(nfce.getId());
        }
        return ids;
    }

    @RequestMapping(value={"/corrigir-numeracao"})
    @DBTransaction
    public String corrigirInutilizacoesNumeroUtilizado() throws UnicoMensagemUsuarioException {
        new CorrigiNfceEmDuplicidade().corrigirInutilizacoes();
        return "Opera\u00e7\u00e3o concluida";
    }
}

