/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.producao.registroproducao;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.core.uviewer.SaidaRelatorio;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.ProdutoNumeroSerie;
import br.intelidata.commons.domain.pojo.enuns.TipoAgrupamentoSeparacaoInsumos;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.enuns.TipoQuantidadeRegistroProducao;
import br.intelidata.commons.domain.pojo.producao.RegistroProducao;
import br.intelidata.commons.domain.pojo.producao.RegistroProducaoAjuste;
import br.intelidata.commons.domain.pojo.producao.RegistroProducaoInsumo;
import br.intelidata.commons.domain.pojo.producao.RegistroProducaoItem;
import br.intelidata.commons.domain.pojo.producao.TipoSubstituicaoInsumo;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.FichaTecnicaProdutoCommonRN;
import br.intelidata.commons.domain.regranegocio.RegistroProducaoAjusteRN;
import br.intelidata.commons.domain.regranegocio.RegistroProducaoInsumoRN;
import br.intelidata.commons.domain.regranegocio.RegistroProducaoItemRN;
import br.intelidata.commons.domain.regranegocio.RegistroProducaoRN;
import br.intelidata.commons.modulo.compras.relatorio.SeparacaoInsumosRelatorio;
import br.intelidata.commons.modulo.estoque.regranegocio.EstoqueNegativoRN;
import br.intelidata.commons.modulo.producao.regranegocio.FichaTecnicaProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.VariacaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.producao.registroproducao.InsumoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.producao.registroproducao.RegistroProducaoWrapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public class AbstractRegistroProducaoCrudController
extends CrudController<RegistroProducao, RegistroProducaoRN> {
    public AbstractRegistroProducaoCrudController() {
        super((AbstractRegraNegocio)RegistroProducaoRN.getInstance(), RegistroProducao::new, true, true);
    }

    protected String getCacheId() {
        return "registro-producao".concat("_ID_FILIAL_").concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }

    protected GridBuilder<RegistroProducaoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("datahora", "Data", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 120, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("datahora", "Data", 0, true));
        colunas.add(new ColunaSQL("status", "Status", 0, true));
        GridBuilder grid = new GridBuilder(RegistroProducaoRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idfilial"));
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getFilial().getId()));
        grid.addOrdem(new Ordem("datahora", true));
        return grid;
    }

    protected void beforeRead(RegistroProducao registroProducao, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        List ajustes;
        registroProducao.setItens(RegistroProducaoItemRN.getInstance().buscaListaItensPorRegistroProducao(SessaoUtil.getSessao(), registroProducao.getId(), true, registroProducao.getIdLocalEstoqueInsumo(), true));
        if (modo == 1 && !ListMapUtil.listNullOrEmpty((List)(ajustes = RegistroProducaoAjusteRN.getInstance().buscaRegistrosProducaoAjuste(registroProducao.getId())))) {
            this.notificationService.simpleNotifyUserTenantNow(ContextoHolder.getTenant(), SessaoUtil.getSessao().getIdUsuario(), TipoNotificacaoSimples.WARNING, "Este registro de produ\u00e7\u00e3o j\u00e1 teve ajuste lan\u00e7ado! Ao alterar o registro de produ\u00e7\u00e3o, seus ajustes ser\u00e3o exclu\u00eddos!");
        }
        if (!ListMapUtil.listNullOrEmpty((List)registroProducao.getItens())) {
            for (RegistroProducaoItem item : registroProducao.getItens()) {
                if (ListMapUtil.listNullOrEmpty((List)item.getListaNumerosSerie())) continue;
                item.setNumerosSeries(item.getListaNumerosSerie().stream().map(ProdutoNumeroSerie::getNumeroserie).collect(Collectors.toList()));
            }
        }
    }

    protected void beforeSave(RegistroProducao registroProducao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (!ListMapUtil.listNullOrEmpty((List)registroProducao.getItens())) {
            for (RegistroProducaoItem item : registroProducao.getItens()) {
                if (ListMapUtil.listNullOrEmpty((List)item.getNumerosSeries())) continue;
                item.setListaNumerosSerie(item.getNumerosSeries().stream().map(str -> new ProdutoNumeroSerie(item.getIdProduto(), str)).collect(Collectors.toList()));
            }
        }
    }

    @RequestMapping(value={"/validar-popular-item"})
    @DBAutoCommit
    public RegistroProducaoItem validarPopularItem(@RequestBody InsumoWrapper wrapper) throws UnicoMensagemUsuarioException {
        RegistroProducaoItem item = wrapper.getRegistroProducaoItem();
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(item.getIdProduto());
        item.setQuantidadePadrao(produto.getQuantidadePadrao());
        item.setQuantidade(RegistroProducaoRN.getInstance().getQuantidadeProduzida(item, produto, item.getQuantidadeSolicitada(), item.getTipoQuantidade()));
        List insumosFicha = FichaTecnicaProdutoRN.getInstance().buscarListaPorIdProduto(produto.getId(), Integer.valueOf(0), SessaoUtil.getSessao().getIdFilial(), false);
        if (ListMapUtil.listNullOrEmpty((List)insumosFicha)) {
            throw new UnicoMensagemUsuarioException("WPRD79", "Este produto n\u00e3o cont\u00eam insumos!");
        }
        if (produto.isNumeroSerie() && ListMapUtil.listNullOrEmpty((List)item.getNumerosSeries())) {
            throw new UnicoMensagemUsuarioException("WPRD80", "Informe o n\u00famero de s\u00e9rie para este produto!");
        }
        if (produto.isPossuiVariacao() && VariacaoRN.getInstance().isVariacaoAtiva(produto.getId()) && StringUtil.stringNullOrEmpty((String)item.getVariacoes())) {
            throw new UnicoMensagemUsuarioException("WPRD81", "Informe varia\u00e7\u00e3o para este produto!");
        }
        if (produto.isPossuiLote() && ListMapUtil.listNullOrEmpty((List)item.getLotes()) && FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.LOTE)) {
            throw new UnicoMensagemUsuarioException("WPRD82", "Informe lote para este produto!");
        }
        if (!Util.listNullOrEmpty((List)insumosFicha)) {
            BigDecimal quantidadeBaixarInsumo = item.getQuantidadeSolicitada();
            if (TipoQuantidadeRegistroProducao.QUANTIDADE_FINAL.equals((Object)item.getTipoQuantidade())) {
                quantidadeBaixarInsumo = item.getQuantidadeSolicitada().divide(produto.getQuantidadePadrao(), 10, RoundingMode.HALF_EVEN).setScale(item.getQuantidadeSolicitada().scale(), RoundingMode.HALF_EVEN);
            }
            FichaTecnicaProdutoCommonRN.getInstance().validaInsumoQuebrado(SessaoUtil.getSessao(), insumosFicha, quantidadeBaixarInsumo);
        }
        HashMap mapUnidadeMedida = new HashMap();
        List insumos = RegistroProducaoInsumoRN.getInstance().buscarInsumosItem(SessaoUtil.getSessao(), item, item.getListaInsumosProducao(), mapUnidadeMedida, wrapper.getIdLocalEstoque());
        item.setListaInsumosProducao(insumos);
        return item;
    }

    @RequestMapping(value={"/validar-popular-insumo"})
    @DBAutoCommit
    public List<RegistroProducaoInsumo> validarPopularInsumo(@RequestBody InsumoWrapper wrapper) throws UnicoMensagemUsuarioException {
        BigDecimal quantidadeInsumoFicha;
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(wrapper.getIdProdutoSubstituto());
        BigDecimal quantidadeSubstituta = wrapper.getQuantidadeSubstituta();
        RegistroProducaoRN.getInstance().verificaFilhoDoSubInsumoSubstituido(SessaoUtil.getSessao(), wrapper.getInsumo().getIdProduto(), wrapper.getInsumos());
        FichaTecnicaProdutoCommonRN.getInstance().validaProdutoSubtituto(produto, quantidadeSubstituta);
        BigDecimal bigDecimal = quantidadeInsumoFicha = TipoSubstituicaoInsumo.SEM_SUBSTITUICAO.equals((Object)wrapper.getInsumo().getTipoSubstituicao()) ? wrapper.getInsumo().getQuantidadeNecessaria() : wrapper.getInsumo().getQuantidadeSubstituida();
        if (!wrapper.getInsumo().getIdProduto().equals(produto.getId())) {
            if (Util.longNullOuZero((Long)wrapper.getInsumo().getIdProdutoSubstituido())) {
                wrapper.getInsumo().setIdProdutoSubstituido(wrapper.getInsumo().getIdProduto());
                wrapper.getInsumo().setCodigoProdutoSubstituido(wrapper.getInsumo().getCodigoProduto());
                wrapper.getInsumo().setDescricaoProdutoSubstituido(wrapper.getInsumo().getDescricaoProduto());
                wrapper.getInsumo().setQuantidadeSubstituida(wrapper.getInsumo().getQuantidadeNecessaria());
            }
            wrapper.getInsumo().setTipoSubstituicao(TipoSubstituicaoInsumo.SUBSTITUICAO_INSUMO);
            wrapper.getInsumo().setIdProduto(produto.getId());
            wrapper.getInsumo().setCodigoProduto(produto.getCodigo());
            wrapper.getInsumo().setDescricaoProduto(produto.getNome());
            wrapper.getInsumo().setIdNovoProdutoSubstituto(produto.getId());
            wrapper.getInsumo().setCodigoNovoProdutoSubstituto(produto.getCodigo());
            wrapper.getInsumo().setDescricaoNovoProdutoSubstituto(produto.getNome());
            BigDecimal saldoEstoque = RegistroProducaoRN.getInstance().buscaSaldoEstoqueInsumoSubtituto(SessaoUtil.getSessao(), produto.getId(), wrapper.getIdLocalEstoque());
            wrapper.getInsumo().setSaldoEstoque(saldoEstoque);
            wrapper.getInsumo().setQuantidadeDisponivel(saldoEstoque);
            if (!produto.isPossuiLote()) {
                wrapper.getInsumo().setLotes(null);
            }
        } else if (quantidadeSubstituta.compareTo(quantidadeInsumoFicha) != 0) {
            wrapper.getInsumo().setTipoSubstituicao(TipoSubstituicaoInsumo.QUANTIDADE_ALTERADA_INSUMO);
            wrapper.getInsumo().setQuantidadeSubstituida(quantidadeInsumoFicha);
        } else {
            wrapper.getInsumo().setTipoSubstituicao(TipoSubstituicaoInsumo.SEM_SUBSTITUICAO);
            wrapper.getInsumo().setQuantidadeSubstituida(BigDecimal.ZERO);
        }
        wrapper.getInsumo().setQuantidadeNecessaria(quantidadeSubstituta);
        for (int i = 0; i < wrapper.getInsumos().size(); ++i) {
            RegistroProducaoInsumo insumoLista = (RegistroProducaoInsumo)wrapper.getInsumos().get(i);
            if (!insumoLista.getId().equals(wrapper.getInsumo().getId())) continue;
            wrapper.getInsumos().set(i, wrapper.getInsumo());
        }
        HashMap mapUnidadeMedida = new HashMap();
        return RegistroProducaoInsumoRN.getInstance().buscarInsumosItem(SessaoUtil.getSessao(), wrapper.getRegistroProducaoItem(), wrapper.getInsumos(), mapUnidadeMedida, wrapper.getIdLocalEstoque());
    }

    @RequestMapping(value={"/permite-substituir-insumo"})
    @DBAutoCommit
    public boolean podeSubstituirInsumo(@RequestBody InsumoWrapper wrapper) {
        return RegistroProducaoInsumoRN.getInstance().podeSubstituirInsumo(wrapper.getInsumo(), wrapper.getItens(), SessaoUtil.getSessao().getIdFilial());
    }

    @RequestMapping(value={"/desfazer-subtituicao"})
    @DBTransaction
    public List<RegistroProducaoInsumo> desfazerSubstituicao(@RequestBody InsumoWrapper wrapper) throws UnicoMensagemUsuarioException {
        if (!Util.longNullOuZero((Long)wrapper.getInsumo().getIdProdutoSubstituido())) {
            wrapper.getInsumo().setIdProduto(wrapper.getInsumo().getIdProdutoSubstituido());
            wrapper.getInsumo().setCodigoProduto(wrapper.getInsumo().getCodigoProdutoSubstituido());
            wrapper.getInsumo().setDescricaoProduto(wrapper.getInsumo().getDescricaoProdutoSubstituido());
            wrapper.getInsumo().setQuantidadeNecessaria(wrapper.getInsumo().getQuantidadeSubstituida());
            BigDecimal saldoEstoque = RegistroProducaoRN.getInstance().buscaSaldoEstoqueInsumoSubtituto(SessaoUtil.getSessao(), wrapper.getInsumo().getIdProdutoSubstituido(), wrapper.getIdLocalEstoque());
            wrapper.getInsumo().setSaldoEstoque(saldoEstoque);
            wrapper.getInsumo().setQuantidadeDisponivel(saldoEstoque);
            wrapper.getInsumo().setLotes(null);
        }
        wrapper.getInsumo().setIdProdutoSubstituido(null);
        wrapper.getInsumo().setTipoSubstituicao(TipoSubstituicaoInsumo.SEM_SUBSTITUICAO);
        wrapper.getInsumo().setDescricaoProdutoSubstituido(null);
        wrapper.getInsumo().setIdNovoProdutoSubstituto(null);
        wrapper.getInsumo().setCodigoNovoProdutoSubstituto(null);
        wrapper.getInsumo().setDescricaoNovoProdutoSubstituto(null);
        wrapper.getInsumo().setQuantidadeSubstituida(null);
        for (int i = 0; i < wrapper.getInsumos().size(); ++i) {
            RegistroProducaoInsumo insumoLista = (RegistroProducaoInsumo)wrapper.getInsumos().get(i);
            if (!insumoLista.getId().equals(wrapper.getInsumo().getId())) continue;
            wrapper.getInsumos().set(i, wrapper.getInsumo());
        }
        HashMap mapUnidadeMedida = new HashMap();
        return RegistroProducaoInsumoRN.getInstance().buscarInsumosItem(SessaoUtil.getSessao(), wrapper.getRegistroProducaoItem(), wrapper.getInsumos(), mapUnidadeMedida, wrapper.getIdLocalEstoque());
    }

    @RequestMapping(value={"/imprimir-separacao-insumos"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> imprimirSeparacaoInsumos(@RequestBody RegistroProducaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        List selecionados = wrapper.getIdsRegistroProducao().stream().map(idR -> (RegistroProducao)RegistroProducaoRN.getInstance().buscarPorId(idR)).collect(Collectors.toList());
        Remessa remessa = new SeparacaoInsumosRelatorio().getRelatorio(SessaoUtil.getSessao(), new SaidaRelatorio(), selecionados, SessaoUtil.getSessao().getFilial().getId(), TipoAgrupamentoSeparacaoInsumos.AGRUPADO_POR_ITEM.equals((Object)wrapper.getTipoAgrupamento()));
        return this.responseEntityService.createPDFResponse(remessa.getMalote().extrai("pdf"), "separacao_insumos");
    }

    @RequestMapping(value={"/produzir"}, method={RequestMethod.POST})
    @DBTransaction
    public void produzir(@RequestBody RegistroProducaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        List selecionados = wrapper.getIdsRegistroProducao().stream().map(idR -> (RegistroProducao)RegistroProducaoRN.getInstance().buscarPorId(idR)).collect(Collectors.toList());
        for (RegistroProducao reg : selecionados) {
            List insumos = RegistroProducaoInsumoRN.getInstance().buscaListaInsumosPorIdRegistroProducao(reg.getId());
            EstoqueNegativoRN.getInstance().validaEstoqueInsumosRegistroProducao(SessaoUtil.getSessao(), insumos, reg.getCodigo());
        }
        RegistroProducaoRN.getInstance().registraProducao(SessaoUtil.getSessao(), selecionados);
    }

    @RequestMapping(value={"/buscar-itens-ajuste"})
    @DBAutoCommit
    public List<RegistroProducaoAjuste> buscarItensParaAjuste(@RequestParam Long idRegistroProducao) throws UnicoMensagemUsuarioException {
        return RegistroProducaoAjusteRN.getInstance().buscarItensParaAjuste(idRegistroProducao);
    }

    @RequestMapping(value={"/gravar-ajuste"}, method={RequestMethod.POST})
    @DBTransaction
    public void gravarAjuste(@RequestBody RegistroProducaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        RegistroProducaoAjusteRN.getInstance().incluirItensAjusteProducao(SessaoUtil.getSessao(), wrapper.getAjustes());
    }

    protected void beforeDelete(RegistroProducao registro) throws UnicoMensagemUsuarioException {
        if (!Util.longNullOuZero((Long)registro.getIdNotaFiscalOrigem())) {
            throw new UnicoMensagemUsuarioException("WPRO189", "N\u00e3o \u00e9 poss\u00edvel excluir um registro de produ\u00e7\u00e3o que foi gerado a partir de uma nota fiscal.");
        }
        if (!Util.longNullOuZero((Long)registro.getIdOperacaoOrigem())) {
            throw new UnicoMensagemUsuarioException("WPRO186", "N\u00e3o \u00e9 poss\u00edvel excluir um registro de produ\u00e7\u00e3o que foi gerado a partir de uma opera\u00e7\u00e3o fiscal.");
        }
        registro.setItens(RegistroProducaoItemRN.getInstance().buscaListaItensPorRegistroProducao(SessaoUtil.getSessao(), registro.getId(), true, registro.getIdLocalEstoqueInsumo(), false));
    }

    protected void afterSave(RegistroProducao registroProducao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        super.afterSave((AbstractPojo)registroProducao, parentId);
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.LOCAL_ESTOQUE)) {
            PropriedadeRN.getInstance().setPropriedade(SessaoUtil.getSessao(), 818, registroProducao.getIdLocalEstoqueInsumo(), false);
        }
    }
}

